/*
 * Decompiled with CFR 0.152.
 */
package fr.vartax.module.jobs.data;

import fr.vartax.module.jobs.JobType;
import fr.vartax.module.jobs.data.JobData;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class PlayerJobData {
    private final UUID playerUUID;
    private final String playerName;
    private final Map<JobType, JobData> jobs;

    public PlayerJobData(UUID playerUUID, String playerName) {
        this.playerUUID = playerUUID;
        this.playerName = playerName;
        this.jobs = new HashMap<JobType, JobData>();
        for (JobType type : JobType.values()) {
            this.jobs.put(type, new JobData());
        }
    }

    public UUID getPlayerUUID() {
        return this.playerUUID;
    }

    public String getPlayerName() {
        return this.playerName;
    }

    public JobData getJobData(JobType type) {
        return this.jobs.get((Object)type);
    }

    public Map<JobType, JobData> getAllJobs() {
        return this.jobs;
    }

    public int getLevel(JobType type) {
        return this.jobs.get((Object)type).getLevel();
    }

    public void setLevel(JobType type, int level) {
        this.jobs.get((Object)type).setLevel(level);
    }

    public boolean addXP(JobType type, double amount) {
        return this.jobs.get((Object)type).addXP(amount);
    }

    public void removeXP(JobType type, double amount) {
        this.jobs.get((Object)type).removeXP(amount);
    }

    public void addLevels(JobType type, int levels) {
        JobData data = this.jobs.get((Object)type);
        data.setLevel(data.getLevel() + levels);
    }

    public void removeLevels(JobType type, int levels) {
        JobData data = this.jobs.get((Object)type);
        data.setLevel(Math.max(1, data.getLevel() - levels));
    }
}

