/*
 * Decompiled with CFR 0.152.
 */
package fr.vartax.module.jobs.display;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import fr.vartax.module.jobs.JobType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class JobNotificationRenderer
extends Gui {
    private static JobNotificationRenderer instance;
    private static boolean shouldShowNotification;
    private static int animationTimer;
    private static int displayTimer;
    private static int newLevel;
    private static JobType currentJob;
    private static final int ANIMATION_TIME = 20;
    private Minecraft mc = Minecraft.func_71410_x();

    private JobNotificationRenderer() {
        System.out.println("[Jobs] JobNotificationRenderer cr\u00e9\u00e9 !");
    }

    public static JobNotificationRenderer getInstance() {
        if (instance == null) {
            instance = new JobNotificationRenderer();
        }
        return instance;
    }

    public void showLevelUp(JobType job, int level) {
        System.out.println("[Jobs] showLevelUp appel\u00e9: " + job.name() + " niveau " + level);
        currentJob = job;
        newLevel = level;
        shouldShowNotification = true;
        animationTimer = 0;
        displayTimer = 100;
    }

    @SubscribeEvent
    public void onRender(RenderGameOverlayEvent event) {
        if (event.isCancelable() || event.type != RenderGameOverlayEvent.ElementType.EXPERIENCE) {
            return;
        }
        if (!shouldShowNotification || currentJob == null) {
            return;
        }
        ScaledResolution resolution = event.resolution;
        int width = resolution.func_78326_a();
        int height = resolution.func_78328_b();
        int notifWidth = 250;
        int notifHeight = 60;
        int targetX = width - notifWidth - 10;
        int startX = width + 10;
        float progress = 0.0f;
        if (animationTimer < 20) {
            progress = (float)animationTimer / 20.0f;
            progress = 1.0f - (1.0f - progress) * (1.0f - progress);
        } else {
            progress = 1.0f;
        }
        int currentX = (int)((float)startX + (float)(targetX - startX) * progress);
        int y = 70;
        float alpha = 1.0f;
        if (displayTimer < 20) {
            alpha = (float)displayTimer / 20.0f;
        }
        GL11.glPushMatrix();
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        int bgAlpha1 = (int)(alpha * 200.0f);
        int bgAlpha2 = (int)(alpha * 220.0f);
        int color1 = bgAlpha1 << 24 | 0x1A1A1A;
        int color2 = bgAlpha2 << 24 | 0x2A2A2A;
        this.func_73733_a(currentX, y, currentX + notifWidth, y + notifHeight, color1, color2);
        int borderAlpha = (int)(alpha * 255.0f);
        int borderColor = borderAlpha << 24 | 0xFFD700;
        this.drawBorder(currentX, y, notifWidth, notifHeight, 2, borderColor);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        String levelUpText = "\u00a76\u00a7lNIVEAU SUP\u00c9RIEUR !";
        String jobText = currentJob.getIcon() + " \u00a7e\u00a7l" + currentJob.getDisplayName();
        String levelText = "\u00a77Niveau \u00a7e\u00a7l" + newLevel;
        int centerX = currentX + notifWidth / 2;
        this.func_73732_a(this.mc.field_71466_p, levelUpText, centerX, y + 8, 16766720);
        this.func_73732_a(this.mc.field_71466_p, jobText, centerX, y + 23, 0xFFFFFF);
        this.func_73732_a(this.mc.field_71466_p, levelText, centerX, y + 38, 0xFFFFFF);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
        if (animationTimer < 20) {
            ++animationTimer;
        }
        if (--displayTimer <= 0) {
            this.resetNotification();
        }
    }

    private void drawBorder(int x, int y, int width, int height, int thickness, int color) {
        JobNotificationRenderer.func_73734_a((int)x, (int)y, (int)(x + width), (int)(y + thickness), (int)color);
        JobNotificationRenderer.func_73734_a((int)x, (int)(y + height - thickness), (int)(x + width), (int)(y + height), (int)color);
        JobNotificationRenderer.func_73734_a((int)x, (int)y, (int)(x + thickness), (int)(y + height), (int)color);
        JobNotificationRenderer.func_73734_a((int)(x + width - thickness), (int)y, (int)(x + width), (int)(y + height), (int)color);
    }

    private void resetNotification() {
        shouldShowNotification = false;
        animationTimer = 0;
        displayTimer = 100;
        newLevel = 0;
        currentJob = null;
        System.out.println("[Jobs] Notification reset");
    }

    static {
        shouldShowNotification = false;
        animationTimer = 0;
        displayTimer = 100;
        newLevel = 0;
    }
}

