/*
 * Decompiled with CFR 0.152.
 */
package fr.vartax.module.jobs.display;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import fr.vartax.module.jobs.JobType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class XPDisplayHandler
extends Gui {
    private static boolean shouldShowXP = false;
    private static int displayTimer = 160;
    private static double xpAccumulated = 0.0;
    public static JobType currentJob;
    private final Minecraft mc = Minecraft.func_71410_x();

    public XPDisplayHandler() {
        System.out.println("[Jobs] XPDisplayHandler cr\u00e9\u00e9 !");
    }

    public static void addXPGain(JobType job, double amount) {
        System.out.println("[Jobs Display] addXPGain appel\u00e9 ! Job=" + (Object)((Object)job) + " XP=" + amount);
        if (currentJob == null || currentJob != job) {
            currentJob = job;
            xpAccumulated = amount;
            shouldShowXP = true;
        } else {
            xpAccumulated += amount;
        }
        displayTimer = 160;
        System.out.println("[Jobs Display] Compteur XP=" + xpAccumulated);
    }

    @SubscribeEvent
    public void onRenderOverlay(RenderGameOverlayEvent.Post event) {
        if (event.type != RenderGameOverlayEvent.ElementType.ALL) {
            return;
        }
        if (!shouldShowXP || currentJob == null) {
            return;
        }
        ScaledResolution res = new ScaledResolution(this.mc, this.mc.field_71443_c, this.mc.field_71440_d);
        int width = res.func_78326_a();
        int x = width - 130;
        int y = 20;
        float alpha = 1.0f;
        if (displayTimer < 40) {
            alpha = (float)displayTimer / 40.0f;
        }
        GL11.glPushMatrix();
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        FontRenderer font = this.mc.field_71466_p;
        String jobText = "\u00a76" + currentJob.getIcon() + " " + currentJob.getDisplayName();
        String xpText = "\u00a7a+" + this.formatXP(xpAccumulated) + " XP";
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        font.func_78261_a(jobText, x, y, 16766720);
        font.func_78261_a(xpText, x, y + 12, 65280);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
        if (--displayTimer <= 0) {
            this.resetDisplay();
        }
    }

    private void resetDisplay() {
        System.out.println("[Jobs Display] Notification termin\u00e9e - XP totale gagn\u00e9e: " + xpAccumulated);
        shouldShowXP = false;
        displayTimer = 160;
        xpAccumulated = 0.0;
        currentJob = null;
    }

    private String formatXP(double xp) {
        if (xp % 1.0 == 0.0) {
            return String.valueOf((int)xp);
        }
        return String.format("%.1f", xp);
    }
}

