/*
 * Decompiled with CFR 0.152.
 */
package fr.vartax.module.jobs.event;

import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import fr.vartax.init.register.RegisterBlock;
import fr.vartax.module.jobs.JobType;
import fr.vartax.module.jobs.JobsSystem;
import fr.vartax.module.jobs.data.PlayerJobData;
import fr.vartax.module.jobs.manager.JobManager;
import fr.vartax.module.jobs.manager.JobRestrictions;
import fr.vartax.module.jobs.network.PacketJobNotification;
import fr.vartax.module.jobs.network.PacketLevelUp;
import fr.vartax.module.jobs.reward.JobsReward;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;

public class JobEventHandler {
    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        PlayerJobData data;
        if (event.world.field_72995_K) {
            return;
        }
        EntityPlayer player = event.getPlayer();
        Block block = event.block;
        JobRestrictions.JobRequirement req = JobRestrictions.getBreakRequirement(block);
        if (req != null && (data = JobManager.getInstance().getPlayerData(player)).getLevel(req.getJobType()) < req.getRequiredLevel()) {
            event.setCanceled(true);
            player.func_145747_a((IChatComponent)new ChatComponentText("\u00a7c[Jobs] \u00a77Niveau \u00a7e" + req.getRequiredLevel() + " " + req.getJobType().getDisplayName() + " \u00a77requis."));
            return;
        }
        data = JobManager.getInstance().getPlayerData(player);
        double xp = this.getMiningXP(block);
        if (xp <= 0.0) {
            return;
        }
        boolean levelUp = data.addXP(JobType.MINEUR, xp);
        if (levelUp) {
            this.handleLevelUp(player, JobType.MINEUR, data.getLevel(JobType.MINEUR));
        }
        if (player instanceof EntityPlayerMP) {
            PacketJobNotification notification = new PacketJobNotification(JobType.MINEUR, xp);
            JobsSystem.packetPipeline.sendTo(notification, (EntityPlayerMP)player);
        }
        JobManager.getInstance().saveData();
    }

    @SubscribeEvent
    public void onItemSmelted(PlayerEvent.ItemSmeltedEvent event) {
        EntityPlayer player = event.player;
        ItemStack smelted = event.smelting;
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        if (smelted == null) {
            return;
        }
        Item item = smelted.func_77973_b();
        double minerXP = this.getSmeltingMinerXP(item);
        if (minerXP > 0.0) {
            this.applyXP(player, JobType.MINEUR, minerXP * (double)smelted.field_77994_a);
            return;
        }
        double hunterXP = this.getSmeltingHunterXP(item);
        if (hunterXP > 0.0) {
            this.applyXP(player, JobType.HUNTER, hunterXP * (double)smelted.field_77994_a);
        }
    }

    @SubscribeEvent
    public void onItemPickup(EntityItemPickupEvent event) {
        if (event.entityPlayer.field_70170_p.field_72995_K) {
            return;
        }
        EntityPlayer player = event.entityPlayer;
        ItemStack stack = event.item.func_92059_d();
        if (stack == null) {
            return;
        }
        PlayerJobData data = JobManager.getInstance().getPlayerData(player);
        Item item = stack.func_77973_b();
        double farmXP = this.getFarmXP(stack);
        if (farmXP > 0.0) {
            this.applyXP(player, JobType.FARMER, farmXP);
            return;
        }
        double alchemyXP = this.getAlchemyXP(stack);
        if (alchemyXP > 0.0) {
            this.applyXP(player, JobType.ALCHIMISTE, alchemyXP);
        }
    }

    @SubscribeEvent
    public void onEntityKill(LivingDeathEvent event) {
        if (event.entity.field_70170_p.field_72995_K) {
            return;
        }
        if (!(event.source.func_76346_g() instanceof EntityPlayer)) {
            return;
        }
        if (event.entity instanceof EntityPlayer) {
            return;
        }
        EntityPlayer player = (EntityPlayer)event.source.func_76346_g();
        double xp = JobType.HUNTER.getXP(event.entity);
        if (xp <= 0.0) {
            return;
        }
        this.applyXP(player, JobType.HUNTER, xp);
    }

    @SubscribeEvent
    public void onItemRightClick(PlayerInteractEvent event) {
        PlayerJobData data;
        if (event.entityPlayer.field_70170_p.field_72995_K) {
            return;
        }
        if (event.action != PlayerInteractEvent.Action.RIGHT_CLICK_AIR && event.action != PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        ItemStack stack = event.entityPlayer.func_71045_bC();
        if (stack == null) {
            return;
        }
        JobRestrictions.JobRequirement req = JobRestrictions.getRightClickRequirement(stack.func_77973_b());
        if (req != null && (data = JobManager.getInstance().getPlayerData(event.entityPlayer)).getLevel(req.getJobType()) < req.getRequiredLevel()) {
            event.setCanceled(true);
            event.entityPlayer.func_145747_a((IChatComponent)new ChatComponentText("\u00a7c[Jobs] \u00a77Niveau \u00a7e" + req.getRequiredLevel() + " " + req.getJobType().getDisplayName() + " \u00a77requis pour utiliser cet item !"));
        }
    }

    private void applyXP(EntityPlayer player, JobType type, double xp) {
        PlayerJobData data = JobManager.getInstance().getPlayerData(player);
        boolean levelUp = data.addXP(type, xp);
        if (player instanceof EntityPlayerMP) {
            PacketJobNotification notification = new PacketJobNotification(type, xp);
            JobsSystem.packetPipeline.sendTo(notification, (EntityPlayerMP)player);
        }
        if (levelUp) {
            this.handleLevelUp(player, type, data.getLevel(type));
        }
        JobManager.getInstance().saveData();
    }

    private void handleLevelUp(EntityPlayer player, JobType type, int level) {
        player.func_145747_a((IChatComponent)new ChatComponentText("\u00a76\u00a7l\u2726 NIVEAU SUP\u00c9RIEUR ! \u00a7e" + type.getDisplayName() + " \u00a77\u2192 \u00a7e" + level));
        if (player instanceof EntityPlayerMP) {
            JobsSystem.packetPipeline.sendTo(new PacketLevelUp(type, level), (EntityPlayerMP)player);
        }
        JobsReward.giveRewards(player, type, level);
    }

    private double getMiningXP(Block block) {
        if (block == Blocks.field_150348_b || block == Blocks.field_150347_e) {
            return 0.5;
        }
        if (block == Blocks.field_150365_q) {
            return 0.7;
        }
        if (block == Blocks.field_150366_p) {
            return 0.8;
        }
        if (block == Blocks.field_150352_o) {
            return 0.9;
        }
        if (block == Blocks.field_150482_ag) {
            return 1.0;
        }
        if (block == Blocks.field_150412_bA) {
            return 1.2;
        }
        if (block == Blocks.field_150343_Z) {
            return 1.5;
        }
        if (block == RegisterBlock.titane_ore) {
            return 2.5;
        }
        if (block == RegisterBlock.jade_ore) {
            return 2.0;
        }
        if (block == RegisterBlock.vartox_ore) {
            return 3.0;
        }
        return 0.0;
    }

    private double getSmeltingMinerXP(Item item) {
        if (item == Items.field_151042_j) {
            return 1.0;
        }
        if (item == Items.field_151043_k) {
            return 1.2;
        }
        if (item == Item.func_150898_a((Block)Blocks.field_150359_w)) {
            return 0.3;
        }
        if (item == Items.field_151118_aC) {
            return 0.2;
        }
        return 0.0;
    }

    private double getSmeltingHunterXP(Item item) {
        if (item == Items.field_151083_be) {
            return 1.0;
        }
        if (item == Items.field_151157_am) {
            return 1.0;
        }
        if (item == Items.field_151077_bg) {
            return 0.8;
        }
        if (item == Items.field_151101_aQ) {
            return 0.8;
        }
        return 0.0;
    }

    private double getFarmXP(ItemStack stack) {
        Item item = stack.func_77973_b();
        if (item == Items.field_151015_O) {
            return 0.5;
        }
        if (item == Items.field_151172_bF || item == Items.field_151174_bG) {
            return 0.4;
        }
        if (item == Items.field_151127_ba) {
            return 0.6;
        }
        return 0.0;
    }

    private double getAlchemyXP(ItemStack stack) {
        Item item = stack.func_77973_b();
        if (item == Items.field_151075_bm) {
            return 0.5;
        }
        if (item == Items.field_151065_br) {
            return 1.0;
        }
        if (item == Items.field_151073_bk) {
            return 1.5;
        }
        if (item == Item.func_150898_a((Block)Blocks.field_150328_O)) {
            return 0.5;
        }
        if (item == Item.func_150898_a((Block)Blocks.field_150327_N)) {
            return 0.5;
        }
        if (item == Item.func_150898_a((Block)Blocks.field_150338_P)) {
            return 0.5;
        }
        if (item == Item.func_150898_a((Block)Blocks.field_150337_Q)) {
            return 0.5;
        }
        if (item == Item.func_150898_a((Block)Blocks.field_150434_aF)) {
            return 0.6;
        }
        if (item == Items.field_151120_aE) {
            return 0.5;
        }
        return 0.0;
    }
}

