/*
 * Decompiled with CFR 0.152.
 */
package fr.vartax.module.jobs.gui.jobs;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import fr.vartax.module.jobs.JobType;
import fr.vartax.module.jobs.data.ClientJobCache;
import fr.vartax.module.jobs.data.JobData;
import fr.vartax.module.jobs.data.PlayerJobData;
import fr.vartax.module.jobs.gui.GuiJobsMenu;
import fr.vartax.module.jobs.gui.button.GuiButtonWithTexture;
import java.util.ArrayList;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiJobMineur
extends GuiScreen {
    private static final ResourceLocation TEXTURE = new ResourceLocation("vartacraft", "textures/gui/jobs/jobs_unified.png");
    private static final ResourceLocation RETURN = new ResourceLocation("vartacraft", "textures/gui/return.png");
    private final EntityPlayer player;
    private PlayerJobData playerData;
    private int guiWidth = 256;
    private int guiHeight = 166;
    private int guiLeft;
    private int guiTop;
    private int iconSize = 20;
    private int iconSpacing = 50;

    public GuiJobMineur(EntityPlayer player) {
        this.player = player;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.guiLeft = (this.field_146294_l - this.guiWidth) / 2;
        this.guiTop = (this.field_146295_m - this.guiHeight) / 2;
        this.field_146292_n.clear();
        ClientJobCache.getInstance().initCache(this.player.func_110124_au(), this.player.func_70005_c_());
        this.playerData = ClientJobCache.getInstance().getCachedData();
        if (this.playerData == null) {
            this.playerData = new PlayerJobData(this.player.func_110124_au(), this.player.func_70005_c_());
        }
        this.field_146292_n.add(new GuiButtonWithTexture(0, this.guiLeft + 10, this.guiTop + 10, 20, 15, RETURN));
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(TEXTURE);
        this.func_73729_b(this.guiLeft, this.guiTop, 0, 0, this.guiWidth, this.guiHeight);
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.playerData = ClientJobCache.getInstance().getCachedData();
        if (this.playerData != null) {
            this.drawJobInfo();
        }
        this.drawTooltipIcons(mouseX, mouseY);
    }

    private void drawJobInfo() {
        JobData data = this.playerData.getJobData(JobType.MINEUR);
        String title = "Mineur";
        int titleWidth = this.field_146289_q.func_78256_a(title);
        this.func_73731_b(this.field_146289_q, title, this.guiLeft + (this.guiWidth - titleWidth) / 2, this.guiTop + 15, 0xFFFFFF);
        int infoX = this.guiLeft + 50;
        int infoY = this.guiTop + 35;
        this.func_73731_b(this.field_146289_q, "Niveau: " + data.getLevel() + " / 20", infoX, infoY, 0xFFFFFF);
        this.drawProgressBar(infoX, infoY += 15, 150, 12, data.getProgressPercentage(), data.getCurrentXP(), data.getXPForNextLevel());
    }

    private void drawProgressBar(int x, int y, int width, int height, double progress, double currentXP, double nextXP) {
        GuiJobMineur.func_73734_a((int)x, (int)y, (int)(x + width), (int)(y + height), (int)-13421773);
        int fillWidth = (int)((double)(width - 2) * (progress / 100.0));
        if (fillWidth > 0) {
            int color = progress < 50.0 ? -22016 : -16711936;
            GuiJobMineur.func_73734_a((int)(x + 1), (int)(y + 1), (int)(x + 1 + fillWidth), (int)(y + height - 1), (int)color);
        }
        String xpText = String.format("XP: %.1f / %.1f", currentXP, nextXP);
        int textWidth = this.field_146289_q.func_78256_a(xpText);
        this.func_73731_b(this.field_146289_q, xpText, x + (width - textWidth) / 2, y + 2, 0xFFFFFF);
    }

    private void drawTooltipIcons(int mouseX, int mouseY) {
        int totalWidth = this.iconSize * 3 + this.iconSpacing * 2;
        int startX = this.guiLeft + (this.guiWidth - totalWidth) / 2;
        int startY = this.guiTop + this.guiHeight - this.iconSize - 10;
        int craftX = startX;
        int craftY = startY;
        this.renderItem(new ItemStack(Blocks.field_150462_ai), craftX, craftY);
        if (this.isMouseOver(mouseX, mouseY, craftX, craftY, this.iconSize, this.iconSize)) {
            ArrayList<String> tooltip = new ArrayList<String>();
            tooltip.add("\u00a7e\u00a7lGains d'XP - Minage");
            tooltip.add("");
            tooltip.add("\u00a77\u26cf Pierre/Cobble: \u00a7a+0.5 XP");
            tooltip.add("\u00a77\u26cf Charbon: \u00a7a+0.7 XP");
            tooltip.add("\u00a77\u26cf Fer: \u00a7a+0.8 XP");
            tooltip.add("\u00a77\u26cf Or: \u00a7a+0.9 XP");
            tooltip.add("\u00a77\u26cf Diamant: \u00a7a+1.0 XP");
            tooltip.add("\u00a77\u26cf \u00c9meraude: \u00a7a+1.2 XP");
            tooltip.add("\u00a77\u26cf Obsidienne: \u00a7a+1.5 XP");
            tooltip.add("");
            tooltip.add("\u00a76\u26cf Jade Ore: \u00a7a+2.0 XP");
            tooltip.add("\u00a76\u26cf Titane Ore: \u00a7a+2.5 XP");
            tooltip.add("\u00a76\u26cf Vartox Ore: \u00a7a+3.0 XP");
            this.drawHoveringText(tooltip, mouseX, mouseY, this.field_146289_q);
        }
        int smeltX = craftX + this.iconSize + this.iconSpacing;
        int smeltY = startY;
        this.renderItem(new ItemStack(Blocks.field_150460_al), smeltX, smeltY);
        if (this.isMouseOver(mouseX, mouseY, smeltX, smeltY, this.iconSize, this.iconSize)) {
            ArrayList<String> tooltip = new ArrayList<String>();
            tooltip.add("\u00a7e\u00a7lGains d'XP - Cuisson");
            tooltip.add("");
            tooltip.add("\u00a77\ud83d\udd25 Fer fondu: \u00a7a+1.0 XP");
            tooltip.add("\u00a77\ud83d\udd25 Or fondu: \u00a7a+1.2 XP");
            tooltip.add("\u00a77\ud83d\udd25 Verre: \u00a7a+0.3 XP");
            tooltip.add("\u00a77\ud83d\udd25 Brique: \u00a7a+0.2 XP");
            tooltip.add("");
            tooltip.add("\u00a78\ud83d\udca1 L'XP est multipli\u00e9e par");
            tooltip.add("\u00a78   le nombre d'items fondus !");
            this.drawHoveringText(tooltip, mouseX, mouseY, this.field_146289_q);
        }
        int levelX = smeltX + this.iconSize + this.iconSpacing;
        int levelY = startY;
        this.renderItem(new ItemStack(Items.field_151156_bN), levelX, levelY);
        if (this.isMouseOver(mouseX, mouseY, levelX, levelY, this.iconSize, this.iconSize)) {
            ArrayList<String> tooltip = new ArrayList<String>();
            tooltip.add("\u00a7e\u00a7lNiveaux requis");
            tooltip.add("");
            tooltip.add("\u00a77Niveau 5:");
            tooltip.add("  \u00a78\u2192 D\u00e9bloquer Fer");
            tooltip.add("");
            tooltip.add("\u00a77Niveau 10:");
            tooltip.add("  \u00a78\u2192 D\u00e9bloquer Or");
            tooltip.add("  \u00a78\u2192 D\u00e9bloquer Diamant");
            tooltip.add("");
            tooltip.add("\u00a77Niveau 15:");
            tooltip.add("  \u00a78\u2192 D\u00e9bloquer \u00c9meraude");
            tooltip.add("");
            tooltip.add("\u00a77Niveau 20:");
            tooltip.add("  \u00a78\u2192 D\u00e9bloquer Obsidienne");
            tooltip.add("  \u00a78\u2192 D\u00e9bloquer minerais custom");
            this.drawHoveringText(tooltip, mouseX, mouseY, this.field_146289_q);
        }
    }

    private void renderItem(ItemStack stack, int x, int y) {
        GL11.glPushMatrix();
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glTranslatef((float)x, (float)y, (float)0.0f);
        GL11.glScalef((float)1.25f, (float)1.25f, (float)1.0f);
        field_146296_j.func_82406_b(this.field_146289_q, this.field_146297_k.func_110434_K(), stack, 0, 0);
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
    }

    private boolean isMouseOver(int mouseX, int mouseY, int x, int y, int width, int height) {
        return mouseX >= x && mouseX <= x + width && mouseY >= y && mouseY <= y + height;
    }

    protected void func_146284_a(GuiButton button) {
        if (button.field_146127_k == 0) {
            this.field_146297_k.func_147108_a((GuiScreen)new GuiJobsMenu(this.player));
        }
    }

    public boolean func_73868_f() {
        return false;
    }
}

