/*
 * Decompiled with CFR 0.152.
 */
package fr.vartax.module.jobs.manager;

import fr.vartax.module.jobs.JobType;
import fr.vartax.module.jobs.data.DatabaseManager;
import fr.vartax.module.jobs.data.PlayerJobData;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;

public class JobManager {
    private static JobManager instance;
    private final Map<UUID, PlayerJobData> playerDataCache = new HashMap<UUID, PlayerJobData>();
    private DatabaseManager database;

    private JobManager() {
    }

    public static JobManager getInstance() {
        if (instance == null) {
            instance = new JobManager();
        }
        return instance;
    }

    public void initialize(DatabaseManager database) {
        this.database = database;
        System.out.println("[Jobs] JobManager initialis\u00e9 avec MySQL");
    }

    public PlayerJobData getPlayerData(EntityPlayer player) {
        return this.getPlayerData(player.func_110124_au(), player.func_70005_c_());
    }

    public PlayerJobData getPlayerData(UUID uuid, String name) {
        if (this.playerDataCache.containsKey(uuid)) {
            return this.playerDataCache.get(uuid);
        }
        PlayerJobData data = this.loadPlayerFromDatabase(uuid, name);
        if (data == null) {
            data = new PlayerJobData(uuid, name);
            this.savePlayerToDatabase(data);
        }
        this.playerDataCache.put(uuid, data);
        return data;
    }

    /*
     * Exception decompiling
     */
    private PlayerJobData loadPlayerFromDatabase(UUID uuid, String name) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void savePlayerToDatabase(PlayerJobData data) {
        if (this.database == null || !this.database.isConnected()) {
            return;
        }
        String table = this.database.getConfig().getMySQLTable();
        String sql = "INSERT INTO `" + table + "` (`uuid`, `player_name`, `mineur_level`, `mineur_xp`, `farmer_level`, `farmer_xp`, `alchimiste_level`, `alchimiste_xp`, `hunter_level`, `hunter_xp`) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?) ON DUPLICATE KEY UPDATE `player_name` = VALUES(`player_name`), `mineur_level` = VALUES(`mineur_level`), `mineur_xp` = VALUES(`mineur_xp`), `farmer_level` = VALUES(`farmer_level`), `farmer_xp` = VALUES(`farmer_xp`), `alchimiste_level` = VALUES(`alchimiste_level`), `alchimiste_xp` = VALUES(`alchimiste_xp`), `hunter_level` = VALUES(`hunter_level`), `hunter_xp` = VALUES(`hunter_xp`)";
        try (Connection conn = this.database.getConnection();
             PreparedStatement stmt = conn.prepareStatement(sql);){
            stmt.setString(1, data.getPlayerUUID().toString());
            stmt.setString(2, data.getPlayerName());
            stmt.setInt(3, data.getJobData(JobType.MINEUR).getLevel());
            stmt.setDouble(4, data.getJobData(JobType.MINEUR).getCurrentXP());
            stmt.setInt(5, data.getJobData(JobType.FARMER).getLevel());
            stmt.setDouble(6, data.getJobData(JobType.FARMER).getCurrentXP());
            stmt.setInt(7, data.getJobData(JobType.ALCHIMISTE).getLevel());
            stmt.setDouble(8, data.getJobData(JobType.ALCHIMISTE).getCurrentXP());
            stmt.setInt(9, data.getJobData(JobType.HUNTER).getLevel());
            stmt.setDouble(10, data.getJobData(JobType.HUNTER).getCurrentXP());
            this.database.logQuery(sql);
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void saveData() {
        System.out.println("[Jobs] Sauvegarde de " + this.playerDataCache.size() + " joueurs...");
        for (PlayerJobData data : this.playerDataCache.values()) {
            this.savePlayerToDatabase(data);
        }
        System.out.println("[Jobs] Sauvegarde termin\u00e9e !");
    }

    public void unloadPlayer(UUID uuid) {
        if (this.playerDataCache.containsKey(uuid)) {
            this.savePlayerToDatabase(this.playerDataCache.get(uuid));
            this.playerDataCache.remove(uuid);
        }
    }

    public boolean canCraftItem(EntityPlayer player, JobType requiredJob, int requiredLevel) {
        PlayerJobData data = this.getPlayerData(player);
        return data.getLevel(requiredJob) >= requiredLevel;
    }
}

