/*
 * Decompiled with CFR 0.152.
 */
package fr.vartax.module.jobs.manager;

import fr.vartax.init.register.RegisterItems;
import fr.vartax.module.jobs.JobType;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class JobRestrictions {
    private static final Map<Item, JobRequirement> CRAFT_RESTRICTIONS = new HashMap<Item, JobRequirement>();
    private static final Map<Block, JobRequirement> BREAK_RESTRICTIONS = new HashMap<Block, JobRequirement>();
    private static final Map<Item, JobRequirement> RIGHT_CLICK_RESTRICTIONS = new HashMap<Item, JobRequirement>();

    private static void initCraftRestrictions() {
        CRAFT_RESTRICTIONS.put(RegisterItems.Chest_Finder, new JobRequirement(JobType.HUNTER, 10));
    }

    private static void initBreakRestrictions() {
    }

    public static JobRequirement getRightClickRequirement(Item item) {
        if (item == null) {
            return null;
        }
        return RIGHT_CLICK_RESTRICTIONS.get(item);
    }

    private static void initRightClickRestrictions() {
        RIGHT_CLICK_RESTRICTIONS.put(RegisterItems.dynamiteSilithium, new JobRequirement(JobType.HUNTER, 10));
    }

    public static JobRequirement getCraftRequirement(ItemStack stack) {
        if (stack == null) {
            return null;
        }
        return CRAFT_RESTRICTIONS.get(stack.func_77973_b());
    }

    public static JobRequirement getCraftRequirement(Item item) {
        if (item == null) {
            return null;
        }
        return CRAFT_RESTRICTIONS.get(item);
    }

    public static JobRequirement getBreakRequirement(Block block) {
        if (block == null) {
            return null;
        }
        return BREAK_RESTRICTIONS.get(block);
    }

    public static Map<Item, JobRequirement> getCraftRestrictions() {
        return CRAFT_RESTRICTIONS;
    }

    public static Map<Block, JobRequirement> getBreakRestrictions() {
        return BREAK_RESTRICTIONS;
    }

    static {
        JobRestrictions.initCraftRestrictions();
        JobRestrictions.initBreakRestrictions();
        JobRestrictions.initRightClickRestrictions();
    }

    public static class JobRequirement {
        private final JobType jobType;
        private final int requiredLevel;

        public JobRequirement(JobType jobType, int requiredLevel) {
            this.jobType = jobType;
            this.requiredLevel = requiredLevel;
        }

        public JobType getJobType() {
            return this.jobType;
        }

        public int getRequiredLevel() {
            return this.requiredLevel;
        }
    }
}

