/*
 * Decompiled with CFR 0.152.
 */
package fr.vartax.module.jobs.network;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import fr.vartax.module.jobs.JobType;
import fr.vartax.module.jobs.display.XPDisplayHandler;
import fr.vartax.module.jobs.network.AbstractPacket;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import net.minecraft.entity.player.EntityPlayer;

public class PacketJobNotification
extends AbstractPacket {
    private int jobTypeOrdinal;
    private double xpAmount;

    public PacketJobNotification() {
    }

    public PacketJobNotification(JobType jobType, double xpAmount) {
        this.jobTypeOrdinal = jobType.ordinal();
        this.xpAmount = xpAmount;
    }

    @Override
    public void encodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        buffer.writeInt(this.jobTypeOrdinal);
        buffer.writeDouble(this.xpAmount);
    }

    @Override
    public void decodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        this.jobTypeOrdinal = buffer.readInt();
        this.xpAmount = buffer.readDouble();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void handleClientSide(EntityPlayer player) {
        JobType jobType = JobType.values()[this.jobTypeOrdinal];
        XPDisplayHandler.addXPGain(jobType, this.xpAmount);
        System.out.println("[Jobs] Notification re\u00e7ue : " + jobType.getDisplayName() + " +" + this.xpAmount + " XP");
    }

    @Override
    public void handleServerSide(EntityPlayer player) {
    }
}

