/*
 * Decompiled with CFR 0.152.
 */
package fr.vartax.module.jobs.network;

import fr.vartax.module.jobs.JobType;
import fr.vartax.module.jobs.network.AbstractPacket;
import fr.vartax.module.jobs.notification.JobNotificationRenderer;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;

public class PacketLevelUp
extends AbstractPacket {
    private int jobTypeOrdinal;
    private int newLevel;

    public PacketLevelUp() {
    }

    public PacketLevelUp(JobType jobType, int newLevel) {
        this.jobTypeOrdinal = jobType.ordinal();
        this.newLevel = newLevel;
    }

    @Override
    public void encodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        buffer.writeInt(this.jobTypeOrdinal);
        buffer.writeInt(this.newLevel);
    }

    @Override
    public void decodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        this.jobTypeOrdinal = buffer.readInt();
        this.newLevel = buffer.readInt();
    }

    @Override
    public void handleClientSide(EntityPlayer player) {
        try {
            JobType jobType = JobType.values()[this.jobTypeOrdinal];
            JobNotificationRenderer.getInstance().showLevelUp(jobType, this.newLevel);
            player.func_145747_a((IChatComponent)new ChatComponentText("\u00a76\u00a7l\u2726 NIVEAU SUP\u00c9RIEUR ! \u00a7e" + jobType.getDisplayName() + " \u00a77\u2192 \u00a7e" + this.newLevel));
            System.out.println("[Jobs] Level up affich\u00e9 : " + jobType.name() + " niveau " + this.newLevel);
        }
        catch (Exception e) {
            System.err.println("[Jobs ERROR] Erreur PacketLevelUp client");
            e.printStackTrace();
        }
    }

    @Override
    public void handleServerSide(EntityPlayer player) {
    }
}

