/*
 * Decompiled with CFR 0.152.
 */
package fr.vartax.module.jobs.network;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import fr.vartax.module.jobs.JobType;
import fr.vartax.module.jobs.data.ClientJobCache;
import fr.vartax.module.jobs.data.JobData;
import fr.vartax.module.jobs.data.PlayerJobData;
import fr.vartax.module.jobs.network.AbstractPacket;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import net.minecraft.entity.player.EntityPlayer;

public class PacketSyncAllJobs
extends AbstractPacket {
    private int mineurLevel;
    private double mineurXP;
    private int farmerLevel;
    private double farmerXP;
    private int alchimisteLevel;
    private double alchimisteXP;
    private int hunterLevel;
    private double hunterXP;

    public PacketSyncAllJobs() {
    }

    public PacketSyncAllJobs(PlayerJobData playerData) {
        JobData mineurData = playerData.getJobData(JobType.MINEUR);
        this.mineurLevel = mineurData.getLevel();
        this.mineurXP = mineurData.getCurrentXP();
        JobData farmerData = playerData.getJobData(JobType.FARMER);
        this.farmerLevel = farmerData.getLevel();
        this.farmerXP = farmerData.getCurrentXP();
        JobData alchimisteData = playerData.getJobData(JobType.ALCHIMISTE);
        this.alchimisteLevel = alchimisteData.getLevel();
        this.alchimisteXP = alchimisteData.getCurrentXP();
        JobData hunterData = playerData.getJobData(JobType.HUNTER);
        this.hunterLevel = hunterData.getLevel();
        this.hunterXP = hunterData.getCurrentXP();
    }

    @Override
    public void encodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        buffer.writeInt(this.mineurLevel);
        buffer.writeDouble(this.mineurXP);
        buffer.writeInt(this.farmerLevel);
        buffer.writeDouble(this.farmerXP);
        buffer.writeInt(this.alchimisteLevel);
        buffer.writeDouble(this.alchimisteXP);
        buffer.writeInt(this.hunterLevel);
        buffer.writeDouble(this.hunterXP);
    }

    @Override
    public void decodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        this.mineurLevel = buffer.readInt();
        this.mineurXP = buffer.readDouble();
        this.farmerLevel = buffer.readInt();
        this.farmerXP = buffer.readDouble();
        this.alchimisteLevel = buffer.readInt();
        this.alchimisteXP = buffer.readDouble();
        this.hunterLevel = buffer.readInt();
        this.hunterXP = buffer.readDouble();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void handleClientSide(EntityPlayer player) {
        System.out.println("========================================");
        System.out.println("[Jobs] PACKET RE\u00c7U C\u00d4T\u00c9 CLIENT !");
        System.out.println("[Jobs] Mineur: Niv." + this.mineurLevel + " XP:" + this.mineurXP);
        System.out.println("========================================");
        PlayerJobData playerData = new PlayerJobData(player.func_110124_au(), player.func_70005_c_());
        JobData mineurData = playerData.getJobData(JobType.MINEUR);
        mineurData.setLevel(this.mineurLevel);
        mineurData.setCurrentXP(this.mineurXP);
        JobData farmerData = playerData.getJobData(JobType.FARMER);
        farmerData.setLevel(this.farmerLevel);
        farmerData.setCurrentXP(this.farmerXP);
        JobData alchimisteData = playerData.getJobData(JobType.ALCHIMISTE);
        alchimisteData.setLevel(this.alchimisteLevel);
        alchimisteData.setCurrentXP(this.alchimisteXP);
        JobData hunterData = playerData.getJobData(JobType.HUNTER);
        hunterData.setLevel(this.hunterLevel);
        hunterData.setCurrentXP(this.hunterXP);
        ClientJobCache.getInstance().updateCache(playerData);
        System.out.println("[Jobs] Cache client initialis\u00e9 : Mineur Niv." + this.mineurLevel + " XP:" + this.mineurXP);
        System.out.println("========================================");
    }

    @Override
    public void handleServerSide(EntityPlayer player) {
    }
}

