/*
 * Decompiled with CFR 0.152.
 */
package fr.vartax.module.jobs.network;

import fr.vartax.module.jobs.JobType;
import fr.vartax.module.jobs.data.ClientJobCache;
import fr.vartax.module.jobs.display.XPDisplayHandler;
import fr.vartax.module.jobs.network.AbstractPacket;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import net.minecraft.entity.player.EntityPlayer;

public class PacketSyncXP
extends AbstractPacket {
    private int jobTypeOrdinal;
    private double xpAmount;

    public PacketSyncXP() {
    }

    public PacketSyncXP(JobType jobType, double xpAmount) {
        this.jobTypeOrdinal = jobType.ordinal();
        this.xpAmount = xpAmount;
    }

    @Override
    public void encodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        buffer.writeInt(this.jobTypeOrdinal);
        buffer.writeDouble(this.xpAmount);
    }

    @Override
    public void decodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        this.jobTypeOrdinal = buffer.readInt();
        this.xpAmount = buffer.readDouble();
    }

    @Override
    public void handleClientSide(EntityPlayer player) {
        try {
            JobType jobType = JobType.values()[this.jobTypeOrdinal];
            ClientJobCache.getInstance().updateJobXP(jobType, this.xpAmount);
            XPDisplayHandler.addXPGain(jobType, this.xpAmount);
            System.out.println("[Jobs] XP synchronis\u00e9e : " + jobType.name() + " +" + this.xpAmount);
        }
        catch (Exception e) {
            System.err.println("[Jobs ERROR] Erreur PacketSyncXP client");
            e.printStackTrace();
        }
    }

    @Override
    public void handleServerSide(EntityPlayer player) {
    }
}

