/*
 * Decompiled with CFR 0.152.
 */
package fr.vartax.module.jobs.notification;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import fr.vartax.module.jobs.JobType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class JobNotificationRenderer {
    private static JobNotificationRenderer instance;
    private static final ResourceLocation NOTIFICATION_BG;
    private boolean isShowing = false;
    private JobType currentJob;
    private int newLevel;
    private int animationTick = 0;
    private int displayTime = 0;
    private static final int ANIMATION_TIME = 20;
    private static final int DISPLAY_TIME = 100;
    private static final int FADE_TIME = 20;

    private JobNotificationRenderer() {
    }

    public static JobNotificationRenderer getInstance() {
        if (instance == null) {
            instance = new JobNotificationRenderer();
        }
        return instance;
    }

    public void showLevelUp(JobType job, int level) {
        this.currentJob = job;
        this.newLevel = level;
        this.isShowing = true;
        this.animationTick = 0;
        this.displayTime = 100;
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (this.isShowing) {
            if (this.animationTick < 20) {
                ++this.animationTick;
            } else if (this.displayTime > 0) {
                --this.displayTime;
            } else {
                this.isShowing = false;
                this.animationTick = 0;
            }
        }
    }

    @SubscribeEvent
    public void onRenderGameOverlay(RenderGameOverlayEvent.Post event) {
        if (event.type != RenderGameOverlayEvent.ElementType.HOTBAR) {
            return;
        }
        if (!this.isShowing || this.currentJob == null) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        ScaledResolution scaled = new ScaledResolution(mc, mc.field_71443_c, mc.field_71440_d);
        FontRenderer font = mc.field_71466_p;
        int screenWidth = scaled.func_78326_a();
        int screenHeight = scaled.func_78328_b();
        int notifWidth = 250;
        int notifHeight = 60;
        int targetX = screenWidth - notifWidth - 10;
        int startX = screenWidth + 10;
        float progress = 0.0f;
        if (this.animationTick < 20) {
            progress = (float)this.animationTick / 20.0f;
            progress = this.easeOutBack(progress);
        } else {
            progress = 1.0f;
        }
        int currentX = (int)((float)startX + (float)(targetX - startX) * progress);
        int y = 10;
        float alpha = 1.0f;
        if (this.displayTime < 20) {
            alpha = (float)this.displayTime / 20.0f;
        }
        GL11.glPushMatrix();
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        this.drawNotificationBackground(currentX, y, notifWidth, notifHeight, alpha);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        String levelUpText = "\u00a76\u00a7lNIVEAU SUP\u00c9RIEUR !";
        String jobText = this.currentJob.getIcon() + " \u00a7e\u00a7l" + this.currentJob.getDisplayName();
        String levelText = "\u00a77Niveau \u00a7e\u00a7l" + this.newLevel;
        int textY = y + 8;
        this.drawCenteredString(font, levelUpText, currentX + notifWidth / 2, textY, (int)(alpha * 255.0f) << 24 | 0xFFD700);
        this.drawCenteredString(font, jobText, currentX + notifWidth / 2, textY + 20, (int)(alpha * 255.0f) << 24 | 0xFFFFFF);
        this.drawCenteredString(font, levelText, currentX + notifWidth / 2, textY + 35, (int)(alpha * 255.0f) << 24 | 0xFFFFFF);
        if (this.animationTick < 40) {
            this.drawParticles(currentX, y, notifWidth, notifHeight, this.animationTick, alpha);
        }
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private void drawNotificationBackground(int x, int y, int width, int height, float alpha) {
        int color1 = (int)(alpha * 200.0f) << 24 | 0x1A1A1A;
        int color2 = (int)(alpha * 220.0f) << 24 | 0x2A2A2A;
        this.drawGradientRect(x, y, x + width, y + height, color1, color2);
        int borderColor = (int)(alpha * 255.0f) << 24 | 0xFFD700;
        this.drawBorder(x, y, width, height, 2, borderColor);
        int glowColor = (int)(alpha * 100.0f) << 24 | 0xFFD700;
        this.drawGradientRect(x + 2, y + 2, x + width - 2, y + 15, glowColor, 0);
    }

    private void drawParticles(int x, int y, int width, int height, int tick, float alpha) {
        GL11.glDisable((int)3553);
        for (int i = 0; i < 8; ++i) {
            float particleProgress = (float)(tick + i * 5) / 40.0f;
            if (particleProgress > 1.0f) continue;
            int px = x + 20 + i * 25;
            int py = y + height - (int)(particleProgress * (float)height);
            float particleAlpha = alpha * (1.0f - particleProgress);
            int particleColor = (int)(particleAlpha * 200.0f) << 24 | 0xFFD700;
            this.drawRect(px, py, px + 3, py + 3, particleColor);
        }
        GL11.glEnable((int)3553);
    }

    private void drawBorder(int x, int y, int width, int height, int thickness, int color) {
        this.drawRect(x, y, x + width, y + thickness, color);
        this.drawRect(x, y + height - thickness, x + width, y + height, color);
        this.drawRect(x, y, x + thickness, y + height, color);
        this.drawRect(x + width - thickness, y, x + width, y + height, color);
    }

    private void drawRect(int left, int top, int right, int bottom, int color) {
        float alpha = (float)(color >> 24 & 0xFF) / 255.0f;
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        Tessellator tessellator = Tessellator.field_78398_a;
        GL11.glDisable((int)3553);
        tessellator.func_78382_b();
        tessellator.func_78369_a(red, green, blue, alpha);
        tessellator.func_78377_a((double)left, (double)bottom, 0.0);
        tessellator.func_78377_a((double)right, (double)bottom, 0.0);
        tessellator.func_78377_a((double)right, (double)top, 0.0);
        tessellator.func_78377_a((double)left, (double)top, 0.0);
        tessellator.func_78381_a();
        GL11.glEnable((int)3553);
    }

    private void drawGradientRect(int left, int top, int right, int bottom, int startColor, int endColor) {
        float sa = (float)(startColor >> 24 & 0xFF) / 255.0f;
        float sr = (float)(startColor >> 16 & 0xFF) / 255.0f;
        float sg = (float)(startColor >> 8 & 0xFF) / 255.0f;
        float sb = (float)(startColor & 0xFF) / 255.0f;
        float ea = (float)(endColor >> 24 & 0xFF) / 255.0f;
        float er = (float)(endColor >> 16 & 0xFF) / 255.0f;
        float eg = (float)(endColor >> 8 & 0xFF) / 255.0f;
        float eb = (float)(endColor & 0xFF) / 255.0f;
        GL11.glDisable((int)3553);
        GL11.glShadeModel((int)7425);
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78369_a(sr, sg, sb, sa);
        tessellator.func_78377_a((double)right, (double)top, 0.0);
        tessellator.func_78377_a((double)left, (double)top, 0.0);
        tessellator.func_78369_a(er, eg, eb, ea);
        tessellator.func_78377_a((double)left, (double)bottom, 0.0);
        tessellator.func_78377_a((double)right, (double)bottom, 0.0);
        tessellator.func_78381_a();
        GL11.glShadeModel((int)7424);
        GL11.glEnable((int)3553);
    }

    private void drawCenteredString(FontRenderer font, String text, int x, int y, int color) {
        font.func_78261_a(text, x - font.func_78256_a(text) / 2, y, color);
    }

    private float easeOutBack(float t) {
        float c1 = 1.70158f;
        float c3 = c1 + 1.0f;
        return 1.0f + c3 * (float)Math.pow(t - 1.0f, 3.0) + c1 * (float)Math.pow(t - 1.0f, 2.0);
    }

    static {
        NOTIFICATION_BG = new ResourceLocation("vartacraft", "textures/gui/notification.png");
    }
}

