/*
 * Decompiled with CFR 0.152.
 */
package fr.vartax.proxy.server;

import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import fr.vartax.Vartacraft;
import fr.vartax.future.BlockMod;
import fr.vartax.future.ItemMod;
import fr.vartax.future.ModEnchantments;
import fr.vartax.future.block.CoarseDirt;
import fr.vartax.future.block.GrassPath;
import fr.vartax.future.entity.EntityEndermite;
import fr.vartax.future.entity.EntityNewSnowGolem;
import fr.vartax.future.entity.EntityRabbit;
import fr.vartax.future.entity.EntityTippedArrow;
import fr.vartax.future.entity.EntityZombieVillager;
import fr.vartax.future.items.TippedArrow;
import fr.vartax.network.BlackHeartParticlesMessage;
import fr.vartax.proxy.server.EntityAIOpenCustomDoor;
import java.util.List;
import java.util.Random;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIOpenDoor;
import net.minecraft.entity.ai.EntityAITargetNonTamed;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.ai.EntityAITempt;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySnowman;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemShears;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.EntityStruckByLightningEvent;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.ArrowLooseEvent;
import net.minecraftforge.event.entity.player.ArrowNockEvent;
import net.minecraftforge.event.entity.player.EntityInteractEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.PlayerPickupXpEvent;
import net.minecraftforge.event.entity.player.UseHoeEvent;
import net.minecraftforge.event.world.BlockEvent;

public class ServerEventHandler {
    public static final ServerEventHandler INSTANCE = new ServerEventHandler();
    private Integer playerLoggedInCooldown = null;

    private ServerEventHandler() {
    }

    @SubscribeEvent
    public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        if (Vartacraft.enablePlayerSkinOverlay) {
            this.playerLoggedInCooldown = 20;
        }
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END || event.side != Side.SERVER) {
            // empty if block
        }
    }

    @SubscribeEvent
    public void onPlayerPickXP(PlayerPickupXpEvent event) {
        ModEnchantments.onPlayerPickupXP(event);
    }

    @SubscribeEvent
    public void livingUpdate(LivingEvent.LivingUpdateEvent event) {
        EntityZombie zombie;
        ModEnchantments.onLivingUpdate(event.entityLiving);
        if (Vartacraft.enableVillagerZombies && !event.entityLiving.field_70170_p.field_72995_K && event.entityLiving.getClass() == EntityZombie.class && (zombie = (EntityZombie)event.entityLiving).func_82231_m()) {
            EntityZombieVillager villagerZombie = new EntityZombieVillager(zombie.field_70170_p);
            villagerZombie.func_82149_j((Entity)zombie);
            villagerZombie.func_110161_a(null);
            villagerZombie.field_70170_p.func_72838_d((Entity)villagerZombie);
            zombie.func_70106_y();
        }
        if (Vartacraft.enableShearableGolems && !event.entityLiving.field_70170_p.field_72995_K && event.entityLiving.getClass() == EntitySnowman.class) {
            EntityNewSnowGolem golen = new EntityNewSnowGolem(event.entityLiving.field_70170_p);
            golen.func_82149_j((Entity)event.entityLiving);
            golen.func_110161_a(null);
            golen.field_70170_p.func_72838_d((Entity)golen);
            event.entityLiving.func_70106_y();
        }
    }

    @SubscribeEvent
    public void livingAttack(LivingAttackEvent event) {
        EntityDamageSourceIndirect dmgSrc;
        if (event.source instanceof EntityDamageSourceIndirect && (dmgSrc = (EntityDamageSourceIndirect)event.source).func_76364_f() instanceof EntityTippedArrow) {
            EntityTippedArrow tippedArrow = (EntityTippedArrow)dmgSrc.func_76364_f();
            if (!tippedArrow.field_70170_p.field_72995_K) {
                event.entityLiving.func_70690_d(tippedArrow.getEffect());
            }
        }
    }

    @SubscribeEvent
    public void arrowNock(ArrowNockEvent event) {
        if (event.result != null) {
            InventoryPlayer invt = event.entityPlayer.field_71071_by;
            for (int i = 0; i < invt.func_70302_i_(); ++i) {
                ItemStack stack = invt.func_70301_a(i);
                if (stack == null || stack.field_77994_a <= 0) continue;
                if (stack.func_77973_b() == Items.field_151032_g) {
                    return;
                }
                if (stack.func_77973_b() != ItemMod.tipped_arrow) continue;
                event.setCanceled(true);
                event.entityPlayer.func_71008_a(event.result, event.result.func_77973_b().func_77626_a(event.result));
                return;
            }
        }
    }

    @SubscribeEvent
    public void arrowLoose(ArrowLooseEvent event) {
        if (event.bow != null) {
            InventoryPlayer invt = event.entityPlayer.field_71071_by;
            for (int i = 0; i < invt.func_70302_i_(); ++i) {
                int punch;
                int power;
                ItemStack arrow = invt.func_70301_a(i);
                if (arrow == null || arrow.field_77994_a <= 0 || arrow.func_77973_b() != ItemMod.tipped_arrow) continue;
                float charge = (float)event.charge / 20.0f;
                if ((double)(charge = (charge * charge + charge * 2.0f) / 3.0f) < 0.1) {
                    return;
                }
                if (charge > 1.0f) {
                    charge = 1.0f;
                }
                EntityTippedArrow arrowEntity = new EntityTippedArrow(event.entityPlayer.field_70170_p, (EntityLivingBase)event.entityPlayer, charge * 2.0f);
                arrowEntity.setEffect(TippedArrow.getEffect(arrow));
                if (charge == 1.0f) {
                    arrowEntity.func_70243_d(true);
                }
                if ((power = EnchantmentHelper.func_77506_a((int)Enchantment.field_77345_t.field_77352_x, (ItemStack)event.bow)) > 0) {
                    arrowEntity.func_70239_b(arrowEntity.func_70242_d() + (double)power * 0.5 + 0.5);
                }
                if ((punch = EnchantmentHelper.func_77506_a((int)Enchantment.field_77344_u.field_77352_x, (ItemStack)event.bow)) > 0) {
                    arrowEntity.func_70240_a(punch);
                }
                if (EnchantmentHelper.func_77506_a((int)Enchantment.field_77343_v.field_77352_x, (ItemStack)event.bow) > 0) {
                    arrowEntity.func_70015_d(100);
                }
                event.bow.func_77972_a(1, (EntityLivingBase)event.entityPlayer);
                event.entityPlayer.field_70170_p.func_72956_a((Entity)event.entityPlayer, "random.bow", 1.0f, 1.0f / (event.entityPlayer.field_70170_p.field_73012_v.nextFloat() * 0.4f + 1.2f) + charge * 0.5f);
                if (!event.entityPlayer.field_71075_bZ.field_75098_d && --arrow.field_77994_a <= 0) {
                    event.entityPlayer.field_71071_by.func_70299_a(i, (ItemStack)null);
                }
                if (!event.entityPlayer.field_70170_p.field_72995_K) {
                    event.entityPlayer.field_70170_p.func_72838_d((Entity)arrowEntity);
                }
                event.setCanceled(true);
                return;
            }
        }
    }

    @SubscribeEvent
    public void harvestEvent(BlockEvent.HarvestDropsEvent event) {
        ItemStack stack;
        if (Vartacraft.enableSilkTouchingMushrooms && event.isSilkTouching) {
            if (event.block == Blocks.field_150420_aW) {
                event.drops.clear();
                event.drops.add(new ItemStack(BlockMod.brown_mushroom_block));
            } else if (event.block == Blocks.field_150419_aX) {
                event.drops.clear();
                event.drops.add(new ItemStack(BlockMod.red_mushroom_block));
            }
        }
        if (Vartacraft.enableSticksFromDeadBushes && event.block == Blocks.field_150330_I) {
            boolean isShears;
            boolean bl = isShears = event.harvester != null && event.harvester.func_71045_bC() != null && event.harvester.func_71045_bC().func_77973_b() instanceof ItemShears;
            if (event.harvester == null || event.harvester.func_71045_bC() == null || !isShears) {
                for (int i = 0; i < event.world.field_73012_v.nextInt(3); ++i) {
                    event.drops.add(new ItemStack(Items.field_151055_y));
                }
            }
        }
        if (Vartacraft.enableShearableCobwebs && event.block == Blocks.field_150321_G && event.harvester != null && (stack = event.harvester.func_71045_bC()) != null && stack.func_77973_b() instanceof ItemShears) {
            event.drops.clear();
            event.drops.add(new ItemStack(Blocks.field_150321_G));
        }
    }

    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent event) {
        GrassPath.onPlayerInteract(event);
    }

    @SubscribeEvent
    public void onHoeUseEvent(UseHoeEvent event) {
        CoarseDirt.onHoeEvent(event);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void dropEvent(LivingDropsEvent event) {
        if (!event.entityLiving.field_70170_p.field_72995_K && Vartacraft.enableSkullDrop) {
            this.dropHead(event.entityLiving, event.source, event.lootingLevel, event.drops);
        }
    }

    private void dropHead(EntityLivingBase entity, DamageSource source, int looting, List<EntityItem> drops) {
        int meta;
        if (this.isPoweredCreeper(source) && (meta = this.getHeadMetadata(entity)) >= 0) {
            this.addDrop(new ItemStack(Items.field_151144_bL, 1, meta), entity, drops);
        }
    }

    private void addDrop(ItemStack stack, EntityLivingBase entity, List<EntityItem> list) {
        if (stack.field_77994_a > 0) {
            EntityItem entityItem = new EntityItem(entity.field_70170_p, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, stack);
            entityItem.field_145804_b = 10;
            list.add(entityItem);
        }
    }

    private boolean isPoweredCreeper(DamageSource source) {
        Entity entity;
        if (source.func_94541_c() && source instanceof EntityDamageSource && (entity = ((EntityDamageSource)source).func_76346_g()) != null && entity instanceof EntityCreeper) {
            return ((EntityCreeper)entity).func_70830_n();
        }
        return false;
    }

    private int getHeadMetadata(EntityLivingBase entity) {
        if (entity.getClass() == EntityZombie.class) {
            return 2;
        }
        if (entity.getClass() == EntitySkeleton.class && ((EntitySkeleton)entity).func_82202_m() == 0) {
            return 0;
        }
        return entity.getClass() == EntityCreeper.class ? 4 : -1;
    }

    @SubscribeEvent
    public void teleportEvent(EnderTeleportEvent event) {
        EntityLivingBase entity;
        if (Vartacraft.enableEndermite && (entity = event.entityLiving) instanceof EntityPlayerMP && entity.func_70681_au().nextFloat() < 0.05f && entity.field_70170_p.func_82736_K().func_82766_b("doMobSpawning")) {
            EntityEndermite entityendermite = new EntityEndermite(entity.field_70170_p);
            entityendermite.setSpawnedByPlayer(true);
            entityendermite.func_70012_b(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, entity.field_70177_z, entity.field_70125_A);
            entity.field_70170_p.func_72838_d((Entity)entityendermite);
        }
    }

    @SubscribeEvent
    public void spawnEvent(EntityJoinWorldEvent event) {
        block3: {
            block5: {
                block4: {
                    block2: {
                        if (!(event.entity instanceof EntityPig)) break block2;
                        EntityPig pig = (EntityPig)event.entity;
                        if (!Vartacraft.enableBeetroot) break block3;
                        pig.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAITempt((EntityCreature)pig, 1.2, ItemMod.beetroot, false));
                        break block3;
                    }
                    if (!(event.entity instanceof EntityChicken)) break block4;
                    EntityChicken chicken = (EntityChicken)event.entity;
                    if (!Vartacraft.enableBeetroot) break block3;
                    chicken.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAITempt((EntityCreature)chicken, 1.0, ItemMod.beetroot_seeds, false));
                    break block3;
                }
                if (!(event.entity instanceof EntityWolf)) break block5;
                EntityWolf wolf = (EntityWolf)event.entity;
                if (!Vartacraft.enableRabbit) break block3;
                wolf.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAITargetNonTamed((EntityTameable)wolf, EntityRabbit.class, 200, false));
                break block3;
            }
            if (event.entity instanceof EntityVillager) {
                EntityVillager villager = (EntityVillager)event.entity;
                for (Object obj : villager.field_70714_bg.field_75782_a) {
                    EntityAITasks.EntityAITaskEntry entry = (EntityAITasks.EntityAITaskEntry)obj;
                    if (!(entry.field_75733_a instanceof EntityAIOpenDoor)) continue;
                    villager.field_70714_bg.func_85156_a(entry.field_75733_a);
                    villager.field_70714_bg.func_75776_a(entry.field_75731_b, (EntityAIBase)new EntityAIOpenCustomDoor((EntityLiving)villager, true));
                    break;
                }
            }
        }
    }

    @SubscribeEvent
    public void interactEntityEvent(EntityInteractEvent event) {
        ItemStack stack = event.entityPlayer.func_71045_bC();
        if (stack != null && event.target instanceof EntityAnimal) {
            EntityAnimal animal = (EntityAnimal)event.target;
            if (!animal.func_70631_g_()) {
                if (animal instanceof EntityPig) {
                    if (stack.func_77973_b() == ItemMod.beetroot && Vartacraft.enableBeetroot) {
                        this.setAnimalInLove(animal, event.entityPlayer, stack);
                    }
                } else if (animal instanceof EntityChicken && stack.func_77973_b() == ItemMod.beetroot_seeds && Vartacraft.enableBeetroot) {
                    this.setAnimalInLove(animal, event.entityPlayer, stack);
                }
            } else if (Vartacraft.enableBabyGrowthBoost && this.isFoodItem(animal, stack)) {
                this.feedBaby(animal, event.entityPlayer, stack);
            }
        }
    }

    private void setAnimalInLove(EntityAnimal animal, EntityPlayer player, ItemStack stack) {
        if (!animal.func_70880_s()) {
            animal.func_146082_f(player);
            if (!player.field_71075_bZ.field_75098_d && --stack.field_77994_a <= 0) {
                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, (ItemStack)null);
            }
        }
    }

    private void feedBaby(EntityAnimal animal, EntityPlayer player, ItemStack stack) {
        int currentAge = animal.func_70874_b();
        int age = (int)((float)(-currentAge) * 0.1f);
        animal.func_70873_a(currentAge + age);
        player.func_71038_i();
        Random itemRand = animal.field_70170_p.field_73012_v;
        for (int i = 0; i < 3; ++i) {
            double d0 = itemRand.nextGaussian() * 0.02;
            double d1 = itemRand.nextGaussian() * 0.02;
            double d2 = itemRand.nextGaussian() * 0.02;
            animal.field_70170_p.func_72869_a("happyVillager", animal.field_70165_t + (double)itemRand.nextFloat() * 0.5, animal.field_70163_u + 0.5 + (double)itemRand.nextFloat() * 0.5, animal.field_70161_v + (double)itemRand.nextFloat() * 0.5, d0, d1, d2);
        }
        if (!player.field_71075_bZ.field_75098_d && --stack.field_77994_a <= 0) {
            player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, (ItemStack)null);
        }
    }

    private boolean isFoodItem(EntityAnimal animal, ItemStack food) {
        if (animal.func_70877_b(food)) {
            return true;
        }
        if (animal instanceof EntityPig && food.func_77973_b() == ItemMod.beetroot && Vartacraft.enableBeetroot) {
            return true;
        }
        return animal instanceof EntityChicken && food.func_77973_b() == ItemMod.beetroot_seeds && Vartacraft.enableBeetroot;
    }

    @SubscribeEvent
    public void entityHurtEvent(LivingHurtEvent event) {
        EntityDamageSource src;
        Entity attacker;
        int amount;
        if (Vartacraft.enableDmgIndicator && (amount = MathHelper.func_76141_d((float)(Math.min(event.entityLiving.func_110143_aJ(), event.ammount) / 2.0f))) > 0 && event.source instanceof EntityDamageSource && (attacker = (src = (EntityDamageSource)event.source).func_76364_f()) instanceof EntityPlayer && !(attacker instanceof FakePlayer)) {
            EntityPlayer player = (EntityPlayer)attacker;
            Vec3 look = player.func_70040_Z();
            look.func_72442_b(1.5707964f);
            for (int i = 0; i < amount; ++i) {
                double x = event.entityLiving.field_70165_t - (double)amount * 0.35 * look.field_72450_a / 2.0 + (double)i * 0.35 * look.field_72450_a;
                double y = event.entityLiving.field_70163_u + 1.5 + event.entityLiving.field_70170_p.field_73012_v.nextGaussian() * 0.05;
                double z = event.entityLiving.field_70161_v - (double)amount * 0.35 * look.field_72449_c / 2.0 + (double)i * 0.35 * look.field_72449_c;
                Vartacraft.networkWrapper.sendToAllAround((IMessage)new BlackHeartParticlesMessage(x, y, z), new NetworkRegistry.TargetPoint(player.field_70170_p.field_73011_w.field_76574_g, x, y, z, 64.0));
            }
        }
    }

    @SubscribeEvent
    public void entityStruckByLightning(EntityStruckByLightningEvent event) {
        if (Vartacraft.enableVillagerTurnsIntoWitch && event.entity instanceof EntityVillager) {
            EntityVillager villager = (EntityVillager)event.entity;
            if (!villager.field_70170_p.field_72995_K) {
                EntityWitch witch = new EntityWitch(villager.field_70170_p);
                witch.func_82149_j((Entity)villager);
                witch.func_110161_a((IEntityLivingData)null);
                villager.field_70170_p.func_72838_d((Entity)witch);
                villager.func_70106_y();
            }
        }
    }
}

