/*
 * Decompiled with CFR 0.152.
 */
package fr.vartax.repackage.makamys.mclib.sloppydeploader;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class SloppyDepDownloadManager {
    private static BlockingQueue<Runnable> workQueue = new LinkedBlockingQueue<Runnable>();
    static ThreadPoolExecutor executor = new ThreadPoolExecutor(0, 1, 60L, TimeUnit.SECONDS, workQueue);
    static List<CompletableFuture<String>> futures = new ArrayList<CompletableFuture<String>>();

    public void enqueueDownload(Supplier task) {
        futures.add(CompletableFuture.supplyAsync(task, executor));
    }

    public boolean allDone() {
        return futures.stream().allMatch(f -> f.isDone());
    }

    public List<String> getDownloadedList() {
        if (!this.allDone()) {
            return Arrays.asList(new String[0]);
        }
        return futures.stream().map(f -> {
            try {
                return (String)f.get();
            }
            catch (Exception e) {
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

