/*
 * Decompiled with CFR 0.152.
 */
package fr.vartax.utils.guihandler;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import fr.vartax.utils.guihandler.GHandler;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class SimpleGHandler
extends GHandler {
    private Supplier<Object> clientSupplier;
    private Supplier<Container> serverSupplier;
    private Function<GuiHandlerData, Container> serverFunction;
    private Function<GuiHandlerData, Object> clientFunction;

    public SimpleGHandler(Supplier<Container> server, Supplier<Object> client) {
        this.serverSupplier = server;
        this.clientSupplier = client;
    }

    public SimpleGHandler(Function<GuiHandlerData, Container> serverFunction, Function<GuiHandlerData, Object> clientFunction) {
        this.serverFunction = serverFunction;
        this.clientFunction = clientFunction;
    }

    @Override
    @SideOnly(value=Side.SERVER)
    public Container getServerGuiElement(EntityPlayer player, World world, int x, int y, int z) {
        return this.serverSupplier != null ? this.serverSupplier.get() : this.serverFunction.apply(new GuiHandlerData(player, world, x, y, z));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getClientGuiElement(EntityPlayer player, World world, int x, int y, int z) {
        return this.clientSupplier != null ? (GuiScreen)this.clientSupplier.get() : (GuiScreen)this.clientFunction.apply(new GuiHandlerData(player, world, x, y, z));
    }

    public class GuiHandlerData {
        private final EntityPlayer player;
        private final World world;
        private final int x;
        private final int y;
        private final int z;

        public final <T extends TileEntity> T getTileEntity(Class<T> clazz) {
            TileEntity tile = this.world.func_147438_o(this.x, this.y, this.z);
            return (T)(tile != null && clazz.isInstance(tile) ? (TileEntity)clazz.cast(tile) : null);
        }

        public final InventoryPlayer getInventory() {
            return this.player.field_71071_by;
        }

        public EntityPlayer getPlayer() {
            return this.player;
        }

        public World getWorld() {
            return this.world;
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public int getZ() {
            return this.z;
        }

        public GuiHandlerData(EntityPlayer player, World world, int x, int y, int z) {
            this.player = player;
            this.world = world;
            this.x = x;
            this.y = y;
            this.z = z;
        }
    }
}

