/*
 * Decompiled with CFR 0.152.
 */
package fr.vartax.utils.helpers;

import fr.vartax.items.tools.SilithumHammer;
import java.util.HashMap;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class UpgradeHelper {
    public static HashMap<Integer, Integer> upgrades;
    public static HashMap<Integer, Integer> upgradeType;
    public static final int SMELT = 0;
    public static final int FORTUNE = 1;

    public static void init() {
        upgrades = new HashMap();
        upgradeType = new HashMap();
        upgrades.put(1, 3);
        upgradeType.put(1, 0);
        upgrades.put(0, 1);
        upgradeType.put(0, 0);
        upgrades.put(2, 3);
        upgradeType.put(2, 0);
        upgrades.put(3, 3);
        upgradeType.put(3, 1);
        upgrades.put(4, 1);
        upgradeType.put(4, 1);
        upgrades.put(5, 2);
        upgradeType.put(5, 1);
    }

    public static boolean canApplyUpgrade(ItemStack stack, int type, ItemStack tool) {
        if (UpgradeHelper.getMaxEnchants(tool) <= UpgradeHelper.getEnchants(tool)) {
            return false;
        }
        int toolType = -1;
        if (tool.func_77973_b() instanceof SilithumHammer) {
            toolType = 0;
        }
        if (UpgradeHelper.getModifier(tool, type) >= upgrades.get(type)) {
            return false;
        }
        return toolType == upgradeType.get(type);
    }

    private static int getEnchants(ItemStack stack) {
        UpgradeHelper.createDefaultNBT(stack);
        NBTTagCompound tag = stack.func_77978_p();
        return tag.func_74762_e("modifiersammount");
    }

    public static int getMaxEnchants(ItemStack stack) {
        UpgradeHelper.createDefaultNBT(stack);
        NBTTagCompound tag = stack.func_77978_p();
        return tag.func_74762_e("modifiersmax");
    }

    public static int getModifier(ItemStack stack, int type) {
        UpgradeHelper.createDefaultNBT(stack);
        NBTTagCompound tag = stack.func_77978_p();
        if (!tag.func_74764_b("upgradearray")) {
            tag.func_74783_a("upgradearray", new int[0]);
            return 0;
        }
        int[] upgrades = tag.func_74759_k("upgradearray");
        for (int i = 0; i < upgrades.length; i += 2) {
            if (upgrades[i] != type) continue;
            return upgrades[i + 1];
        }
        return 0;
    }

    public static void createDefaultNBT(ItemStack stack) {
        if (!stack.func_77942_o()) {
            int modifiers = 3;
            stack.func_77982_d(new NBTTagCompound());
            stack.func_77978_p().func_74768_a("modifiersammount", 0);
            stack.func_77978_p().func_74768_a("modifiersmax", modifiers);
        }
    }

    public static void applyUpgrade(ItemStack stack, int type) {
        UpgradeHelper.createDefaultNBT(stack);
        NBTTagCompound tag = stack.func_77978_p();
        if (!tag.func_74764_b("upgradearray")) {
            int[] var10000 = new int[]{type, 1};
            tag.func_74783_a("upgradearray", new int[2]);
        } else {
            int[] upgrades = tag.func_74759_k("upgradearray");
            for (int i = 0; i < upgrades.length; i += 2) {
                if (upgrades[i] != type) continue;
                int n = i + 1;
                upgrades[n] = upgrades[n] + 1;
                tag.func_74783_a("upgradearray", upgrades);
                tag.func_74768_a("modifiersammount", tag.func_74762_e("modifiersammount") + 1);
                return;
            }
            int[] array = new int[upgrades.length + 2];
            for (int j = 0; j < upgrades.length; ++j) {
                array[j] = upgrades[j];
            }
            array[array.length - 2] = type;
            array[array.length - 1] = 1;
            tag.func_74783_a("upgradearray", array);
            tag.func_74768_a("modifiersammount", tag.func_74762_e("modifiersammount") + 1);
        }
    }

    public static String getUpgradeName(int type) {
        if (type == 0) {
            return "Smelt";
        }
        return type == 1 ? "Fortune" : "";
    }

    public static int[] getUpgradeAmmount(ItemStack stack) {
        UpgradeHelper.createDefaultNBT(stack);
        NBTTagCompound tag = stack.func_77978_p();
        if (!tag.func_74764_b("upgradearray")) {
            tag.func_74783_a("upgradearray", new int[0]);
            return null;
        }
        return tag.func_74759_k("upgradearray");
    }
}

