/*
 * Decompiled with CFR 0.152.
 */
package fr.vartax.utils.particule;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import fr.vartax.utils.particule.ParticleData;
import fr.vartax.utils.renders.BarrierParticleFX;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.util.ReportedException;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

@SideOnly(value=Side.CLIENT)
public enum ParticleHandler {
    BARRIER((Class)BarrierParticleFX.class, ParticleData.VX_VY_VZ, new Class[]{Integer.TYPE, Float.TYPE, Integer.TYPE, ResourceLocation.class, Integer.TYPE}){
        private final ResourceLocation texture = new ResourceLocation("vartacraft:textures/blocks/barrier.png");

        @Override
        protected Object[] getAdditionalArgs(World world, Object ... data) {
            return new Object[]{80, Float.valueOf(0.45f), -1, this.texture, 1};
        }
    };

    private boolean shouldAssignColor = false;
    private static final int REGULAR_ARG_NUM = 4;
    private Constructor<? extends EntityFX> constructor;
    private ParticleData args;
    private Class<?>[] additionalArgTypes;
    private float r;
    private float g;
    private float b;

    private ParticleHandler(Class<? extends EntityFX> fxClass, ParticleData args, Class<?> ... additionalArgTypes) {
        if (this.r != -1.0f) {
            this.shouldAssignColor = true;
        }
        try {
            this.constructor = fxClass.getConstructor(ParticleHandler.getArgumentTypes(args, additionalArgTypes));
        }
        catch (Exception var9) {
            CrashReport crash = CrashReport.func_85055_a((Throwable)var9, (String)"Constructing VartacraftParticle");
            CrashReportCategory categoryArguments = crash.func_85058_a("Arguments");
            categoryArguments.func_71507_a("Class", fxClass);
            categoryArguments.func_71507_a("Particle Arg Types", (Object)args);
            categoryArguments.func_71507_a("Additional Arg Types", (Object)Arrays.toString(additionalArgTypes));
            throw new ReportedException(crash);
        }
        this.args = args;
        this.additionalArgTypes = additionalArgTypes;
    }

    private static Class<?>[] getArgumentTypes(ParticleData args, Class<?>[] additionalArgTypes) {
        Class[] argumentTypes = new Class[4 + args.getArgumentCount() + additionalArgTypes.length];
        argumentTypes[0] = World.class;
        argumentTypes[1] = Double.TYPE;
        argumentTypes[2] = Double.TYPE;
        argumentTypes[3] = Double.TYPE;
        System.arraycopy(args.getArgumentTypes(), 0, argumentTypes, 4, args.getArgumentCount());
        System.arraycopy(additionalArgTypes, 0, argumentTypes, 4 + args.getArgumentCount(), additionalArgTypes.length);
        return argumentTypes;
    }

    protected Object[] getAdditionalArgs(World world, Object ... data) {
        return new Object[0];
    }

    protected void onSpawn(EntityFX entityFX) {
    }

    public final void spawn(World world, double x, double y, double z) {
        this.spawn(world, x, y, z, 0.0, 0.0, 0.0, 1.0f, new Object[0]);
    }

    public final void spawn(World world, double x, double y, double z, double motionX, double motionY, double motionZ, float scale, Object ... data) {
        Object[] arguments = this.getArguments(world, x, y, z, motionX, motionY, motionZ, scale, data);
        try {
            EntityFX entityFX = this.constructor.newInstance(arguments);
            if (this.shouldAssignColor) {
                entityFX.func_70538_b(this.r, this.g, this.b);
            }
            this.onSpawn(entityFX);
            Minecraft.func_71410_x().field_71452_i.func_78873_a(entityFX);
        }
        catch (Exception var22) {
            CrashReport crash = CrashReport.func_85055_a((Throwable)var22, (String)"Constructing EntityFX");
            CrashReportCategory categorySpawnArguments = crash.func_85058_a("Spawn Arguments");
            categorySpawnArguments.func_71507_a("World", (Object)world);
            categorySpawnArguments.func_71507_a("X", (Object)x);
            categorySpawnArguments.func_71507_a("Y", (Object)y);
            categorySpawnArguments.func_71507_a("Z", (Object)z);
            categorySpawnArguments.func_71507_a("Motion X", (Object)motionX);
            categorySpawnArguments.func_71507_a("Motion Y", (Object)motionY);
            categorySpawnArguments.func_71507_a("Motion Z", (Object)motionZ);
            categorySpawnArguments.func_71507_a("Scale", (Object)Float.valueOf(scale));
            categorySpawnArguments.func_71507_a("Data", (Object)Arrays.deepToString(data));
            CrashReportCategory categoryEtFuturumParticle = crash.func_85058_a("vartacraftParticle");
            categoryEtFuturumParticle.func_71507_a("Constructor", this.constructor);
            categoryEtFuturumParticle.func_71507_a("Particle Arg Types", (Object)this.args);
            categoryEtFuturumParticle.func_71507_a("Additional Arg Types", (Object)Arrays.toString(this.additionalArgTypes));
            CrashReportCategory categoryArguments = crash.func_85058_a("Arguments");
            categoryArguments.func_71507_a("Arguments", (Object)Arrays.deepToString(arguments));
            throw new ReportedException(crash);
        }
    }

    private Object[] getArguments(World world, double x, double y, double z, double motionX, double motionY, double motionZ, float scale, Object ... data) {
        Object[] particleArgs = this.args.getArguments(motionX, motionY, motionZ, scale);
        Object[] additionalArgs = this.getAdditionalArgs(world, data);
        Object[] arguments = new Object[4 + this.args.getArgumentCount() + additionalArgs.length];
        arguments[0] = world;
        arguments[1] = x;
        arguments[2] = y;
        arguments[3] = z;
        System.arraycopy(particleArgs, 0, arguments, 4, this.args.getArgumentCount());
        System.arraycopy(additionalArgs, 0, arguments, 4 + this.args.getArgumentCount(), additionalArgs.length);
        return arguments;
    }

    private ParticleHandler(Class x2, ParticleData x3, Class[] x4, Object x5) {
        this((Class<? extends EntityFX>)x2, x3, x4);
    }
}

