/*
 * Decompiled with CFR 0.152.
 */
package fr.vartax.utils.renders;

import fr.vartax.utils.variable.AbstractClientPlayer;
import fr.vartax.utils.variable.Variables_Client;
import java.awt.Color;
import java.io.File;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.IImageBuffer;
import net.minecraft.client.renderer.ImageBufferDownload;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.ThreadDownloadImageData;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StringUtils;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

public class GuiUtils {
    private static final ResourceLocation beaconBeam = new ResourceLocation("textures/entity/beacon_beam.png");
    public static int gameColor = 0xFFFFFF;
    public static boolean dM = true;
    public static Tessellator tesselator;
    private static Minecraft mc;

    public static void renderCenteredText(String text, int posX, int posY) {
        GuiUtils.renderCenteredText(text, posX, posY, gameColor);
    }

    public static void renderCenteredTextWithShadow(String text, int posX, int posY) {
        GuiUtils.renderCenteredTextWithShadow(text, posX, posY, gameColor);
    }

    public static void renderCenteredText(String text, int posX, int posY, int par4) {
        Minecraft mc = Minecraft.func_71410_x();
        mc.field_71466_p.func_78276_b(text, posX - mc.field_71466_p.func_78256_a(text) / 2, posY, par4);
    }

    public static void renderCenteredTextWithShadow(String text, int posX, int posY, int par4) {
        Minecraft mc = Minecraft.func_71410_x();
        mc.field_71466_p.func_78261_a(text, posX - mc.field_71466_p.func_78256_a(text) / 2, posY, par4);
    }

    public static void renderText(String text, int posX, int posY) {
        GuiUtils.renderText(text, posX, posY, gameColor);
    }

    public static void renderTextWithShadow(String text, int posX, int posY) {
        GuiUtils.renderTextWithShadow(text, posX, posY, gameColor);
    }

    public static void renderSplitText(String text, int posX, int posY, int wrapWidth) {
        GuiUtils.renderSplitText(text, posX, posY, wrapWidth, gameColor);
    }

    public static void renderText(String text, int posX, int posY, int color) {
        Minecraft mc = Minecraft.func_71410_x();
        mc.field_71466_p.func_78276_b(text, posX, posY, color);
    }

    public static void drawTextWithOutline(String text, int x, int y, int color) {
        Minecraft mc = Minecraft.func_71410_x();
        FontRenderer fr = mc.field_71466_p;
        fr.func_78276_b(text, x - 1, y + 1, 0);
        fr.func_78276_b(text, x, y + 1, 0);
        fr.func_78276_b(text, x + 1, y + 1, 0);
        fr.func_78276_b(text, x - 1, y, 0);
        fr.func_78276_b(text, x + 1, y, 0);
        fr.func_78276_b(text, x - 1, y - 1, 0);
        fr.func_78276_b(text, x, y - 1, 0);
        fr.func_78276_b(text, x + 1, y - 1, 0);
        fr.func_78276_b(text, x, y, color);
    }

    public static void renderSmokeNadeSmoke(ResourceLocation par1, double par2, double par3, double par4, float par5, int width, int height, String color, double alpha) {
        EntityClientPlayerMP player = GuiUtils.mc.field_71439_g;
        GL11.glPushMatrix();
        float scale2 = 0.02f;
        float d0 = (float)(player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)par5);
        float d1 = (float)(player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)par5);
        float d2 = (float)(player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)par5);
        GL11.glTranslatef((float)((float)par2), (float)((float)par3), (float)((float)par4));
        GL11.glTranslatef((float)(-d0), (float)(-d1), (float)(-d2));
        GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glScalef((float)(-scale2), (float)(-scale2), (float)scale2);
        GL11.glDepthMask((boolean)false);
        GL11.glEnable((int)3042);
        float realTick = Variables_Client.swing;
        for (int i1 = 0; i1 < 4; ++i1) {
            float val = (float)Math.sin(realTick / 100.0f);
            if (i1 % 2 == 0) {
                val = -val;
            }
            for (int i = 0; i < 9; ++i) {
                GL11.glBlendFunc((int)770, (int)771);
                GL11.glEnable((int)3008);
                GuiUtils.renderImageTransparent(-width / 2, -height / 2, par1, width, height, alpha);
                GL11.glRotatef((float)64.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glRotatef((float)val, (float)1.0f, (float)0.0f, (float)0.0f);
            }
            GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        }
        GL11.glDepthMask((boolean)true);
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
    }

    public static void renderCenteredTextScaled(String text, int posX, int posY, double par4, int givenColor) {
        Minecraft mc = Minecraft.func_71410_x();
        double width = (double)(mc.field_71466_p.func_78256_a(text) / 2) * par4;
        GL11.glPushMatrix();
        GL11.glTranslated((double)((double)posX - width), (double)posY, (double)0.0);
        GL11.glScaled((double)par4, (double)par4, (double)par4);
        mc.field_71466_p.func_78276_b(text, 0, 0, givenColor);
        GL11.glPopMatrix();
    }

    public static void renderCenteredTextScaledWithOutlineFade(String text, int posX, int posY, double par4, int givenColor, double givenFade) {
        Minecraft mc = Minecraft.func_71410_x();
        double width = (double)(mc.field_71466_p.func_78256_a(text) / 2) * par4;
        GL11.glPushMatrix();
        GL11.glTranslated((double)((double)posX - width), (double)posY, (double)0.0);
        GL11.glScaled((double)par4, (double)par4, (double)par4);
        mc.field_71466_p.func_78276_b(EnumChatFormatting.BLACK + text, -1, -1, 0);
        mc.field_71466_p.func_78276_b(EnumChatFormatting.BLACK + text, 1, -1, 0);
        mc.field_71466_p.func_78276_b(EnumChatFormatting.BLACK + text, -1, 1, 0);
        mc.field_71466_p.func_78276_b(EnumChatFormatting.BLACK + text, 1, 1, 0);
        mc.field_71466_p.func_78276_b(EnumChatFormatting.BLACK + text, 0, -1, 0);
        mc.field_71466_p.func_78276_b(EnumChatFormatting.BLACK + text, -1, 0, 0);
        mc.field_71466_p.func_78276_b(EnumChatFormatting.BLACK + text, 1, 0, 0);
        mc.field_71466_p.func_78276_b(EnumChatFormatting.BLACK + text, 0, 1, 0);
        mc.field_71466_p.func_78276_b(text, 0, 0, givenColor);
        GL11.glPopMatrix();
    }

    public static void renderCenteredTextScaledWithOutline(String text, int posX, int posY, double par4, int givenColor) {
        Minecraft mc = Minecraft.func_71410_x();
        double width = (double)(mc.field_71466_p.func_78256_a(text) / 2) * par4;
        GL11.glPushMatrix();
        GL11.glTranslated((double)((double)posX - width), (double)posY, (double)0.0);
        GL11.glScaled((double)par4, (double)par4, (double)par4);
        mc.field_71466_p.func_78276_b(EnumChatFormatting.BLACK + text, -1, -1, 0);
        mc.field_71466_p.func_78276_b(EnumChatFormatting.BLACK + text, 1, -1, 0);
        mc.field_71466_p.func_78276_b(EnumChatFormatting.BLACK + text, -1, 1, 0);
        mc.field_71466_p.func_78276_b(EnumChatFormatting.BLACK + text, 1, 1, 0);
        mc.field_71466_p.func_78276_b(EnumChatFormatting.BLACK + text, 0, -1, 0);
        mc.field_71466_p.func_78276_b(EnumChatFormatting.BLACK + text, -1, 0, 0);
        mc.field_71466_p.func_78276_b(EnumChatFormatting.BLACK + text, 1, 0, 0);
        mc.field_71466_p.func_78276_b(EnumChatFormatting.BLACK + text, 0, 1, 0);
        mc.field_71466_p.func_78276_b(text, 0, 0, givenColor);
        GL11.glPopMatrix();
    }

    public static void drawTextScaled(String text, int posX, int posY, double givenScale, int givenColor) {
        GL11.glPushMatrix();
        GL11.glTranslated((double)posX, (double)posY, (double)0.0);
        GL11.glScaled((double)givenScale, (double)givenScale, (double)givenScale);
        GuiUtils.renderText(text, 0, 0, givenColor);
        GL11.glPopMatrix();
    }

    public static void renderTextScaled(String text, int posX, int posY, double par4) {
        GL11.glPushMatrix();
        GL11.glTranslated((double)posX, (double)posY, (double)0.0);
        GL11.glScaled((double)par4, (double)par4, (double)par4);
        GuiUtils.renderText(text, 0, 0);
        GL11.glPopMatrix();
    }

    public static void renderTextWithShadow(String text, int posX, int posY, int color) {
        Minecraft mc = Minecraft.func_71410_x();
        mc.field_71466_p.func_78261_a(text, posX, posY, color);
    }

    public static void renderSplitText(String text, int posX, int posY, int wrapWidth, int color) {
        Minecraft mc = Minecraft.func_71410_x();
        mc.field_71466_p.func_78279_b(text, posX, posY, wrapWidth, color);
    }

    public static void renderItemStackIntoGUI(ItemStack itemstack, int posX, int posY) {
        GL11.glPushMatrix();
        RenderItem itemRenderer = new RenderItem();
        itemRenderer.field_77024_a = true;
        itemRenderer.func_77015_a(Minecraft.func_71410_x().field_71466_p, Minecraft.func_71410_x().func_110434_K(), itemstack, posX, posY);
        itemRenderer.field_77024_a = false;
        GL11.glDisable((int)2896);
        GL11.glPopMatrix();
    }

    public static void renderColor(int par1) {
        Color color = Color.decode("" + par1);
        float red = (float)color.getRed() / 255.0f;
        float green = (float)color.getGreen() / 255.0f;
        float blue = (float)color.getBlue() / 255.0f;
        GL11.glColor3f((float)red, (float)green, (float)blue);
    }

    public static void renderColor(String par1) {
        Color color = Color.decode("" + par1);
        float red = (float)color.getRed() / 255.0f;
        float green = (float)color.getGreen() / 255.0f;
        float blue = (float)color.getBlue() / 255.0f;
        GL11.glColor3f((float)red, (float)green, (float)blue);
    }

    public static void drawImageNoColorChange(double x, double y, ResourceLocation image, double width, double height) {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(image);
        Tessellator tess = Tessellator.field_78398_a;
        GL11.glEnable((int)3042);
        GL11.glEnable((int)2832);
        GL11.glHint((int)3153, (int)4353);
        tess.func_78382_b();
        tess.func_78374_a(x, y + height, 0.0, 0.0, 1.0);
        tess.func_78374_a(x + width, y + height, 0.0, 1.0, 1.0);
        tess.func_78374_a(x + width, y, 0.0, 1.0, 0.0);
        tess.func_78374_a(x, y, 0.0, 0.0, 0.0);
        tess.func_78381_a();
        GL11.glDisable((int)3042);
        GL11.glDisable((int)2832);
    }

    public static void drawImageCenteredScaled(double x, double y, ResourceLocation image, double width, double height, double scale) {
        GL11.glPushMatrix();
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(image);
        GL11.glTranslated((double)(-width / 2.0 * scale * scale), (double)(-height / 2.0 * scale * scale), (double)0.0);
        GL11.glScaled((double)scale, (double)scale, (double)scale);
        Tessellator tess = Tessellator.field_78398_a;
        GL11.glEnable((int)3042);
        GL11.glEnable((int)2832);
        GL11.glHint((int)3153, (int)4353);
        tess.func_78382_b();
        tess.func_78374_a(x, y + height, 0.0, 0.0, 1.0);
        tess.func_78374_a(x + width, y + height, 0.0, 1.0, 1.0);
        tess.func_78374_a(x + width, y, 0.0, 1.0, 0.0);
        tess.func_78374_a(x, y, 0.0, 0.0, 0.0);
        tess.func_78381_a();
        GL11.glDisable((int)3042);
        GL11.glDisable((int)2832);
        GL11.glPopMatrix();
    }

    public static void drawImage(double x, double y, ResourceLocation image, double width, double height) {
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(image);
        Tessellator tess = Tessellator.field_78398_a;
        GL11.glEnable((int)3042);
        GL11.glEnable((int)2832);
        GL11.glHint((int)3153, (int)4353);
        tess.func_78382_b();
        tess.func_78374_a(x, y + height, 0.0, 0.0, 1.0);
        tess.func_78374_a(x + width, y + height, 0.0, 1.0, 1.0);
        tess.func_78374_a(x + width, y, 0.0, 1.0, 0.0);
        tess.func_78374_a(x, y, 0.0, 0.0, 0.0);
        tess.func_78381_a();
        GL11.glDisable((int)3042);
        GL11.glDisable((int)2832);
    }

    public static void drawImageTransparent(double x, double y, ResourceLocation image, double width, double height) {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(image);
        GL11.glColor4d((double)255.0, (double)255.0, (double)255.0, (double)255.0);
        Tessellator tess = Tessellator.field_78398_a;
        GL11.glEnable((int)3042);
        GL11.glEnable((int)2832);
        tess.func_78369_a(255.0f, 255.0f, 255.0f, 255.0f);
        tess.func_78382_b();
        tess.func_78374_a(x, y + height, 0.0, 0.0, 1.0);
        tess.func_78374_a(x + width, y + height, 0.0, 1.0, 1.0);
        tess.func_78374_a(x + width, y, 0.0, 1.0, 0.0);
        tess.func_78374_a(x, y, 0.0, 0.0, 0.0);
        tess.func_78381_a();
        GL11.glDisable((int)2832);
        GL11.glDisable((int)3042);
    }

    public static void drawImageTransparent(double x, double y, ResourceLocation image, double width, double height, double alpha) {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(image);
        GL11.glColor4d((double)255.0, (double)255.0, (double)255.0, (double)alpha);
        Tessellator tess = Tessellator.field_78398_a;
        GL11.glEnable((int)3042);
        GL11.glEnable((int)2832);
        tess.func_78369_a(255.0f, 0.0f, 0.0f, 0.5f);
        tess.func_78382_b();
        tess.func_78374_a(x, y + height, 0.0, 0.0, 1.0);
        tess.func_78374_a(x + width, y + height, 0.0, 1.0, 1.0);
        tess.func_78374_a(x + width, y, 0.0, 1.0, 0.0);
        tess.func_78374_a(x, y, 0.0, 0.0, 0.0);
        tess.func_78381_a();
        GL11.glDisable((int)2832);
        GL11.glDisable((int)3042);
    }

    public static void drawMenuBackground(double x, double y, ResourceLocation image, double width, double height) {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(image);
        Tessellator tess = Tessellator.field_78398_a;
        GL11.glEnable((int)3042);
        GL11.glEnable((int)2832);
        tess.func_78369_a(255.0f, 0.0f, 0.0f, 0.5f);
        tess.func_78382_b();
        tess.func_78374_a(x, y + height, 0.0, 0.0, 1.0);
        tess.func_78374_a(x + width, y + height, 0.0, 1.0, 1.0);
        tess.func_78374_a(x + width, y, 0.0, 1.0, 0.0);
        tess.func_78374_a(x, y, 0.0, 0.0, 0.0);
        tess.func_78381_a();
        GL11.glDisable((int)2832);
        GL11.glDisable((int)3042);
    }

    public static void drawPositionedImageInViewNoRot(ResourceLocation par1, double par2, double par3, double par4, float par5, int width, int height, double givenRotX, double givenRotY, double givenRotZ) {
        Minecraft mc = Minecraft.func_71410_x();
        EntityClientPlayerMP player = mc.field_71439_g;
        GL11.glPushMatrix();
        double d0 = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)par5;
        double d1 = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)par5;
        double d2 = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)par5;
        GL11.glTranslated((double)par2, (double)par3, (double)par4);
        GL11.glTranslated((double)(-d0), (double)(-d1), (double)(-d2));
        GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glScalef((float)-0.03f, (float)-0.03f, (float)0.03f);
        GL11.glDisable((int)2896);
        GL11.glDepthMask((boolean)false);
        GL11.glDisable((int)2929);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glRotated((double)givenRotX, (double)1.0, (double)0.0, (double)0.0);
        GL11.glRotated((double)givenRotY, (double)0.0, (double)1.0, (double)0.0);
        GL11.glRotated((double)givenRotZ, (double)0.0, (double)0.0, (double)1.0);
        GuiUtils.renderColor(0xFFFFFF);
        GuiUtils.drawImage(-width / 2, -height / 2, par1, width, height);
        GL11.glDepthMask((boolean)true);
        GL11.glEnable((int)2929);
        GL11.glEnable((int)2896);
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
    }

    public static void drawFlare(ResourceLocation par1, double par2, double par3, double par4, float par5, float width, float height, int givenR, int givenG, int givenB) {
        Minecraft mc = Minecraft.func_71410_x();
        EntityClientPlayerMP player = mc.field_71439_g;
        GL11.glPushMatrix();
        double d0 = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)par5;
        double d1 = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)par5;
        double d2 = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)par5;
        GL11.glTranslated((double)par2, (double)par3, (double)par4);
        GL11.glTranslated((double)(-d0), (double)(-d1), (double)(-d2));
        GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(-player.field_70177_z), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)player.field_70125_A, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glScalef((float)-0.03f, (float)-0.03f, (float)0.03f);
        GL11.glDisable((int)2896);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
        GL11.glColor3f((float)givenR, (float)givenG, (float)givenB);
        GuiUtils.drawImageNoColorChange(-width / 2.0f, -height / 2.0f, par1, width, height);
        GL11.glDepthMask((boolean)true);
        GL11.glEnable((int)2896);
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
    }

    public static void drawPositionedImageInView(ResourceLocation par1, double par2, double par3, double par4, float par5, float width, float height) {
        Minecraft mc = Minecraft.func_71410_x();
        EntityClientPlayerMP player = mc.field_71439_g;
        GL11.glPushMatrix();
        GL11.glTranslated((double)par2, (double)par3, (double)par4);
        GL11.glTranslated((double)(-RenderManager.field_78727_a.field_78730_l), (double)(-RenderManager.field_78727_a.field_78731_m), (double)(-RenderManager.field_78727_a.field_78728_n));
        GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(-player.field_70177_z), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)player.field_70125_A, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glScalef((float)-0.03f, (float)-0.03f, (float)0.03f);
        GL11.glDisable((int)2896);
        if (dM) {
            GL11.glDepthMask((boolean)false);
        }
        GL11.glDisable((int)2929);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GuiUtils.renderColor(0xFFFFFF);
        GuiUtils.drawImage(-width / 2.0f, -height / 2.0f, par1, width, height);
        GL11.glDepthMask((boolean)true);
        GL11.glEnable((int)2929);
        GL11.glEnable((int)2896);
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
    }

    public static void drawPositionedImageInViewWithDepth(ResourceLocation par1, double par2, double par3, double par4, float par5, float width, float height, float givenAlpha) {
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        GL11.glPushMatrix();
        GL11.glTranslated((double)par2, (double)par3, (double)par4);
        GL11.glTranslated((double)(-RenderManager.field_78727_a.field_78730_l), (double)(-RenderManager.field_78727_a.field_78731_m), (double)(-RenderManager.field_78727_a.field_78728_n));
        GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(-player.field_70177_z), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)player.field_70125_A, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glScalef((float)-0.03f, (float)-0.03f, (float)0.03f);
        GL11.glDisable((int)2896);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glEnable((int)3008);
        GuiUtils.drawImageTransparent(-width / 2.0f, -height / 2.0f, par1, width, height, givenAlpha);
        GL11.glEnable((int)2896);
        GL11.glPopMatrix();
    }

    public static void drawPositionedTextInView(String par1, double par2, double par3, double par4, float par5) {
        GuiUtils.drawPositionedTextInView(par1, par2, par3, par4, par5, 1.0f);
    }

    public static void drawPositionedTextInView(String par1, double par2, double par3, double par4, float par5, float alpha) {
        Minecraft mc = Minecraft.func_71410_x();
        EntityClientPlayerMP player = mc.field_71439_g;
        GL11.glPushMatrix();
        GL11.glTranslated((double)par2, (double)par3, (double)par4);
        GL11.glTranslated((double)(-RenderManager.field_78727_a.field_78730_l), (double)(-RenderManager.field_78727_a.field_78731_m), (double)(-RenderManager.field_78727_a.field_78728_n));
        GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int width = mc.field_71466_p.func_78256_a(par1);
        GL11.glRotatef((float)(-player.field_70177_z), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)player.field_70125_A, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glScalef((float)-0.01f, (float)-0.01f, (float)0.01f);
        GL11.glDisable((int)2896);
        if (dM) {
            GL11.glDepthMask((boolean)false);
        }
        GL11.glDisable((int)2929);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        Color color = new Color(1.0f, 1.0f, 1.0f, alpha);
        FontRenderer fr = mc.field_71466_p;
        fr.func_78276_b(par1, -(width / 2), 0, color.getRGB());
        GL11.glDepthMask((boolean)true);
        GL11.glEnable((int)2929);
        GL11.glEnable((int)2896);
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
    }

    public static void drawPositionedTextInViewScaled(String par1, double par2, double par3, double par4, float par5, double scale, int givenColor) {
        Minecraft mc = Minecraft.func_71410_x();
        EntityClientPlayerMP player = mc.field_71439_g;
        GL11.glPushMatrix();
        GL11.glTranslated((double)par2, (double)par3, (double)par4);
        GL11.glTranslated((double)(-RenderManager.field_78727_a.field_78730_l), (double)(-RenderManager.field_78727_a.field_78731_m), (double)(-RenderManager.field_78727_a.field_78728_n));
        GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glRotatef((float)(-player.field_70177_z), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)player.field_70125_A, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glScalef((float)-0.03f, (float)-0.03f, (float)0.03f);
        GL11.glDisable((int)2896);
        if (dM) {
            GL11.glDepthMask((boolean)false);
        }
        GL11.glDisable((int)2929);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GuiUtils.renderColor(0xFFFFFF);
        GuiUtils.renderCenteredTextScaledWithOutline(par1, 0, 0, scale, givenColor);
        GL11.glDepthMask((boolean)true);
        GL11.glEnable((int)2929);
        GL11.glEnable((int)2896);
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
    }

    public static void drawPositionedTextInViewScaled(String par1, double par2, double par3, double par4, float par5, double scale) {
        Minecraft mc = Minecraft.func_71410_x();
        EntityClientPlayerMP player = mc.field_71439_g;
        GL11.glPushMatrix();
        GL11.glTranslated((double)par2, (double)par3, (double)par4);
        GL11.glTranslated((double)(-RenderManager.field_78727_a.field_78730_l), (double)(-RenderManager.field_78727_a.field_78731_m), (double)(-RenderManager.field_78727_a.field_78728_n));
        GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glRotatef((float)(-player.field_70177_z), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)player.field_70125_A, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glScalef((float)-0.03f, (float)-0.03f, (float)0.03f);
        GL11.glDisable((int)2896);
        if (dM) {
            GL11.glDepthMask((boolean)false);
        }
        GL11.glDisable((int)2929);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GuiUtils.renderColor(0xFFFFFF);
        GuiUtils.renderCenteredTextScaledWithOutline(par1, 0, 0, scale, 0xFFFFFF);
        GL11.glDepthMask((boolean)true);
        GL11.glEnable((int)2929);
        GL11.glEnable((int)2896);
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
    }

    public static void renderBeam(World world, double p_147500_2_, double p_147500_4_, double p_147500_6_, float p_147500_8_) {
        GL11.glAlphaFunc((int)516, (float)0.1f);
        Tessellator tessellator = Tessellator.field_78398_a;
        Minecraft.func_71410_x().field_71446_o.func_110577_a(beaconBeam);
        GL11.glTexParameterf((int)3553, (int)10242, (float)10497.0f);
        GL11.glTexParameterf((int)3553, (int)10243, (float)10497.0f);
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2884);
        GL11.glDisable((int)3042);
        GL11.glDepthMask((boolean)true);
        OpenGlHelper.func_148821_a((int)770, (int)1, (int)1, (int)0);
        float f2 = (float)world.func_82737_E() + p_147500_8_;
        float f3 = -f2 * 0.2f - (float)MathHelper.func_76141_d((float)(-f2 * 0.1f));
        boolean b0 = true;
        double d3 = (double)f2 * 0.025 * (1.0 - (double)(b0 & true) * 2.5);
        tessellator.func_78382_b();
        tessellator.func_78370_a(255, 255, 255, 32);
        double d5 = (double)b0 * 0.2;
        double d7 = 0.5 + Math.cos(d3 + 2.356194490192345) * d5;
        double d9 = 0.5 + Math.sin(d3 + 2.356194490192345) * d5;
        double d11 = 0.5 + Math.cos(d3 + 0.7853981633974483) * d5;
        double d13 = 0.5 + Math.sin(d3 + 0.7853981633974483) * d5;
        double d15 = 0.5 + Math.cos(d3 + 3.9269908169872414) * d5;
        double d17 = 0.5 + Math.sin(d3 + 3.9269908169872414) * d5;
        double d19 = 0.5 + Math.cos(d3 + 5.497787143782138) * d5;
        double d21 = 0.5 + Math.sin(d3 + 5.497787143782138) * d5;
        double d23 = 256.0;
        double d25 = 0.0;
        double d27 = 1.0;
        double d28 = -1.0f + f3;
        double d29 = 256.0 * (0.5 / d5) + d28;
        tessellator.func_78374_a(p_147500_2_ + d7, p_147500_4_ + d23, p_147500_6_ + d9, d27, d29);
        tessellator.func_78374_a(p_147500_2_ + d7, p_147500_4_, p_147500_6_ + d9, d27, d28);
        tessellator.func_78374_a(p_147500_2_ + d11, p_147500_4_, p_147500_6_ + d13, d25, d28);
        tessellator.func_78374_a(p_147500_2_ + d11, p_147500_4_ + d23, p_147500_6_ + d13, d25, d29);
        tessellator.func_78374_a(p_147500_2_ + d19, p_147500_4_ + d23, p_147500_6_ + d21, d27, d29);
        tessellator.func_78374_a(p_147500_2_ + d19, p_147500_4_, p_147500_6_ + d21, d27, d28);
        tessellator.func_78374_a(p_147500_2_ + d15, p_147500_4_, p_147500_6_ + d17, d25, d28);
        tessellator.func_78374_a(p_147500_2_ + d15, p_147500_4_ + d23, p_147500_6_ + d17, d25, d29);
        tessellator.func_78374_a(p_147500_2_ + d11, p_147500_4_ + d23, p_147500_6_ + d13, d27, d29);
        tessellator.func_78374_a(p_147500_2_ + d11, p_147500_4_, p_147500_6_ + d13, d27, d28);
        tessellator.func_78374_a(p_147500_2_ + d19, p_147500_4_, p_147500_6_ + d21, d25, d28);
        tessellator.func_78374_a(p_147500_2_ + d19, p_147500_4_ + d23, p_147500_6_ + d21, d25, d29);
        tessellator.func_78374_a(p_147500_2_ + d15, p_147500_4_ + d23, p_147500_6_ + d17, d27, d29);
        tessellator.func_78374_a(p_147500_2_ + d15, p_147500_4_, p_147500_6_ + d17, d27, d28);
        tessellator.func_78374_a(p_147500_2_ + d7, p_147500_4_, p_147500_6_ + d9, d25, d28);
        tessellator.func_78374_a(p_147500_2_ + d7, p_147500_4_ + d23, p_147500_6_ + d9, d25, d29);
        tessellator.func_78381_a();
        GL11.glEnable((int)3042);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        GL11.glDepthMask((boolean)false);
        tessellator.func_78382_b();
        tessellator.func_78370_a(255, 255, 255, 32);
        double d30 = 0.2;
        double d4 = 0.2;
        double d6 = 0.8;
        double d8 = 0.2;
        double d10 = 0.2;
        double d12 = 0.8;
        double d14 = 0.8;
        double d16 = 0.8;
        double d18 = 256.0;
        double d20 = 0.0;
        double d22 = 1.0;
        double d24 = -1.0f + f3;
        double d26 = 256.0 + d24;
        tessellator.func_78374_a(p_147500_2_ + d30, p_147500_4_ + d18, p_147500_6_ + d4, d22, d26);
        tessellator.func_78374_a(p_147500_2_ + d30, p_147500_4_, p_147500_6_ + d4, d22, d24);
        tessellator.func_78374_a(p_147500_2_ + d6, p_147500_4_, p_147500_6_ + d8, d20, d24);
        tessellator.func_78374_a(p_147500_2_ + d6, p_147500_4_ + d18, p_147500_6_ + d8, d20, d26);
        tessellator.func_78374_a(p_147500_2_ + d14, p_147500_4_ + d18, p_147500_6_ + d16, d22, d26);
        tessellator.func_78374_a(p_147500_2_ + d14, p_147500_4_, p_147500_6_ + d16, d22, d24);
        tessellator.func_78374_a(p_147500_2_ + d10, p_147500_4_, p_147500_6_ + d12, d20, d24);
        tessellator.func_78374_a(p_147500_2_ + d10, p_147500_4_ + d18, p_147500_6_ + d12, d20, d26);
        tessellator.func_78374_a(p_147500_2_ + d6, p_147500_4_ + d18, p_147500_6_ + d8, d22, d26);
        tessellator.func_78374_a(p_147500_2_ + d6, p_147500_4_, p_147500_6_ + d8, d22, d24);
        tessellator.func_78374_a(p_147500_2_ + d14, p_147500_4_, p_147500_6_ + d16, d20, d24);
        tessellator.func_78374_a(p_147500_2_ + d14, p_147500_4_ + d18, p_147500_6_ + d16, d20, d26);
        tessellator.func_78374_a(p_147500_2_ + d10, p_147500_4_ + d18, p_147500_6_ + d12, d22, d26);
        tessellator.func_78374_a(p_147500_2_ + d10, p_147500_4_, p_147500_6_ + d12, d22, d24);
        tessellator.func_78374_a(p_147500_2_ + d30, p_147500_4_, p_147500_6_ + d4, d20, d24);
        tessellator.func_78374_a(p_147500_2_ + d30, p_147500_4_ + d18, p_147500_6_ + d4, d20, d26);
        tessellator.func_78381_a();
        GL11.glEnable((int)2896);
        GL11.glEnable((int)3553);
        GL11.glDepthMask((boolean)true);
    }

    public static void renderPlayerHead(String playerName, int xPos, int yPos, String givenPlayerUUID) {
        ResourceLocation resourceLocation = AbstractClientPlayer.locationStevePng;
        if (playerName.length() > 0) {
            GuiUtils.getDownloadImageSkin(resourceLocation, givenPlayerUUID);
        }
        GL11.glPushMatrix();
        GuiUtils.drawRect(xPos - 1, yPos - 1, 20, 21, "0x000000", 0.5f);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(resourceLocation);
        GL11.glTranslated((double)xPos, (double)yPos, (double)30.0);
        GL11.glScaled((double)0.75, (double)0.39, (double)0.0);
        double scale = 0.75;
        GL11.glScaled((double)scale, (double)scale, (double)scale);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderHelper.func_74518_a();
        Minecraft.func_71410_x().field_71456_v.func_73729_b(0, 0, 32, 64, 32, 64);
        Minecraft.func_71410_x().field_71456_v.func_73729_b(0, 0, 160, 64, 32, 64);
        GL11.glPopMatrix();
    }

    public static void renderZombieHead(int xPos, int yPos, String givenPlayerUUID) {
        ResourceLocation resourceLocation = AbstractClientPlayer.locationZombiePng;
        GL11.glPushMatrix();
        GuiUtils.drawRect(xPos - 1, yPos - 1, 20, 21, "0x000000", 0.5f);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(resourceLocation);
        GL11.glTranslated((double)xPos, (double)yPos, (double)30.0);
        GL11.glScaled((double)0.75, (double)0.39, (double)0.0);
        double scale = 0.75;
        GL11.glScaled((double)scale, (double)scale, (double)scale);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderHelper.func_74518_a();
        Minecraft.func_71410_x().field_71456_v.func_73729_b(0, 0, 32, 64, 32, 64);
        Minecraft.func_71410_x().field_71456_v.func_73729_b(0, 0, 160, 64, 32, 64);
        GL11.glPopMatrix();
    }

    public static void drawRect(int x, int y, int width, int height, String colorString, float alpha) {
        Color color = Color.decode(colorString);
        float red = (float)color.getRed() / 255.0f;
        float green = (float)color.getGreen() / 255.0f;
        float blue = (float)color.getBlue() / 255.0f;
        GuiUtils.drawRect(x, y, x + width, y + height, red, green, blue, alpha);
    }

    public static void drawRect(int xStart, int yStart, int xEnd, int yEnd, int rgb) {
        Tessellator tessellator = Tessellator.field_78398_a;
        GL11.glPushMatrix();
        GL11.glDisable((int)3553);
        GL11.glColor3b((byte)((byte)(rgb >> 16)), (byte)((byte)(rgb >> 8 & 0xFF)), (byte)((byte)(rgb & 0xFF)));
        tessellator.func_78382_b();
        tessellator.func_78377_a((double)xStart, (double)yEnd, 0.0);
        tessellator.func_78377_a((double)xEnd, (double)yEnd, 0.0);
        tessellator.func_78377_a((double)xEnd, (double)yStart, 0.0);
        tessellator.func_78377_a((double)xStart, (double)yStart, 0.0);
        tessellator.func_78381_a();
        GL11.glEnable((int)3553);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPopMatrix();
    }

    public static void drawRect(int xStart, int yStart, int xEnd, int yEnd, float r, float g, float b, float alpha) {
        Tessellator tessellator = Tessellator.field_78398_a;
        GL11.glPushMatrix();
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glDisable((int)3553);
        GL11.glColor4f((float)r, (float)g, (float)b, (float)alpha);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glDisable((int)3553);
        tessellator.func_78382_b();
        tessellator.func_78377_a((double)xStart, (double)yEnd, 0.0);
        tessellator.func_78377_a((double)xEnd, (double)yEnd, 0.0);
        tessellator.func_78377_a((double)xEnd, (double)yStart, 0.0);
        tessellator.func_78377_a((double)xStart, (double)yStart, 0.0);
        tessellator.func_78381_a();
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPopMatrix();
    }

    public static void drawRect2(int xStart, int yStart, int xEnd, int yEnd, Color color) {
        float r = (float)color.getRed() / 255.0f;
        float g = (float)color.getGreen() / 255.0f;
        float b = (float)color.getBlue() / 255.0f;
        float a = (float)color.getAlpha() / 255.0f;
        Tessellator tessellator = Tessellator.field_78398_a;
        GL11.glPushMatrix();
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glDisable((int)3553);
        GL11.glColor4f((float)r, (float)g, (float)b, (float)a);
        tessellator.func_78382_b();
        tessellator.func_78377_a((double)xStart, (double)(yStart + yEnd), 0.0);
        tessellator.func_78377_a((double)(xStart + xEnd), (double)(yStart + yEnd), 0.0);
        tessellator.func_78377_a((double)(xStart + xEnd), (double)yStart, 0.0);
        tessellator.func_78377_a((double)xStart, (double)yStart, 0.0);
        tessellator.func_78381_a();
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPopMatrix();
    }

    public static void drawRectWithShadow2(int x, int y, int width, int height, Color color, int alpha) {
        GuiUtils.drawRect2(x - 1, y - 1, width + 2, height + 2, new Color(color.getRed(), color.getGreen(), color.getBlue(), alpha / 2));
        GuiUtils.drawRect2(x, y, width, height, new Color(color.getRed(), color.getGreen(), color.getBlue(), alpha));
    }

    public static void drawRectWithShadow(int par0, int par1, int par2, int par3, String par4Hex, float par5Alpha) {
        GuiUtils.drawRect(par0 - 1, par1 - 1, par2 + 2, par3 + 2, "0x000000", 0.2f);
        GuiUtils.drawRect(par0, par1, par2, par3, par4Hex, par5Alpha);
    }

    public static void drawRectWithShadow(int par0, int par1, int par2, int par3, String par4Hex, float par5Alpha, float par6Alpha) {
        GuiUtils.drawRect(par0 - 1, par1 - 1, par2 + 2, par3 + 2, "0x000000", par6Alpha);
        GuiUtils.drawRect(par0, par1, par2, par3, par4Hex, par5Alpha);
    }

    public static boolean isInBox(int x, int y, int width, int height, int checkX, int checkY) {
        return checkX >= x && checkY >= y && checkX <= x + width && checkY <= y + height;
    }

    public static void drawTexturedQuadFit(int width, int height) {
        Tessellator t = Tessellator.field_78398_a;
        t.func_78382_b();
        t.func_78374_a(10.0, (double)(10 + height), 1.0, 0.0, 1.0);
        t.func_78374_a((double)(10 + width), (double)(10 + height), 1.0, 1.0, 1.0);
        t.func_78374_a((double)(10 + width), 10.0, 1.0, 1.0, 0.0);
        t.func_78374_a(10.0, 10.0, 1.0, 0.0, 0.0);
        t.func_78381_a();
    }

    public static void drawOutlinedBoundingBox(AxisAlignedBB par1AxisAlignedBB) {
        Tessellator var2 = Tessellator.field_78398_a;
        var2.func_78371_b(3);
        var2.func_78377_a(par1AxisAlignedBB.field_72340_a, par1AxisAlignedBB.field_72338_b, par1AxisAlignedBB.field_72339_c);
        var2.func_78377_a(par1AxisAlignedBB.field_72336_d, par1AxisAlignedBB.field_72338_b, par1AxisAlignedBB.field_72339_c);
        var2.func_78377_a(par1AxisAlignedBB.field_72336_d, par1AxisAlignedBB.field_72338_b, par1AxisAlignedBB.field_72334_f);
        var2.func_78377_a(par1AxisAlignedBB.field_72340_a, par1AxisAlignedBB.field_72338_b, par1AxisAlignedBB.field_72334_f);
        var2.func_78377_a(par1AxisAlignedBB.field_72340_a, par1AxisAlignedBB.field_72338_b, par1AxisAlignedBB.field_72339_c);
        var2.func_78381_a();
        var2.func_78371_b(3);
        var2.func_78377_a(par1AxisAlignedBB.field_72340_a, par1AxisAlignedBB.field_72337_e, par1AxisAlignedBB.field_72339_c);
        var2.func_78377_a(par1AxisAlignedBB.field_72336_d, par1AxisAlignedBB.field_72337_e, par1AxisAlignedBB.field_72339_c);
        var2.func_78377_a(par1AxisAlignedBB.field_72336_d, par1AxisAlignedBB.field_72337_e, par1AxisAlignedBB.field_72334_f);
        var2.func_78377_a(par1AxisAlignedBB.field_72340_a, par1AxisAlignedBB.field_72337_e, par1AxisAlignedBB.field_72334_f);
        var2.func_78377_a(par1AxisAlignedBB.field_72340_a, par1AxisAlignedBB.field_72337_e, par1AxisAlignedBB.field_72339_c);
        var2.func_78381_a();
        var2.func_78371_b(1);
        var2.func_78377_a(par1AxisAlignedBB.field_72340_a, par1AxisAlignedBB.field_72338_b, par1AxisAlignedBB.field_72339_c);
        var2.func_78377_a(par1AxisAlignedBB.field_72340_a, par1AxisAlignedBB.field_72337_e, par1AxisAlignedBB.field_72339_c);
        var2.func_78377_a(par1AxisAlignedBB.field_72336_d, par1AxisAlignedBB.field_72338_b, par1AxisAlignedBB.field_72339_c);
        var2.func_78377_a(par1AxisAlignedBB.field_72336_d, par1AxisAlignedBB.field_72337_e, par1AxisAlignedBB.field_72339_c);
        var2.func_78377_a(par1AxisAlignedBB.field_72336_d, par1AxisAlignedBB.field_72338_b, par1AxisAlignedBB.field_72334_f);
        var2.func_78377_a(par1AxisAlignedBB.field_72336_d, par1AxisAlignedBB.field_72337_e, par1AxisAlignedBB.field_72334_f);
        var2.func_78377_a(par1AxisAlignedBB.field_72340_a, par1AxisAlignedBB.field_72338_b, par1AxisAlignedBB.field_72334_f);
        var2.func_78377_a(par1AxisAlignedBB.field_72340_a, par1AxisAlignedBB.field_72337_e, par1AxisAlignedBB.field_72334_f);
        var2.func_78381_a();
    }

    public static void drawSelectionBox(EntityPlayer player, float particleTicks, AxisAlignedBB boundingBox, Color givenColor) {
        GL11.glPushMatrix();
        GL11.glDisable((int)3008);
        GL11.glDisable((int)2896);
        GL11.glDepthMask((boolean)false);
        GL11.glDisable((int)2929);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        float colorR = givenColor.getRed();
        float colorG = givenColor.getGreen();
        float colorB = givenColor.getBlue();
        GL11.glColor4f((float)colorR, (float)colorG, (float)colorB, (float)0.7f);
        GL11.glLineWidth((float)2.0f);
        GL11.glDisable((int)3553);
        double d0 = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)particleTicks;
        double d1 = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)particleTicks;
        double d2 = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)particleTicks;
        GuiUtils.drawOutlinedBoundingBox(boundingBox.func_72325_c(-d0, -d1, -d2));
        GL11.glEnable((int)2929);
        GL11.glDepthMask((boolean)true);
        GL11.glEnable((int)3553);
        GL11.glEnable((int)2896);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3008);
        GL11.glColor4f((float)0.0f, (float)0.0f, (float)0.0f, (float)255.0f);
        GL11.glPopMatrix();
    }

    public static void drawLine(double posX, double posY, double posZ, double posX2, double posY2, double posZ2, int givenColor, float width) {
        Minecraft mc = Minecraft.func_71410_x();
        float red = (float)(givenColor >> 16 & 0xFF) / 255.0f;
        float blue = (float)(givenColor >> 8 & 0xFF) / 255.0f;
        float green = (float)(givenColor & 0xFF) / 255.0f;
        float alpha = (float)(givenColor >> 24 & 0xFF) / 255.0f;
        double d0 = mc.field_71439_g.field_70169_q + (mc.field_71439_g.field_70165_t - mc.field_71439_g.field_70169_q);
        double d1 = mc.field_71439_g.field_70167_r + (mc.field_71439_g.field_70163_u - mc.field_71439_g.field_70167_r);
        double d2 = mc.field_71439_g.field_70166_s + (mc.field_71439_g.field_70161_v - mc.field_71439_g.field_70166_s);
        GL11.glPushMatrix();
        GL11.glDisable((int)2896);
        GL11.glDisable((int)3553);
        GL11.glDisable((int)2929);
        GL11.glLineWidth((float)width);
        GL11.glTranslated((double)(-d0), (double)(-d1), (double)(-d2));
        GL11.glColor4f((float)red, (float)green, (float)blue, (float)alpha);
        GL11.glEnable((int)2848);
        GL11.glHint((int)3154, (int)4354);
        GL11.glBegin((int)3);
        GL11.glVertex3d((double)posX, (double)posY, (double)posZ);
        GL11.glVertex3d((double)posX2, (double)posY2, (double)posZ2);
        GL11.glEnd();
        GL11.glEnable((int)2896);
        GL11.glEnable((int)3553);
        GL11.glEnable((int)2929);
        GL11.glPopMatrix();
    }

    public static ThreadDownloadImageData getDownloadImageSkin(ResourceLocation resourceLocationIn, String givenUUID) {
        TextureManager texturemanager = Minecraft.func_71410_x().func_110434_K();
        ITextureObject object = texturemanager.func_110581_b(resourceLocationIn);
        if (object == null) {
            object = new ThreadDownloadImageData((File)null, String.format("https://crafatar.com/skins/%s.png", StringUtils.func_76338_a((String)givenUUID)), AbstractClientPlayer.locationStevePng, (IImageBuffer)new ImageBufferDownload());
            texturemanager.func_110579_a(resourceLocationIn, object);
        }
        return (ThreadDownloadImageData)object;
    }

    public static ResourceLocation getLocationSkin(String username) {
        return new ResourceLocation("skins/" + StringUtils.func_76338_a((String)username));
    }

    public static String secondsToTimeFormatted(long sec) {
        long seconds = sec % 60L;
        long minutes = sec / 60L;
        if (minutes >= 60L) {
            long hours = minutes / 60L;
            minutes %= 60L;
            if (hours >= 24L) {
                long days = hours / 24L;
                return String.format("%d days %02d:%02d:%02d", days, hours % 24L, minutes, seconds);
            }
            return String.format("%02d:%02d:%02d", hours, minutes, seconds);
        }
        return String.format("00:%02d:%02d", minutes, seconds);
    }

    public static void renderAABB(AxisAlignedBB p_76980_0_) {
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78377_a(p_76980_0_.field_72340_a, p_76980_0_.field_72337_e, p_76980_0_.field_72339_c);
        tessellator.func_78377_a(p_76980_0_.field_72336_d, p_76980_0_.field_72337_e, p_76980_0_.field_72339_c);
        tessellator.func_78377_a(p_76980_0_.field_72336_d, p_76980_0_.field_72338_b, p_76980_0_.field_72339_c);
        tessellator.func_78377_a(p_76980_0_.field_72340_a, p_76980_0_.field_72338_b, p_76980_0_.field_72339_c);
        tessellator.func_78377_a(p_76980_0_.field_72340_a, p_76980_0_.field_72338_b, p_76980_0_.field_72334_f);
        tessellator.func_78377_a(p_76980_0_.field_72336_d, p_76980_0_.field_72338_b, p_76980_0_.field_72334_f);
        tessellator.func_78377_a(p_76980_0_.field_72336_d, p_76980_0_.field_72337_e, p_76980_0_.field_72334_f);
        tessellator.func_78377_a(p_76980_0_.field_72340_a, p_76980_0_.field_72337_e, p_76980_0_.field_72334_f);
        tessellator.func_78377_a(p_76980_0_.field_72340_a, p_76980_0_.field_72338_b, p_76980_0_.field_72334_f);
        tessellator.func_78377_a(p_76980_0_.field_72340_a, p_76980_0_.field_72337_e, p_76980_0_.field_72334_f);
        tessellator.func_78377_a(p_76980_0_.field_72340_a, p_76980_0_.field_72337_e, p_76980_0_.field_72339_c);
        tessellator.func_78377_a(p_76980_0_.field_72340_a, p_76980_0_.field_72338_b, p_76980_0_.field_72339_c);
        tessellator.func_78377_a(p_76980_0_.field_72336_d, p_76980_0_.field_72338_b, p_76980_0_.field_72339_c);
        tessellator.func_78377_a(p_76980_0_.field_72336_d, p_76980_0_.field_72337_e, p_76980_0_.field_72339_c);
        tessellator.func_78377_a(p_76980_0_.field_72336_d, p_76980_0_.field_72337_e, p_76980_0_.field_72334_f);
        tessellator.func_78377_a(p_76980_0_.field_72336_d, p_76980_0_.field_72338_b, p_76980_0_.field_72334_f);
        tessellator.func_78381_a();
    }

    public static void renderOffsetAABB(AxisAlignedBB p_76978_0_, double p_76978_1_, double p_76978_3_, double p_76978_5_) {
        GL11.glDisable((int)3553);
        Tessellator tessellator = Tessellator.field_78398_a;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        tessellator.func_78382_b();
        tessellator.func_78373_b(p_76978_1_, p_76978_3_, p_76978_5_);
        tessellator.func_78375_b(0.0f, 0.0f, -1.0f);
        tessellator.func_78377_a(p_76978_0_.field_72340_a, p_76978_0_.field_72337_e, p_76978_0_.field_72339_c);
        tessellator.func_78377_a(p_76978_0_.field_72336_d, p_76978_0_.field_72337_e, p_76978_0_.field_72339_c);
        tessellator.func_78377_a(p_76978_0_.field_72336_d, p_76978_0_.field_72338_b, p_76978_0_.field_72339_c);
        tessellator.func_78377_a(p_76978_0_.field_72340_a, p_76978_0_.field_72338_b, p_76978_0_.field_72339_c);
        tessellator.func_78375_b(0.0f, 0.0f, 1.0f);
        tessellator.func_78377_a(p_76978_0_.field_72340_a, p_76978_0_.field_72338_b, p_76978_0_.field_72334_f);
        tessellator.func_78377_a(p_76978_0_.field_72336_d, p_76978_0_.field_72338_b, p_76978_0_.field_72334_f);
        tessellator.func_78377_a(p_76978_0_.field_72336_d, p_76978_0_.field_72337_e, p_76978_0_.field_72334_f);
        tessellator.func_78377_a(p_76978_0_.field_72340_a, p_76978_0_.field_72337_e, p_76978_0_.field_72334_f);
        tessellator.func_78375_b(0.0f, -1.0f, 0.0f);
        tessellator.func_78377_a(p_76978_0_.field_72340_a, p_76978_0_.field_72338_b, p_76978_0_.field_72339_c);
        tessellator.func_78377_a(p_76978_0_.field_72336_d, p_76978_0_.field_72338_b, p_76978_0_.field_72339_c);
        tessellator.func_78377_a(p_76978_0_.field_72336_d, p_76978_0_.field_72338_b, p_76978_0_.field_72334_f);
        tessellator.func_78377_a(p_76978_0_.field_72340_a, p_76978_0_.field_72338_b, p_76978_0_.field_72334_f);
        tessellator.func_78375_b(0.0f, 1.0f, 0.0f);
        tessellator.func_78377_a(p_76978_0_.field_72340_a, p_76978_0_.field_72337_e, p_76978_0_.field_72334_f);
        tessellator.func_78377_a(p_76978_0_.field_72336_d, p_76978_0_.field_72337_e, p_76978_0_.field_72334_f);
        tessellator.func_78377_a(p_76978_0_.field_72336_d, p_76978_0_.field_72337_e, p_76978_0_.field_72339_c);
        tessellator.func_78377_a(p_76978_0_.field_72340_a, p_76978_0_.field_72337_e, p_76978_0_.field_72339_c);
        tessellator.func_78375_b(-1.0f, 0.0f, 0.0f);
        tessellator.func_78377_a(p_76978_0_.field_72340_a, p_76978_0_.field_72338_b, p_76978_0_.field_72334_f);
        tessellator.func_78377_a(p_76978_0_.field_72340_a, p_76978_0_.field_72337_e, p_76978_0_.field_72334_f);
        tessellator.func_78377_a(p_76978_0_.field_72340_a, p_76978_0_.field_72337_e, p_76978_0_.field_72339_c);
        tessellator.func_78377_a(p_76978_0_.field_72340_a, p_76978_0_.field_72338_b, p_76978_0_.field_72339_c);
        tessellator.func_78375_b(1.0f, 0.0f, 0.0f);
        tessellator.func_78377_a(p_76978_0_.field_72336_d, p_76978_0_.field_72338_b, p_76978_0_.field_72339_c);
        tessellator.func_78377_a(p_76978_0_.field_72336_d, p_76978_0_.field_72337_e, p_76978_0_.field_72339_c);
        tessellator.func_78377_a(p_76978_0_.field_72336_d, p_76978_0_.field_72337_e, p_76978_0_.field_72334_f);
        tessellator.func_78377_a(p_76978_0_.field_72336_d, p_76978_0_.field_72338_b, p_76978_0_.field_72334_f);
        tessellator.func_78373_b(0.0, 0.0, 0.0);
        tessellator.func_78381_a();
        GL11.glEnable((int)3553);
    }

    public static double getDistanceToClientCamera(double x, double y, double z) {
        double d3 = RenderManager.field_78727_a.field_78730_l - x;
        double d4 = RenderManager.field_78727_a.field_78731_m - y;
        double d5 = RenderManager.field_78727_a.field_78728_n - z;
        return MathHelper.func_76133_a((double)(d3 * d3 + d4 * d4 + d5 * d5));
    }

    public static void drawGradientRect(int givenX, int givenY, int givenWidth, int givenHeight, int startColor, int endColor) {
        givenWidth += givenX;
        givenHeight += givenY;
        float f = (float)(startColor >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(startColor >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(startColor >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(startColor & 0xFF) / 255.0f;
        float f4 = (float)(endColor >> 24 & 0xFF) / 255.0f;
        float f5 = (float)(endColor >> 16 & 0xFF) / 255.0f;
        float f6 = (float)(endColor >> 8 & 0xFF) / 255.0f;
        float f7 = (float)(endColor & 0xFF) / 255.0f;
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3008);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glShadeModel((int)7425);
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78369_a(f1, f2, f3, f);
        tessellator.func_78377_a((double)givenWidth, (double)givenY, 0.0);
        tessellator.func_78377_a((double)givenX, (double)givenY, 0.0);
        tessellator.func_78369_a(f5, f6, f7, f4);
        tessellator.func_78377_a((double)givenX, (double)givenHeight, 0.0);
        tessellator.func_78377_a((double)givenWidth, (double)givenHeight, 0.0);
        tessellator.func_78381_a();
        GL11.glShadeModel((int)7424);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3008);
        GL11.glEnable((int)3553);
    }

    public static void drawImageCentered(double givenX, double givenY, ResourceLocation givenTexture, double givenWidth, double givenHeight) {
        GL11.glPushMatrix();
        GuiUtils.drawImage(givenX - givenWidth / 2.0, givenY - givenHeight / 2.0, givenTexture, givenWidth, givenHeight);
        GL11.glPopMatrix();
    }

    public void drawBoundingBox(AxisAlignedBB boundingBox) {
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78377_a(boundingBox.field_72340_a, boundingBox.field_72338_b, boundingBox.field_72339_c);
        tessellator.func_78377_a(boundingBox.field_72340_a, boundingBox.field_72337_e, boundingBox.field_72339_c);
        tessellator.func_78377_a(boundingBox.field_72336_d, boundingBox.field_72338_b, boundingBox.field_72339_c);
        tessellator.func_78377_a(boundingBox.field_72336_d, boundingBox.field_72337_e, boundingBox.field_72339_c);
        tessellator.func_78377_a(boundingBox.field_72336_d, boundingBox.field_72338_b, boundingBox.field_72334_f);
        tessellator.func_78377_a(boundingBox.field_72336_d, boundingBox.field_72337_e, boundingBox.field_72334_f);
        tessellator.func_78377_a(boundingBox.field_72340_a, boundingBox.field_72338_b, boundingBox.field_72334_f);
        tessellator.func_78377_a(boundingBox.field_72340_a, boundingBox.field_72337_e, boundingBox.field_72334_f);
        tessellator.func_78381_a();
        tessellator.func_78377_a(boundingBox.field_72336_d, boundingBox.field_72337_e, boundingBox.field_72339_c);
        tessellator.func_78377_a(boundingBox.field_72336_d, boundingBox.field_72338_b, boundingBox.field_72339_c);
        tessellator.func_78377_a(boundingBox.field_72340_a, boundingBox.field_72337_e, boundingBox.field_72339_c);
        tessellator.func_78377_a(boundingBox.field_72340_a, boundingBox.field_72338_b, boundingBox.field_72339_c);
        tessellator.func_78377_a(boundingBox.field_72340_a, boundingBox.field_72337_e, boundingBox.field_72334_f);
        tessellator.func_78377_a(boundingBox.field_72340_a, boundingBox.field_72338_b, boundingBox.field_72334_f);
        tessellator.func_78377_a(boundingBox.field_72336_d, boundingBox.field_72337_e, boundingBox.field_72334_f);
        tessellator.func_78377_a(boundingBox.field_72336_d, boundingBox.field_72338_b, boundingBox.field_72334_f);
        tessellator.func_78381_a();
        tessellator.func_78377_a(boundingBox.field_72340_a, boundingBox.field_72337_e, boundingBox.field_72339_c);
        tessellator.func_78377_a(boundingBox.field_72336_d, boundingBox.field_72337_e, boundingBox.field_72339_c);
        tessellator.func_78377_a(boundingBox.field_72336_d, boundingBox.field_72337_e, boundingBox.field_72334_f);
        tessellator.func_78377_a(boundingBox.field_72340_a, boundingBox.field_72337_e, boundingBox.field_72334_f);
        tessellator.func_78377_a(boundingBox.field_72340_a, boundingBox.field_72337_e, boundingBox.field_72339_c);
        tessellator.func_78377_a(boundingBox.field_72340_a, boundingBox.field_72337_e, boundingBox.field_72334_f);
        tessellator.func_78377_a(boundingBox.field_72336_d, boundingBox.field_72337_e, boundingBox.field_72334_f);
        tessellator.func_78377_a(boundingBox.field_72336_d, boundingBox.field_72337_e, boundingBox.field_72339_c);
        tessellator.func_78381_a();
        tessellator.func_78377_a(boundingBox.field_72340_a, boundingBox.field_72338_b, boundingBox.field_72339_c);
        tessellator.func_78377_a(boundingBox.field_72336_d, boundingBox.field_72338_b, boundingBox.field_72339_c);
        tessellator.func_78377_a(boundingBox.field_72336_d, boundingBox.field_72338_b, boundingBox.field_72334_f);
        tessellator.func_78377_a(boundingBox.field_72340_a, boundingBox.field_72338_b, boundingBox.field_72334_f);
        tessellator.func_78377_a(boundingBox.field_72340_a, boundingBox.field_72338_b, boundingBox.field_72339_c);
        tessellator.func_78377_a(boundingBox.field_72340_a, boundingBox.field_72338_b, boundingBox.field_72334_f);
        tessellator.func_78377_a(boundingBox.field_72336_d, boundingBox.field_72338_b, boundingBox.field_72334_f);
        tessellator.func_78381_a();
        tessellator.func_78377_a(boundingBox.field_72340_a, boundingBox.field_72338_b, boundingBox.field_72339_c);
        tessellator.func_78377_a(boundingBox.field_72340_a, boundingBox.field_72337_e, boundingBox.field_72339_c);
        tessellator.func_78377_a(boundingBox.field_72340_a, boundingBox.field_72338_b, boundingBox.field_72334_f);
        tessellator.func_78377_a(boundingBox.field_72340_a, boundingBox.field_72337_e, boundingBox.field_72334_f);
        tessellator.func_78377_a(boundingBox.field_72336_d, boundingBox.field_72338_b, boundingBox.field_72334_f);
        tessellator.func_78377_a(boundingBox.field_72336_d, boundingBox.field_72337_e, boundingBox.field_72334_f);
        tessellator.func_78377_a(boundingBox.field_72336_d, boundingBox.field_72338_b, boundingBox.field_72339_c);
        tessellator.func_78377_a(boundingBox.field_72336_d, boundingBox.field_72337_e, boundingBox.field_72339_c);
        tessellator.func_78381_a();
        tessellator.func_78377_a(boundingBox.field_72340_a, boundingBox.field_72337_e, boundingBox.field_72334_f);
        tessellator.func_78377_a(boundingBox.field_72340_a, boundingBox.field_72338_b, boundingBox.field_72334_f);
        tessellator.func_78377_a(boundingBox.field_72340_a, boundingBox.field_72337_e, boundingBox.field_72339_c);
        tessellator.func_78377_a(boundingBox.field_72340_a, boundingBox.field_72338_b, boundingBox.field_72339_c);
        tessellator.func_78377_a(boundingBox.field_72336_d, boundingBox.field_72337_e, boundingBox.field_72339_c);
        tessellator.func_78377_a(boundingBox.field_72336_d, boundingBox.field_72338_b, boundingBox.field_72339_c);
        tessellator.func_78377_a(boundingBox.field_72336_d, boundingBox.field_72337_e, boundingBox.field_72334_f);
        tessellator.func_78377_a(boundingBox.field_72336_d, boundingBox.field_72338_b, boundingBox.field_72334_f);
        tessellator.func_78381_a();
    }

    public static void renderImageTransparent(double x, double y, ResourceLocation image, double width, double height) {
        GuiUtils.mc.field_71446_o.func_110577_a(image);
        GL11.glColor4d((double)255.0, (double)255.0, (double)255.0, (double)255.0);
        GL11.glEnable((int)3042);
        GL11.glEnable((int)2832);
        tesselator.func_78369_a(255.0f, 255.0f, 255.0f, 255.0f);
        tesselator.func_78382_b();
        tesselator.func_78374_a(x, y + height, 0.0, 0.0, 1.0);
        tesselator.func_78374_a(x + width, y + height, 0.0, 1.0, 1.0);
        tesselator.func_78374_a(x + width, y, 0.0, 1.0, 0.0);
        tesselator.func_78374_a(x, y, 0.0, 0.0, 0.0);
        tesselator.func_78381_a();
        GL11.glDisable((int)2832);
        GL11.glDisable((int)3042);
    }

    public static void renderImageTransparent(double x, double y, ResourceLocation image, double width, double height, double alpha) {
        GuiUtils.mc.field_71446_o.func_110577_a(image);
        GL11.glColor4d((double)1.0, (double)1.0, (double)1.0, (double)alpha);
        GL11.glEnable((int)3042);
        GL11.glEnable((int)2832);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glEnable((int)3008);
        tesselator.func_78369_a(255.0f, 255.0f, 255.0f, 0.5f);
        tesselator.func_78382_b();
        tesselator.func_78374_a(x, y + height, 0.0, 0.0, 1.0);
        tesselator.func_78374_a(x + width, y + height, 0.0, 1.0, 1.0);
        tesselator.func_78374_a(x + width, y, 0.0, 1.0, 0.0);
        tesselator.func_78374_a(x, y, 0.0, 0.0, 0.0);
        tesselator.func_78381_a();
        GL11.glDisable((int)2832);
        GL11.glDisable((int)3042);
    }

    public static void renderPositionedImageInViewWithDepth(ResourceLocation par1, double par2, double par3, double par4, float par5, float width, float height, float givenAlpha) {
        EntityClientPlayerMP player = GuiUtils.mc.field_71439_g;
        GL11.glPushMatrix();
        GL11.glTranslated((double)par2, (double)par3, (double)par4);
        GL11.glTranslated((double)(-RenderManager.field_78727_a.field_78730_l), (double)(-RenderManager.field_78727_a.field_78731_m), (double)(-RenderManager.field_78727_a.field_78728_n));
        GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(-player.field_70177_z), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)player.field_70125_A, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glScalef((float)-0.03f, (float)-0.03f, (float)0.03f);
        GuiUtils.renderImageTransparent(-width / 2.0f, -height / 2.0f, par1, width, height, givenAlpha);
        GL11.glPopMatrix();
    }

    public static void renderPositionedTextInView(String par1, double par2, double par3, double par4, float par5) {
        GuiUtils.renderPositionedTextInView(par1, par2, par3, par4, par5, 1.0f);
    }

    public static void renderPositionedTextInView(String par1, double par2, double par3, double par4, float par5, float alpha) {
        Minecraft mc = Minecraft.func_71410_x();
        EntityClientPlayerMP player = mc.field_71439_g;
        GL11.glPushMatrix();
        GL11.glTranslated((double)par2, (double)par3, (double)par4);
        GL11.glTranslated((double)(-RenderManager.field_78727_a.field_78730_l), (double)(-RenderManager.field_78727_a.field_78731_m), (double)(-RenderManager.field_78727_a.field_78728_n));
        GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int width = mc.field_71466_p.func_78256_a(par1);
        GL11.glRotatef((float)(-player.field_70177_z), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)player.field_70125_A, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glScalef((float)-0.01f, (float)-0.01f, (float)0.01f);
        if (dM) {
            GL11.glDepthMask((boolean)false);
        }
        GL11.glDisable((int)2929);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        Color color = new Color(1.0f, 1.0f, 1.0f, alpha);
        FontRenderer fr = mc.field_71466_p;
        fr.func_78276_b(par1, -(width / 2), 0, color.getRGB());
        GL11.glDepthMask((boolean)true);
        GL11.glEnable((int)2929);
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
    }

    public static void renderPositionedTextInViewScaled(String par1, double par2, double par3, double par4, float par5, float scale, int givenColor) {
        Minecraft mc = Minecraft.func_71410_x();
        EntityClientPlayerMP player = mc.field_71439_g;
        GL11.glPushMatrix();
        GL11.glTranslated((double)par2, (double)par3, (double)par4);
        GL11.glTranslated((double)(-RenderManager.field_78727_a.field_78730_l), (double)(-RenderManager.field_78727_a.field_78731_m), (double)(-RenderManager.field_78727_a.field_78728_n));
        GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glRotatef((float)(-player.field_70177_z), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)player.field_70125_A, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glScalef((float)-0.03f, (float)-0.03f, (float)0.03f);
        if (dM) {
            GL11.glDepthMask((boolean)false);
        }
        GL11.glDisable((int)2929);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GuiUtils.renderColor(0xFFFFFF);
        GuiUtils.renderCenteredTextScaledWithOutline(par1, 0, 0, scale, givenColor);
        GL11.glDepthMask((boolean)true);
        GL11.glEnable((int)2929);
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
    }
}

