/*
 * Decompiled with CFR 0.152.
 */
package fr.vartax.utils.server;

import fr.vartax.Vartacraft;
import fr.vartax.network.PacketSendMessage;
import java.util.Timer;
import java.util.TimerTask;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;

public class ServerTask {
    private static final long RESTART_INTERVAL_MS = 86400000L;
    private static final long WARNING_TIME_MS = 300000L;
    private static final double MAX_TPS_DROP = 9.0;
    private static Timer timer;
    private static long nextRestartTime;
    private static boolean warningSent;

    public static void init(final MinecraftServer server) {
        timer = new Timer("ServerTask-Timer", true);
        nextRestartTime = System.currentTimeMillis() + 86400000L;
        warningSent = false;
        timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                long now = System.currentTimeMillis();
                long remaining = nextRestartTime - now;
                if (!warningSent && remaining <= 300000L) {
                    ServerTask.sendRestartWarning(server);
                    warningSent = true;
                }
                if (remaining <= 0L) {
                    System.out.println("[ServerTask] Red\u00e9marrage automatique 24h...");
                    ServerTask.restartServer(server);
                }
            }
        }, 1000L, 1000L);
        timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                double tps = ServerTask.getServerTPS(server);
                if (tps < 9.0) {
                    System.out.println("[ServerTask] TPS trop bas (" + tps + "), red\u00e9marrage...");
                    ServerTask.sendLagWarning(server);
                    ServerTask.restartServer(server);
                }
            }
        }, 300000L, 300000L);
    }

    private static double getServerTPS(MinecraftServer server) {
        long[] tickTimes = server.field_71311_j;
        long total = 0L;
        for (long t : tickTimes) {
            total += t;
        }
        long avgTickNs = total / (long)tickTimes.length;
        if (avgTickNs <= 0L) {
            return 20.0;
        }
        double tps = 1.0E9 / (double)avgTickNs;
        return Math.min(20.0, tps);
    }

    private static void sendRestartWarning(MinecraftServer server) {
        PacketSendMessage packet = new PacketSendMessage();
        packet.addInformations("\u00a7cRed\u00e9marrage imminent", "\u00a77Le serveur red\u00e9marre dans \u00a7c5 minutes", 5);
        for (Object obj : server.func_71203_ab().field_72404_b) {
            if (!(obj instanceof EntityPlayerMP)) continue;
            Vartacraft.proxy.packetPipeline.sendTo(packet, (EntityPlayerMP)obj);
        }
    }

    private static void sendLagWarning(MinecraftServer server) {
        PacketSendMessage packet = new PacketSendMessage();
        packet.addInformations("\u00a74Serveur instable", "\u00a7cLag critique d\u00e9tect\u00e9, red\u00e9marrage...", 5);
        for (Object obj : server.func_71203_ab().field_72404_b) {
            if (!(obj instanceof EntityPlayerMP)) continue;
            Vartacraft.proxy.packetPipeline.sendTo(packet, (EntityPlayerMP)obj);
        }
    }

    private static void restartServer(MinecraftServer server) {
        try {
            server.func_71263_m();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("[ServerTask] Erreur pendant le red\u00e9marrage !");
        }
    }

    static {
        warningSent = false;
    }
}

