/*
 * Decompiled with CFR 0.152.
 */
package fr.vartax.world;

import cpw.mods.fml.common.IWorldGenerator;
import fr.vartax.Vartacraft;
import fr.vartax.config.WorldGenConfig;
import fr.vartax.future.BlockMod;
import fr.vartax.future.block.ChorusFlower;
import fr.vartax.init.register.RegisterBlock;
import fr.vartax.world.OceanMonument;
import fr.vartax.world.WorldGenFlower;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.feature.WorldGenFlowers;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraftforge.common.util.ForgeDirection;

public class WorldGenVartacraft
implements IWorldGenerator {
    private final List<WorldGenFlowers> flowers = new LinkedList<WorldGenFlowers>();
    private final List<WorldGenMinable> stoneGen = new LinkedList<WorldGenMinable>();
    public static int flowerPerChunk = 1;
    private final List<WorldGenMinable> generators = new LinkedList<WorldGenMinable>();

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        if (world.func_72912_H().func_82571_y().length() <= 0 || world.func_72912_H().func_82571_y().contains("decoration") || world.field_73011_w.field_76574_g != 0) {
            int monumentCeiling;
            int z;
            int y;
            int x;
            switch (world.field_73011_w.field_76574_g) {
                case -1: {
                    this.GenerateNether(world, chunkX * 16, chunkZ * 16, random);
                    break;
                }
                case 0: {
                    this.GenerateOverWorld(world, chunkX * 16, chunkZ * 16, random);
                    this.generateFlowers(world, random, chunkX * 16, chunkZ * 16);
                    break;
                }
                case 1: {
                    this.GenerateEnd(world, chunkX * 16, chunkZ * 16, random);
                }
            }
            if (Vartacraft.enableCoarseDirt && world.field_73011_w.field_76574_g != -1 && world.field_73011_w.field_76574_g != 1) {
                for (x = chunkX * 16; x < chunkX * 16 + 16; ++x) {
                    for (y = chunkZ * 16; y < chunkZ * 16 + 16; ++y) {
                        for (z = 0; z < world.func_72940_L(); ++z) {
                            if (world.func_147439_a(x, z, y) != Blocks.field_150346_d || world.func_72805_g(x, z, y) != 1) continue;
                            world.func_147465_d(x, z, y, BlockMod.coarse_dirt, 0, 2);
                        }
                    }
                }
            }
            if (Vartacraft.enableStones && Vartacraft.maxStonesPerCluster > 0 && world.field_73011_w.field_76574_g != -1 && world.field_73011_w.field_76574_g != 1) {
                for (WorldGenMinable generator : this.generators) {
                    for (z = 0; z < 10; ++z) {
                        monumentCeiling = chunkX * 16 + random.nextInt(16);
                        y = random.nextInt(80);
                        z = chunkZ * 16 + random.nextInt(16);
                        generator.func_76484_a(world, random, monumentCeiling, y, z);
                    }
                }
            }
            if (Vartacraft.enablePrismarine && world.field_73011_w.field_76574_g != -1 && world.field_73011_w.field_76574_g != 1 && OceanMonument.canSpawnAt(world, chunkX, chunkZ)) {
                x = chunkX * 16 + random.nextInt(16);
                z = chunkZ * 16 + random.nextInt(16);
                for (y = 256; y > 0 && world.func_147439_a(x, y, z).isAir((IBlockAccess)world, x, y, z); --y) {
                }
                monumentCeiling = y - (1 + random.nextInt(3));
                OceanMonument.buildTemple(world, x, monumentCeiling - 22, z);
                return;
            }
            if (Vartacraft.enableChorusFruit && world.field_73011_w.field_76574_g == 1) {
                x = chunkX * 16 + random.nextInt(16);
                z = chunkZ * 16 + random.nextInt(16);
                for (y = 256; y > 0 && world.func_147439_a(x, y, z).isAir((IBlockAccess)world, x, y, z); --y) {
                }
                if (y > 0 && ChorusFlower.canPlantStay(world, x, y + 1, z)) {
                    WorldGenVartacraft.generateChorusPlant(world, x, y + 1, z, 0);
                }
            }
        }
    }

    private void generateFlowers(World world, Random rand, int chunkX, int chunkZ) {
        for (int i = 0; i < flowerPerChunk; ++i) {
            int flowerType = rand.nextInt(14);
            int randPosX = chunkX + rand.nextInt(16) + 8;
            int randPosY = rand.nextInt(128);
            int randPosZ = chunkZ + rand.nextInt(16) + 8;
            new WorldGenFlower(RegisterBlock.SilithiumFlowers).func_76484_a(world, rand, randPosX, randPosY, randPosZ);
            new WorldGenFlower(RegisterBlock.flower_trefle).func_76484_a(world, rand, randPosX, randPosY, randPosZ);
            new WorldGenFlower(BlockMod.rose).func_76484_a(world, rand, randPosX, randPosY, randPosZ);
        }
    }

    private void addOre(Block block, Block blockSpawn, Random random, World world, int posX, int posZ, int minY, int maxY, int minV, int maxV, int spawnChance) {
        for (int i = 0; i < spawnChance; ++i) {
            int chunkSize = 16;
            int Xpos = posX + random.nextInt(chunkSize);
            int Ypos = minY + random.nextInt(maxY - minY);
            int Zpos = posZ + random.nextInt(chunkSize);
            new WorldGenMinable(block, maxV, blockSpawn).func_76484_a(world, random, Xpos, Ypos, Zpos);
        }
    }

    private void addStructure(String string, Random random, World world, int posX, int posZ, int minY, int maxY, int spawnChance) {
        for (int i = 0; i < spawnChance; ++i) {
            int chunkSize = 16;
            int var10000 = posX + random.nextInt(chunkSize);
            int Ypos = minY + random.nextInt(maxY - minY);
            var10000 = posZ + random.nextInt(chunkSize);
        }
    }

    private void GenerateOverWorld(World world, int i, int j, Random random) {
        if (!WorldGenConfig.enableCustomOres) {
            return;
        }
        if (WorldGenConfig.enableJadeOre) {
            this.addOre(RegisterBlock.jade_ore, Blocks.field_150348_b, random, world, i, j, WorldGenConfig.jadeOreMinY, WorldGenConfig.jadeOreMaxY, WorldGenConfig.jadeOreMinVeinSize, WorldGenConfig.jadeOreMaxVeinSize, WorldGenConfig.jadeOreSpawnChance);
        }
        if (WorldGenConfig.enableTitaneOre) {
            this.addOre(RegisterBlock.titane_ore, Blocks.field_150348_b, random, world, i, j, WorldGenConfig.titaneOreMinY, WorldGenConfig.titaneOreMaxY, WorldGenConfig.titaneOreMinVeinSize, WorldGenConfig.titaneOreMaxVeinSize, WorldGenConfig.titaneOreSpawnChance);
        }
        if (WorldGenConfig.enableVartoxOre) {
            this.addOre(RegisterBlock.vartox_ore, Blocks.field_150348_b, random, world, i, j, WorldGenConfig.vartoxOreMinY, WorldGenConfig.vartoxOreMaxY, WorldGenConfig.vartoxOreMinVeinSize, WorldGenConfig.vartoxOreMaxVeinSize, WorldGenConfig.vartoxOreSpawnChance);
        }
        if (WorldGenConfig.enableExperienceBush) {
            this.addOre(RegisterBlock.experiancebush, Blocks.field_150348_b, random, world, i, j, WorldGenConfig.experienceBushMinY, WorldGenConfig.experienceBushMaxY, WorldGenConfig.experienceBushMinVeinSize, WorldGenConfig.experienceBushMaxVeinSize, WorldGenConfig.experienceBushSpawnChance);
        }
        if (WorldGenConfig.enableMoneyOre) {
            this.addOre(RegisterBlock.Money_Ore, Blocks.field_150348_b, random, world, i, j, WorldGenConfig.moneyOreMinY, WorldGenConfig.moneyOreMaxY, WorldGenConfig.moneyOreMinVeinSize, WorldGenConfig.moneyOreMaxVeinSize, WorldGenConfig.moneyOreSpawnChance);
        }
        if (WorldGenConfig.enableStoneAndesite) {
            this.addOre(RegisterBlock.stoneandesite, Blocks.field_150348_b, random, world, i, j, WorldGenConfig.stoneAndesiteMinY, WorldGenConfig.stoneAndesiteMaxY, WorldGenConfig.stoneAndesiteMinVeinSize, WorldGenConfig.stoneAndesiteMaxVeinSize, WorldGenConfig.stoneAndesiteSpawnChance);
        }
        if (WorldGenConfig.enableStoneDiorite) {
            this.addOre(RegisterBlock.stonediorite, Blocks.field_150348_b, random, world, i, j, WorldGenConfig.stoneDioriteMinY, WorldGenConfig.stoneDioriteMaxY, WorldGenConfig.stoneDioriteMinVeinSize, WorldGenConfig.stoneDioriteMaxVeinSize, WorldGenConfig.stoneDioriteSpawnChance);
        }
        if (WorldGenConfig.enableStoneGranite) {
            this.addOre(RegisterBlock.stonegranite, Blocks.field_150348_b, random, world, i, j, WorldGenConfig.stoneGraniteMinY, WorldGenConfig.stoneGraniteMaxY, WorldGenConfig.stoneGraniteMinVeinSize, WorldGenConfig.stoneGraniteMaxVeinSize, WorldGenConfig.stoneGraniteSpawnChance);
        }
        if (WorldGenConfig.enableRandomOre) {
            this.addOre(RegisterBlock.RandomOre, Blocks.field_150348_b, random, world, i, j, WorldGenConfig.randomOreMinY, WorldGenConfig.randomOreMaxY, WorldGenConfig.randomOreMinVeinSize, WorldGenConfig.randomOreMaxVeinSize, WorldGenConfig.randomOreSpawnChance);
        }
    }

    private void GenerateNether(World world, int i, int j, Random random) {
        this.addOre(RegisterBlock.block_ancient_debris, Blocks.field_150424_aL, random, world, i, j, 10, 18, 3, 5, 10);
        this.addOre(RegisterBlock.nether_gold_ore, Blocks.field_150424_aL, random, world, i, j, 10, 117, 5, 7, 60);
        this.addOre(RegisterBlock.nether_diamond_ore, Blocks.field_150424_aL, random, world, i, j, 10, 18, 3, 7, 14);
        this.addOre(RegisterBlock.nether_iron_ore, Blocks.field_150424_aL, random, world, i, j, 10, 117, 5, 7, 70);
        this.addOre(RegisterBlock.nether_coal_ore, Blocks.field_150424_aL, random, world, i, j, 10, 117, 5, 7, 80);
        this.addOre(RegisterBlock.nether_emerald_ore, Blocks.field_150424_aL, random, world, i, j, 10, 18, 2, 4, 12);
    }

    private void GenerateEnd(World world, int i, int j, Random random) {
    }

    public static void generateChorusPlant(World world, int x, int y, int z, int pass) {
        int height;
        for (height = 0; height < 4; ++height) {
            if (!ChorusFlower.canPlantStay(world, x, y + height, z)) {
                world.func_147465_d(x, y + height, z, RegisterBlock.chorus_flower, 5, 2);
                break;
            }
            world.func_147449_b(x, y + height, z, RegisterBlock.chorus_plant);
        }
        if (height > 1) {
            world.func_147449_b(x, y + height, z, RegisterBlock.chorus_plant);
            boolean grew = false;
            if (pass < 5) {
                ForgeDirection[] dirs = new ForgeDirection[]{ForgeDirection.EAST, ForgeDirection.WEST, ForgeDirection.NORTH, ForgeDirection.SOUTH};
                for (int j = 0; j < world.field_73012_v.nextInt(4); ++j) {
                    ForgeDirection dir = dirs[world.field_73012_v.nextInt(dirs.length)];
                    int xx = x + dir.offsetX;
                    int yy = y + height + dir.offsetY;
                    int zz = z + dir.offsetZ;
                    if (!world.func_147437_c(xx, yy, zz) || !ChorusFlower.isSpaceAroundFree(world, xx, yy, zz, dir.getOpposite())) continue;
                    WorldGenVartacraft.generateChorusPlant(world, xx, yy, zz, pass + 1);
                    grew = true;
                }
            }
            if (!grew) {
                world.func_147465_d(x, y + height, z, RegisterBlock.chorus_flower, 5, 2);
            }
        }
    }
}

