/*
 * Decompiled with CFR 0.152.
 */
package vartacraft.discord.main.servermanager.managementserver.globalstats;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Calendar;
import java.util.Date;
import java.util.Objects;
import vartacraft.discord.main.Main;
import vartacraft.discord.main.servermanager.managementserver.managers.ProfileManager;
import vartacraft.discord.main.servermanager.managementserver.objects.ObjectGlobalStats;
import vartacraft.discord.main.servermanager.managementserver.objects.ObjectPlayerProfile;

public class GlobalStatsUpdater
extends Thread {
    public static Date lastCheck = Calendar.getInstance().getTime();
    public static Gson gson = new GsonBuilder().setPrettyPrinting().create();

    @Override
    public void run() {
        while (true) {
            long seconds;
            if ((seconds = (Calendar.getInstance().getTimeInMillis() - lastCheck.getTime()) / 1000L) <= 900L) {
                continue;
            }
            Main.globalStatsIsBeingUpdated = true;
            lastCheck = Calendar.getInstance().getTime();
            long humanKills = 0L;
            long zombieKills = 0L;
            File folder = new File("profiles/");
            if (!folder.exists()) continue;
            for (File fileEntry : Objects.requireNonNull(folder.listFiles())) {
                try {
                    if (!fileEntry.exists() || !ProfileManager.doesProfileExist(fileEntry.getName().replace(".json", ""))) continue;
                    String uuid = fileEntry.getName().replace(".json", "");
                    ObjectPlayerProfile playerProfile = ProfileManager.getPlayerProfileFromUUID(uuid);
                    humanKills += playerProfile.playerKills;
                    zombieKills += playerProfile.zombieKills;
                    if (playerProfile.zombieKills > 999999L) {
                        ProfileManager.setZombieKills(playerProfile.playerUUID, 999999);
                    }
                    if (playerProfile.playerKills <= 999999L) continue;
                    ProfileManager.setHumanKills(playerProfile.playerUUID, 999999);
                }
                catch (IOException var15) {
                    var15.printStackTrace();
                }
            }
            try {
                this.updateGlobalStats(humanKills, zombieKills);
                continue;
            }
            catch (IOException var14) {
                var14.printStackTrace();
                continue;
            }
            break;
        }
    }

    public void updateGlobalStats(long givenHumanKills, long givenZombieKills) throws IOException {
        ObjectGlobalStats globalStatsObject = new ObjectGlobalStats();
        globalStatsObject.globalHumanDeaths = givenHumanKills;
        globalStatsObject.globalZombieDeaths = givenZombieKills;
        File globalStatsFile = new File("globalStats.json");
        globalStatsFile.createNewFile();
        FileWriter writer = new FileWriter(globalStatsFile);
        writer.write(gson.toJson((Object)globalStatsObject));
        ((Writer)writer).close();
        Main.globalStatsIsBeingUpdated = false;
    }
}

