/*
 * Decompiled with CFR 0.152.
 */
package vartacraft.discord.main.servermanager.managementserver.managers;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.TreeMap;
import vartacraft.discord.main.servermanager.common.ServerDirectories;
import vartacraft.discord.main.servermanager.common.VartacraftLogger;
import vartacraft.discord.main.servermanager.common.enums.EnumLogType;
import vartacraft.discord.main.servermanager.managementserver.enums.EnumBattlegroundsRank;
import vartacraft.discord.main.servermanager.managementserver.enums.EnumCapeDesign;
import vartacraft.discord.main.servermanager.managementserver.enums.EnumDiscordRank;
import vartacraft.discord.main.servermanager.managementserver.objects.ObjectDiscordProfile;
import vartacraft.discord.main.servermanager.managementserver.objects.ObjectPlayerProfile;

public class ProfileManager {
    public static String profilesDir = "profiles/";
    public static String discordProfilesDir = "discordProfiles/";
    public static Gson gson = new GsonBuilder().setPrettyPrinting().create();
    public static TreeMap<String, ObjectPlayerProfile> playerProfileMapping = new TreeMap(String.CASE_INSENSITIVE_ORDER);
    public static TreeMap<String, ObjectDiscordProfile> discordProfileMapping = new TreeMap(String.CASE_INSENSITIVE_ORDER);

    public static ObjectPlayerProfile getPlayerProfileFromUUID(String uuid) throws IOException {
        if (uuid != null && uuid.length() > 0) {
            if (!playerProfileMapping.containsKey(uuid)) {
                playerProfileMapping.put(uuid, ProfileManager.getProfileFromUUID(uuid));
            }
            return playerProfileMapping.get(uuid);
        }
        return null;
    }

    public static ObjectDiscordProfile getDiscordProfileFromID(String uuid) throws IOException {
        if (uuid != null && uuid.length() > 0) {
            if (!discordProfileMapping.containsKey(uuid) && ProfileManager.doesDiscordProfileExist(uuid)) {
                discordProfileMapping.put(uuid, ProfileManager.getDiscordProfileFromFile(uuid));
            }
            return discordProfileMapping.get(uuid);
        }
        return null;
    }

    public static void saveAllPlayerProfiles() throws IOException {
        ArrayList<String> failedUUIDs = new ArrayList<String>();
        int failCount = 0;
        int totalCount = playerProfileMapping.size();
        int count = 1;
        for (Map.Entry<String, ObjectPlayerProfile> entry : playerProfileMapping.entrySet()) {
            try {
                VartacraftLogger.printLine(EnumLogType.NETWORK, "Saving profile (" + count + " of " + totalCount + ") - K: '" + entry.getKey() + "'");
                ProfileManager.savePlayerProfile(entry.getValue().playerUUID);
                ++count;
            }
            catch (NullPointerException var9) {
                try {
                    failedUUIDs.add(entry.getValue().playerUUID);
                    ProfileManager.purgeUser(entry.getValue().playerUUID);
                    VartacraftLogger.printError(EnumLogType.NETWORK, "Purged User UUID: " + entry.getValue().playerUUID);
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                ++failCount;
            }
        }
        FileWriter writer = new FileWriter("failedUUIDs.txt");
        for (String str : failedUUIDs) {
            writer.write(str);
        }
        writer.close();
        playerProfileMapping.clear();
        VartacraftLogger.printError(EnumLogType.NETWORK, "Failed to save " + failCount + " profiles (Purged Profiles)");
    }

    public static void saveAllDiscordProfiles() throws IOException {
        ArrayList<ObjectDiscordProfile> list = new ArrayList<ObjectDiscordProfile>(discordProfileMapping.values());
        for (ObjectDiscordProfile data : list) {
            ProfileManager.saveDiscordProfile(data.discordID);
        }
    }

    public static void savePlayerProfile(String givenUUID) throws IOException {
        ObjectPlayerProfile playerProfile = ProfileManager.getPlayerProfileFromUUID(givenUUID);
        File profileFile = new File(profilesDir + playerProfile.playerUUID + ".json");
        FileOutputStream stream = new FileOutputStream(profileFile);
        DataOutputStream dataout = new DataOutputStream(stream);
        FileWriter writer = new FileWriter(profileFile);
        writer.write(gson.toJson((Object)playerProfile));
        writer.close();
        ((OutputStream)stream).close();
        dataout.close();
    }

    public static void saveDiscordProfile(String givenUUID) throws IOException {
        ObjectPlayerProfile discordProfile = ProfileManager.getPlayerProfileFromUUID(givenUUID);
        if (discordProfile != null) {
            File profileFile = new File(discordProfilesDir + discordProfile.discordID + ".json");
            FileWriter writer = new FileWriter(profileFile);
            writer.write(gson.toJson((Object)discordProfile));
            writer.close();
        }
    }

    public static ObjectPlayerProfile getProfileFromUUID(String givenUUID) throws IOException {
        File profileFile = new File(profilesDir + givenUUID + ".json");
        if (!profileFile.exists() || !ProfileManager.doesProfileExist(givenUUID)) {
            ProfileManager.createPlayerProfile(givenUUID);
        }
        if (ProfileManager.doesProfileExist(givenUUID)) {
            BufferedReader br = new BufferedReader(new FileReader(profileFile));
            ObjectPlayerProfile theProfile = (ObjectPlayerProfile)gson.fromJson((Reader)br, ObjectPlayerProfile.class);
            return theProfile;
        }
        return null;
    }

    public static void createPlayerProfile(String givenUUID) throws IOException {
        ObjectPlayerProfile newProfile = new ObjectPlayerProfile();
        newProfile.playerUUID = givenUUID;
        newProfile.playerDeaths = 0L;
        newProfile.playerKills = 0L;
        newProfile.discordAuthCode = ProfileManager.generateAuthCode();
        newProfile.discordID = "";
        newProfile.rankID = 0;
        newProfile.dateCreated = Calendar.getInstance().getTime();
        new File(profilesDir + "/").mkdirs();
        File profileFile = new File(profilesDir + givenUUID + ".json");
        if (!profileFile.exists()) {
            profileFile.createNewFile();
        }
        playerProfileMapping.put(givenUUID, newProfile);
    }

    public static void createPlayerProfileWithSupport(String givenUUID, boolean givenSupporterStatus) throws IOException {
        File newProfileFile = new File(ServerDirectories.profilesDirectory + givenUUID);
        if (!newProfileFile.exists()) {
            ObjectPlayerProfile newProfile = new ObjectPlayerProfile();
            newProfile.playerUUID = givenUUID;
            newProfile.playerDeaths = 0L;
            newProfile.playerKills = 0L;
            newProfile.discordAuthCode = ProfileManager.generateAuthCode();
            newProfile.discordID = "";
            newProfile.rankID = 0;
            newProfile.isSupporter = givenSupporterStatus;
            new File(profilesDir + "/").mkdirs();
            File profileFile = new File(profilesDir + givenUUID + ".json");
            if (!profileFile.exists()) {
                profileFile.createNewFile();
            }
            playerProfileMapping.put(givenUUID, newProfile);
        }
    }

    public static boolean doesProfileExist(String givenUUID) {
        File profileFile = new File(profilesDir + givenUUID + ".json");
        return profileFile.exists() && profileFile.length() > 0L;
    }

    public static void addZombieKillToPlayer(String givenUUID, long givenAmount) throws IOException {
        File profileFile = new File(profilesDir + givenUUID + ".json");
        if (profileFile.exists()) {
            ObjectPlayerProfile theProfile = ProfileManager.getPlayerProfileFromUUID(givenUUID);
            theProfile.zombieKills += givenAmount;
        }
    }

    public static void addKillToPlayer(String givenUUID, long givenAmount) throws IOException {
        File profileFile = new File(profilesDir + givenUUID + ".json");
        if (profileFile.exists()) {
            ObjectPlayerProfile theProfile = ProfileManager.getPlayerProfileFromUUID(givenUUID);
            theProfile.playerKills += givenAmount;
        }
    }

    public static void addDeathToPlayer(String givenUUID, long givenAmount) throws IOException {
        File profileFile = new File(profilesDir + givenUUID + ".json");
        if (profileFile.exists()) {
            ObjectPlayerProfile theProfile = ProfileManager.getPlayerProfileFromUUID(givenUUID);
            theProfile.playerDeaths += givenAmount;
        }
    }

    public static boolean isAuthCodeValid(String givenUUID, String givenAuthCode) throws IOException {
        File profileFile = new File(profilesDir + givenUUID + ".json");
        if (profileFile.exists()) {
            ObjectPlayerProfile theProfile = ProfileManager.getPlayerProfileFromUUID(givenUUID);
            return theProfile.discordAuthCode.equals(givenAuthCode);
        }
        return false;
    }

    public static void setNewDiscordID(String givenUUID, String givenDiscordID) throws IOException {
        File profileFile = new File(profilesDir + givenUUID + ".json");
        if (profileFile.exists()) {
            ObjectPlayerProfile theProfile = ProfileManager.getPlayerProfileFromUUID(givenUUID);
            theProfile.discordID = givenDiscordID;
        }
    }

    public static String generateAuthCode() {
        SecureRandom random = new SecureRandom();
        return new BigInteger(40, random).toString(32);
    }

    public static boolean doesDiscordProfileExist(String givenDiscordID) {
        File profileFile = new File(discordProfilesDir + givenDiscordID + ".json");
        return profileFile.exists() && profileFile.length() > 0L;
    }

    public static void createDiscordProfile(String givenUUID, String givenDiscordID) throws IOException {
        File newProfileFile = new File(discordProfilesDir + givenDiscordID);
        if (!newProfileFile.exists()) {
            ObjectDiscordProfile newProfile = new ObjectDiscordProfile();
            newProfile.playerUUID = givenUUID;
            newProfile.discordID = givenDiscordID;
            new File(discordProfilesDir).mkdirs();
            File profileFile = new File(discordProfilesDir + givenDiscordID + ".json");
            if (!profileFile.exists()) {
                profileFile.createNewFile();
            }
            discordProfileMapping.put(givenUUID, newProfile);
        }
    }

    public static ObjectDiscordProfile getDiscordProfileFromFile(String givenDiscordID) throws IOException {
        File profileFile = new File(discordProfilesDir + givenDiscordID + ".json");
        if (ProfileManager.doesDiscordProfileExist(givenDiscordID)) {
            BufferedReader br = new BufferedReader(new FileReader(profileFile));
            ObjectDiscordProfile theProfile = (ObjectDiscordProfile)gson.fromJson((Reader)br, ObjectDiscordProfile.class);
            br.close();
            return theProfile;
        }
        return null;
    }

    public static void setNewAuthCode(String givenUUID, String givenAuthCode) throws IOException {
        File profileFile;
        if (ProfileManager.isAuthCodeValid(givenUUID, givenAuthCode) && (profileFile = new File(profilesDir + givenUUID + ".json")).exists()) {
            ObjectPlayerProfile theProfile = ProfileManager.getPlayerProfileFromUUID(givenUUID);
            theProfile.discordAuthCode = ProfileManager.generateAuthCode();
        }
    }

    public static void promoteUser(String givenUUID) throws IOException {
        File profileFile = new File(profilesDir + givenUUID + ".json");
        if (profileFile.exists()) {
            ObjectPlayerProfile theProfile = ProfileManager.getPlayerProfileFromUUID(givenUUID);
            theProfile.xp = 0;
            switch (theProfile.playerRank) {
                case CIVILIAN: {
                    theProfile.playerRank = EnumDiscordRank.SCAVENGER;
                    break;
                }
                case SCAVENGER: {
                    theProfile.playerRank = EnumDiscordRank.SURVIVOR;
                    break;
                }
                case SURVIVOR: {
                    theProfile.playerRank = EnumDiscordRank.LONE_RANGER;
                    break;
                }
                case LONE_RANGER: {
                    theProfile.playerRank = EnumDiscordRank.ZOMBIE_KILLER;
                    break;
                }
                case ZOMBIE_KILLER: {
                    theProfile.playerRank = EnumDiscordRank.HEAD_CRACKER;
                    break;
                }
                case HEAD_CRACKER: {
                    theProfile.playerRank = EnumDiscordRank.BRAIN_EATER;
                    break;
                }
                case BRAIN_EATER: {
                    theProfile.playerRank = EnumDiscordRank.RADIO_ACTIVE;
                    break;
                }
                case RADIO_ACTIVE: {
                    theProfile.playerRank = EnumDiscordRank.DECIMATOR;
                }
            }
        }
    }

    public static void promoteUserBattlegrounds(String givenUUID) throws IOException {
        File profileFile = new File(profilesDir + givenUUID + ".json");
        if (profileFile.exists()) {
            ObjectPlayerProfile theProfile = ProfileManager.getPlayerProfileFromUUID(givenUUID);
            theProfile.xpBattlegrounds = 0L;
            switch (theProfile.bgRank) {
                case NOOB: {
                    theProfile.bgRank = EnumBattlegroundsRank.RECRUIT;
                    break;
                }
                case RECRUIT: {
                    theProfile.bgRank = EnumBattlegroundsRank.EXPERIENCED;
                    break;
                }
                case EXPERIENCED: {
                    theProfile.bgRank = EnumBattlegroundsRank.SURVIVOR;
                    break;
                }
                case SURVIVOR: {
                    theProfile.bgRank = EnumBattlegroundsRank.MURDERER;
                    break;
                }
                case MURDERER: {
                    theProfile.bgRank = EnumBattlegroundsRank.KILLER;
                    break;
                }
                case KILLER: {
                    theProfile.bgRank = EnumBattlegroundsRank.COLD_KILER;
                    break;
                }
                case COLD_KILER: {
                    theProfile.bgRank = EnumBattlegroundsRank.DOMINATOR;
                    break;
                }
                case DOMINATOR: {
                    theProfile.bgRank = EnumBattlegroundsRank.NUCLEAR;
                    break;
                }
                case NUCLEAR: {
                    theProfile.bgRank = EnumBattlegroundsRank.GOD_LIKE;
                    break;
                }
                case GOD_LIKE: {
                    theProfile.bgRank = EnumBattlegroundsRank.GOD;
                }
            }
        }
    }

    public static void addXPToPlayer(String givenUUID, int givenAmount) throws IOException {
        File profileFile = new File(profilesDir + givenUUID + ".json");
        if (profileFile.exists()) {
            ObjectPlayerProfile theProfile = ProfileManager.getPlayerProfileFromUUID(givenUUID);
            theProfile.xp += givenAmount;
        }
    }

    public static void addBattlegroundsXPToPlayer(String givenUUID, long givenAmount) throws IOException {
        File profileFile = new File(profilesDir + givenUUID + ".json");
        if (profileFile.exists()) {
            ObjectPlayerProfile theProfile = ProfileManager.getPlayerProfileFromUUID(givenUUID);
            theProfile.xpBattlegrounds += givenAmount;
            ProfileManager.checkIfPlayerCanRankupBattlegrounds(givenUUID);
        }
    }

    public static void setDate(String givenUUID, Date date) throws IOException {
        File profileFile = new File(profilesDir + givenUUID + ".json");
        if (profileFile.exists()) {
            ObjectPlayerProfile theProfile = ProfileManager.getPlayerProfileFromUUID(givenUUID);
            theProfile.lastMessage = date;
        }
    }

    public static void setSupporter(String givenUUID, boolean givenSupporterStatus) throws IOException {
        File profileFile = new File(profilesDir + givenUUID + ".json");
        if (profileFile.exists()) {
            ObjectPlayerProfile theProfile = ProfileManager.getPlayerProfileFromUUID(givenUUID);
            theProfile.isSupporter = givenSupporterStatus;
            if (givenSupporterStatus) {
                theProfile.dateBecameSupporter = Calendar.getInstance().getTime();
            }
        } else {
            ProfileManager.createPlayerProfileWithSupport(givenUUID, givenSupporterStatus);
        }
    }

    public static void changeCapeToID(String givenUUID, int givenCapeDesignID) throws IOException {
        File profileFile = new File(profilesDir + givenUUID + ".json");
        if (profileFile.exists()) {
            boolean found = false;
            ObjectPlayerProfile theProfile = ProfileManager.getPlayerProfileFromUUID(givenUUID);
            for (EnumCapeDesign capeDesign : EnumCapeDesign.values()) {
                if (capeDesign.getID() != (long)givenCapeDesignID) continue;
                found = true;
                theProfile.capeDesign = capeDesign;
                break;
            }
        }
    }

    public static void setHumanKills(String givenUUID, int givenKillCount) throws IOException {
        File profileFile = new File(profilesDir + givenUUID + ".json");
        if (profileFile.exists()) {
            ObjectPlayerProfile theProfile = ProfileManager.getPlayerProfileFromUUID(givenUUID);
            theProfile.playerKills = givenKillCount;
        }
    }

    public static void setZombieKills(String givenUUID, int givenKillCount) throws IOException {
        File profileFile = new File(profilesDir + givenUUID + ".json");
        if (profileFile.exists()) {
            ObjectPlayerProfile theProfile = ProfileManager.getPlayerProfileFromUUID(givenUUID);
            theProfile.zombieKills = givenKillCount;
        }
    }

    public static void setDateSeconds(String playerUUID, Date time) throws IOException {
        File profileFile = new File(profilesDir + playerUUID + ".json");
        if (profileFile.exists()) {
            ObjectPlayerProfile theProfile = ProfileManager.getPlayerProfileFromUUID(playerUUID);
            theProfile.lastMessageSeconds = time;
        }
    }

    public static void purgeUser(String givenPlayerUUID) throws IOException {
        File discordProfileFile;
        File profileFile = new File(profilesDir + givenPlayerUUID + ".json");
        ObjectPlayerProfile theProfile = ProfileManager.getPlayerProfileFromUUID(givenPlayerUUID);
        if (ProfileManager.doesDiscordProfileExist(theProfile.discordID) && (discordProfileFile = new File(discordProfilesDir + theProfile.discordID + ".json")).exists()) {
            discordProfileFile.delete();
        }
        if (profileFile.exists()) {
            profileFile.delete();
        }
    }

    public static void checkIfPlayerCanRankupBattlegrounds(String givenPlayerUUID) throws IOException {
        ObjectPlayerProfile playerProfile = ProfileManager.getPlayerProfileFromUUID(givenPlayerUUID);
        if (playerProfile.xpBattlegrounds >= playerProfile.getRequiredXPBattlegrounds()) {
            ProfileManager.promoteUserBattlegrounds(givenPlayerUUID);
            if (playerProfile.discordID != null && ProfileManager.doesDiscordProfileExist(playerProfile.discordID)) {
                ObjectDiscordProfile objectDiscordProfile = ProfileManager.getDiscordProfileFromID(playerProfile.discordID);
            }
        }
    }

    public static void addBattlegroundsWinToPlayer(String givenPlayerUUID) throws IOException {
        File profileFile = new File(profilesDir + givenPlayerUUID + ".json");
        if (profileFile.exists()) {
            ObjectDiscordProfile discordProfile;
            ObjectPlayerProfile theProfile = ProfileManager.getPlayerProfileFromUUID(givenPlayerUUID);
            ++theProfile.bgWins;
            if (theProfile.discordID == null || !ProfileManager.doesDiscordProfileExist(theProfile.discordID) || (discordProfile = ProfileManager.getDiscordProfileFromID(theProfile.discordID)) != null) {
                // empty if block
            }
        }
    }

    public static void unlockEmblemForPlayer(String givenPlayerUUID, int givenEmblemID) throws IOException {
        File profileFile = new File(profilesDir + givenPlayerUUID + ".json");
        if (profileFile.exists()) {
            ObjectPlayerProfile theProfile = ProfileManager.getPlayerProfileFromUUID(givenPlayerUUID);
            theProfile.unlockedEmblems.add("emblem_" + givenEmblemID);
        }
    }

    public static void addBattlegroundsLossToPlayer(String givenPlayerUUID) throws IOException {
        File profileFile = new File(profilesDir + givenPlayerUUID + ".json");
        if (profileFile.exists()) {
            ObjectPlayerProfile theProfile = ProfileManager.getPlayerProfileFromUUID(givenPlayerUUID);
            ++theProfile.bgLosses;
        }
    }
}

