/*
 * Decompiled with CFR 0.152.
 */
package com.khorn.terraincontrol.configuration;

import com.khorn.terraincontrol.TerrainControl;
import com.khorn.terraincontrol.configuration.BiomeConfig;
import com.khorn.terraincontrol.configuration.BiomeLoadInstruction;
import com.khorn.terraincontrol.configuration.WorldConfig;
import com.khorn.terraincontrol.configuration.io.FileSettingsReader;
import com.khorn.terraincontrol.configuration.standard.BiomeStandardValues;
import com.khorn.terraincontrol.logging.LogMarker;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class BiomeConfigFinder {
    private final WorldConfig worldConfig;
    private final String preferredBiomeFileExtension;

    public BiomeConfigFinder(WorldConfig worldConfig, String preferredBiomeFileExtension) {
        this.worldConfig = worldConfig;
        this.preferredBiomeFileExtension = preferredBiomeFileExtension;
    }

    public Map<String, BiomeConfig> loadBiomesFromDirectories(Collection<File> directories, Collection<BiomeLoadInstruction> biomesToLoad) {
        HashMap<String, BiomeConfig> biomeConfigsStore = new HashMap<String, BiomeConfig>();
        HashMap<String, BiomeLoadInstruction> remainingBiomes = new HashMap<String, BiomeLoadInstruction>();
        for (BiomeLoadInstruction biome : biomesToLoad) {
            remainingBiomes.put(biome.getBiomeName(), biome);
        }
        for (File directory : directories) {
            if (!directory.exists()) continue;
            this.loadBiomesFromDirectory(biomeConfigsStore, directory, remainingBiomes);
        }
        File preferredDirectory = directories.iterator().next();
        for (BiomeLoadInstruction localBiome : remainingBiomes.values()) {
            File newConfigFile = new File(preferredDirectory, this.toFileName(localBiome));
            this.loadBiomeFromFile(biomeConfigsStore, newConfigFile, localBiome);
        }
        return biomeConfigsStore;
    }

    private void loadBiomesFromDirectory(Map<String, BiomeConfig> biomeConfigsStore, File directory, Map<String, BiomeLoadInstruction> remainingBiomes) {
        for (File file : directory.listFiles()) {
            BiomeLoadInstruction biome;
            if (file.isDirectory()) {
                this.loadBiomesFromDirectory(biomeConfigsStore, file, remainingBiomes);
                continue;
            }
            String biomeName = this.toBiomeName(file);
            if (biomeName == null || (biome = remainingBiomes.get(biomeName)) == null) continue;
            this.loadBiomeFromFile(biomeConfigsStore, file, biome);
            remainingBiomes.remove(biome.getBiomeName());
        }
    }

    private void loadBiomeFromFile(Map<String, BiomeConfig> biomeConfigsStore, File file, BiomeLoadInstruction loadInstruction) {
        File renamedFile = this.renameBiomeFile(file, loadInstruction);
        FileSettingsReader reader = new FileSettingsReader(loadInstruction.getBiomeName(), renamedFile);
        BiomeConfig biomeConfig = new BiomeConfig(reader, loadInstruction, this.worldConfig);
        biomeConfigsStore.put(loadInstruction.getBiomeName(), biomeConfig);
    }

    private File renameBiomeFile(File toRename, BiomeLoadInstruction biome) {
        String preferredFileName = this.toFileName(biome);
        if (toRename.getName().equalsIgnoreCase(preferredFileName)) {
            return toRename;
        }
        File newFile = new File(toRename.getParentFile(), preferredFileName);
        if (toRename.renameTo(newFile)) {
            return newFile;
        }
        TerrainControl.log(LogMarker.INFO, "Failed to rename biome file {} to {}", toRename.getAbsolutePath(), newFile.getAbsolutePath());
        return toRename;
    }

    private String toFileName(BiomeLoadInstruction biome) {
        return biome.getBiomeName() + this.preferredBiomeFileExtension;
    }

    private String toBiomeName(File file) {
        String fileName = file.getName();
        for (String extension : BiomeStandardValues.BiomeConfigExtensions) {
            if (!fileName.endsWith(extension)) continue;
            String biomeName = fileName.substring(0, fileName.lastIndexOf(extension));
            return biomeName;
        }
        return null;
    }
}

