/*
 * Decompiled with CFR 0.152.
 */
package com.khorn.terraincontrol.configuration;

import com.khorn.terraincontrol.LocalBiome;
import com.khorn.terraincontrol.LocalWorld;
import com.khorn.terraincontrol.TerrainControl;
import com.khorn.terraincontrol.configuration.BiomeConfig;
import com.khorn.terraincontrol.configuration.ConfigFunction;
import com.khorn.terraincontrol.configuration.WorldConfig;
import com.khorn.terraincontrol.exception.InvalidConfigException;
import com.khorn.terraincontrol.logging.LogMarker;
import com.khorn.terraincontrol.util.helpers.StringHelper;
import com.khorn.terraincontrol.util.minecraftTypes.DefaultBiome;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

public final class BiomeGroup
extends ConfigFunction<WorldConfig> {
    private int groupId;
    private String name;
    private int groupRarity;
    private int generationDepth = 0;
    private float avgTemp = 0.0f;
    private Map<String, LocalBiome> biomes = new LinkedHashMap<String, LocalBiome>(32);
    public int totalGroupRarity;

    public BiomeGroup() {
    }

    public BiomeGroup(WorldConfig config, String groupName, int size, int rarity, List<String> biomes) {
        this.setHolder(config);
        this.name = groupName;
        this.generationDepth = size;
        this.groupRarity = rarity;
        for (String biome : biomes) {
            this.biomes.put(biome, null);
        }
    }

    @Override
    protected void load(List<String> args) throws InvalidConfigException {
        this.assureSize(4, args);
        this.name = args.get(0);
        this.generationDepth = this.readInt(args.get(1), 0, ((WorldConfig)this.getHolder()).GenerationDepth);
        this.groupRarity = this.readInt(args.get(2), 1, Integer.MAX_VALUE);
        for (String biome : this.readBiomes(args, 3)) {
            this.biomes.put(biome, null);
        }
    }

    public void processBiomeData(LocalWorld world) {
        float totalTemp = 0.0f;
        this.totalGroupRarity = 0;
        for (Map.Entry<String, LocalBiome> entry : this.biomes.entrySet()) {
            String biomeName = entry.getKey();
            LocalBiome localBiome = world.getBiomeByName(biomeName);
            entry.setValue(localBiome);
            BiomeConfig biomeConfig = localBiome.getBiomeConfig();
            totalTemp += biomeConfig.biomeTemperature;
            this.totalGroupRarity += biomeConfig.biomeRarity;
        }
        this.avgTemp = totalTemp / (float)this.biomes.size();
    }

    @Override
    public Class<WorldConfig> getHolderType() {
        return WorldConfig.class;
    }

    @Override
    public String makeString() {
        return "BiomeGroup(" + this.name + ", " + this.generationDepth + ", " + this.groupRarity + ", " + StringHelper.join(this.biomes.keySet(), ", ") + ")";
    }

    protected List<String> readBiomes(List<String> strings, int start) throws InvalidConfigException {
        return new ArrayList<String>(strings.subList(start, strings.size()));
    }

    public String getName() {
        return this.name;
    }

    void filterBiomes(Set<String> customBiomeNames) {
        Iterator<String> it = this.biomes.keySet().iterator();
        while (it.hasNext()) {
            String biomeName = it.next();
            if (DefaultBiome.Contain(biomeName) || customBiomeNames.contains(biomeName)) continue;
            TerrainControl.log(LogMarker.WARN, "Invalid biome name {} in biome group {}", biomeName, this.name);
            it.remove();
        }
    }

    public boolean containsBiome(String name) {
        return this.biomes.containsKey(name);
    }

    void setGroupId(int groupId) {
        if (groupId > 127) {
            throw new IllegalArgumentException("Tried to set group id to " + groupId + ", max allowed is " + 127);
        }
        this.groupId = groupId;
    }

    public int getGroupId() {
        return this.groupId;
    }

    public boolean isColdGroup() {
        return this.avgTemp < 0.33f;
    }

    @Override
    public boolean isAnalogousTo(ConfigFunction<WorldConfig> other) {
        if (other instanceof BiomeGroup) {
            BiomeGroup group = (BiomeGroup)other;
            return group.name.equalsIgnoreCase(this.name);
        }
        return false;
    }

    public SortedMap<Integer, LocalBiome> getDepthMap(int depth) {
        int cumulativeBiomeRarity = 0;
        TreeMap<Integer, LocalBiome> map = new TreeMap<Integer, LocalBiome>();
        for (Map.Entry<String, LocalBiome> biome : this.biomes.entrySet()) {
            if (biome.getValue().getBiomeConfig().biomeSize != depth && depth >= 0) continue;
            map.put(cumulativeBiomeRarity += biome.getValue().getBiomeConfig().biomeRarity, biome.getValue());
        }
        return map;
    }

    public int getGroupRarity() {
        return this.groupRarity;
    }

    public int getGenerationDepth() {
        return this.generationDepth;
    }

    public boolean hasNoBiomes() {
        return this.biomes.isEmpty();
    }
}

