/*
 * Decompiled with CFR 0.152.
 */
package com.khorn.terraincontrol.configuration.settingType;

import com.khorn.terraincontrol.configuration.settingType.Setting;
import com.khorn.terraincontrol.exception.InvalidConfigException;

class ColorSetting
extends Setting<Integer> {
    private int defaultValue;

    ColorSetting(String name, String defaultValue) {
        super(name);
        this.defaultValue = Integer.decode(defaultValue);
    }

    @Override
    public Integer getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public Integer read(String string) throws InvalidConfigException {
        try {
            Integer integer = Integer.decode(string);
            if (integer > 0xFFFFFF || integer < 0) {
                throw new InvalidConfigException("Color must have 6 hexadecimal digits");
            }
            return integer;
        }
        catch (NumberFormatException e) {
            throw new InvalidConfigException("Invalid color " + string);
        }
    }

    @Override
    public String write(Integer value) {
        return "#" + Integer.toHexString(value | 0x1000000).substring(1).toUpperCase();
    }
}

