/*
 * Decompiled with CFR 0.152.
 */
package com.khorn.terraincontrol.customobjects;

import com.khorn.terraincontrol.TerrainControl;
import com.khorn.terraincontrol.customobjects.CustomObject;
import com.khorn.terraincontrol.customobjects.CustomObjectCollection;
import com.khorn.terraincontrol.customobjects.CustomObjectLoader;
import com.khorn.terraincontrol.customobjects.TreeObject;
import com.khorn.terraincontrol.customobjects.UseBiome;
import com.khorn.terraincontrol.customobjects.UseBiomeAll;
import com.khorn.terraincontrol.customobjects.UseWorld;
import com.khorn.terraincontrol.customobjects.UseWorldAll;
import com.khorn.terraincontrol.customobjects.bo2.BO2Loader;
import com.khorn.terraincontrol.customobjects.bo3.BO3Loader;
import com.khorn.terraincontrol.logging.LogMarker;
import com.khorn.terraincontrol.util.minecraftTypes.TreeType;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class CustomObjectManager {
    private final Map<String, CustomObjectLoader> loaders = new HashMap<String, CustomObjectLoader>();
    private final CustomObjectCollection globalCustomObjects;

    public CustomObjectManager() {
        this.registerCustomObjectLoader("bo2", new BO2Loader());
        this.registerCustomObjectLoader("bo3", new BO3Loader());
        this.globalCustomObjects = new CustomObjectCollection();
        for (TreeType type : TreeType.values()) {
            this.registerGlobalObject(new TreeObject(type));
        }
        this.registerGlobalObject(new UseWorld());
        this.registerGlobalObject(new UseBiome());
        this.registerGlobalObject(new UseWorldAll());
        this.registerGlobalObject(new UseBiomeAll());
    }

    public void loadGlobalObjects() {
        this.globalCustomObjects.load(this.loaders, TerrainControl.getEngine().getGlobalObjectsDirectory());
        TerrainControl.log(LogMarker.INFO, "{} Global custom objects loaded", this.globalCustomObjects.getAll().size());
    }

    public void registerCustomObjectLoader(String extension, CustomObjectLoader loader) {
        this.loaders.put(extension.toLowerCase(), loader);
    }

    public void registerGlobalObject(CustomObject object) {
        this.globalCustomObjects.addLoadedObject(object);
    }

    public CustomObjectCollection getGlobalObjects() {
        return this.globalCustomObjects;
    }

    public Map<String, CustomObjectLoader> getObjectLoaders() {
        return Collections.unmodifiableMap(this.loaders);
    }

    public void shutdown() {
        for (CustomObjectLoader loader : this.loaders.values()) {
            loader.onShutdown();
        }
        this.loaders.clear();
    }
}

