/*
 * Decompiled with CFR 0.152.
 */
package com.khorn.terraincontrol.customobjects;

import com.khorn.terraincontrol.LocalBiome;
import com.khorn.terraincontrol.LocalWorld;
import com.khorn.terraincontrol.configuration.io.SettingsReader;
import com.khorn.terraincontrol.configuration.settingType.Setting;
import com.khorn.terraincontrol.configuration.settingType.Settings;
import com.khorn.terraincontrol.customobjects.CustomObject;
import com.khorn.terraincontrol.util.ChunkCoordinate;
import com.khorn.terraincontrol.util.Rotation;
import com.khorn.terraincontrol.util.minecraftTypes.TreeType;
import java.util.Map;
import java.util.Random;

public class TreeObject
implements CustomObject {
    private TreeType type;
    private int minHeight = 0;
    private int maxHeight = 256;

    public TreeObject(TreeType type) {
        this.type = type;
    }

    @Override
    public void onEnable(Map<String, CustomObject> otherObjectsInDirectory) {
    }

    public TreeObject(TreeType type, SettingsReader settings) {
        this.type = type;
        this.minHeight = settings.getSetting(TreeSettings.MIN_HEIGHT, TreeSettings.MIN_HEIGHT.getDefaultValue());
        this.maxHeight = settings.getSetting(TreeSettings.MAX_HEIGHT, TreeSettings.MAX_HEIGHT.getDefaultValue());
    }

    @Override
    public String getName() {
        return this.type.name();
    }

    @Override
    public boolean canSpawnAsTree() {
        return true;
    }

    @Override
    public boolean canSpawnAsObject() {
        return false;
    }

    @Override
    public boolean spawnForced(LocalWorld world, Random random, Rotation rotation, int x, int y, int z) {
        return world.PlaceTree(this.type, random, x, y, z);
    }

    @Override
    public boolean spawnAsTree(LocalWorld world, Random random, int x, int z) {
        int y = world.getHighestBlockYAt(x, z);
        if (y < this.minHeight || y > this.maxHeight) {
            return false;
        }
        return world.PlaceTree(this.type, random, x, y, z);
    }

    @Override
    public boolean process(LocalWorld world, Random random, ChunkCoordinate chunkCoord) {
        int x = chunkCoord.getBlockXCenter() + random.nextInt(16);
        int z = chunkCoord.getBlockZCenter() + random.nextInt(16);
        return this.spawnAsTree(world, random, x, z);
    }

    @Override
    public CustomObject applySettings(SettingsReader settings) {
        return new TreeObject(this.type, settings);
    }

    @Override
    public boolean hasPreferenceToSpawnIn(LocalBiome biome) {
        return true;
    }

    @Override
    public boolean canSpawnAt(LocalWorld world, Rotation rotation, int x, int y, int z) {
        return true;
    }

    @Override
    public boolean canRotateRandomly() {
        return false;
    }

    private static class TreeSettings
    extends Settings {
        static final Setting<Integer> MIN_HEIGHT = TreeSettings.intSetting("MinHeight", 0, 0, 256);
        static final Setting<Integer> MAX_HEIGHT = TreeSettings.intSetting("MaxHeight", 256, 0, 256);

        private TreeSettings() {
        }
    }
}

