/*
 * Decompiled with CFR 0.152.
 */
package com.khorn.terraincontrol.customobjects;

import com.khorn.terraincontrol.LocalBiome;
import com.khorn.terraincontrol.LocalWorld;
import com.khorn.terraincontrol.configuration.io.SettingsReader;
import com.khorn.terraincontrol.customobjects.CustomObject;
import com.khorn.terraincontrol.util.ChunkCoordinate;
import com.khorn.terraincontrol.util.Rotation;
import java.util.List;
import java.util.Map;
import java.util.Random;

public class UseBiome
implements CustomObject {
    public List<CustomObject> getPossibleObjectsAt(LocalWorld world, int x, int z) {
        return world.getBiome((int)x, (int)z).getBiomeConfig().biomeObjects;
    }

    @Override
    public void onEnable(Map<String, CustomObject> otherObjectsInDirectory) {
    }

    @Override
    public String getName() {
        return "UseBiome";
    }

    @Override
    public boolean canSpawnAsTree() {
        return true;
    }

    @Override
    public boolean canSpawnAsObject() {
        return true;
    }

    @Override
    public boolean spawnForced(LocalWorld world, Random random, Rotation rotation, int x, int y, int z) {
        for (CustomObject object : this.getPossibleObjectsAt(world, x, z)) {
            if (!object.spawnForced(world, random, rotation, x, y, z)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean spawnAsTree(LocalWorld world, Random random, int x, int z) {
        List<CustomObject> possibleObjects = this.getPossibleObjectsAt(world, x, z);
        int objectSpawnRatio = world.getConfigs().getWorldConfig().objectSpawnRatio;
        if (possibleObjects.isEmpty()) {
            return false;
        }
        boolean objectSpawned = false;
        int spawnattemps = 0;
        while (!objectSpawned) {
            if (spawnattemps > objectSpawnRatio) {
                return false;
            }
            ++spawnattemps;
            CustomObject selectedObject = possibleObjects.get(random.nextInt(possibleObjects.size()));
            objectSpawned = selectedObject.spawnAsTree(world, random, x, x);
        }
        return objectSpawned;
    }

    @Override
    public boolean process(LocalWorld world, Random random, ChunkCoordinate chunkCoord) {
        List<CustomObject> possibleObjects = this.getPossibleObjectsAt(world, chunkCoord.getBlockXCenter(), chunkCoord.getBlockZCenter());
        int objectSpawnRatio = world.getConfigs().getWorldConfig().objectSpawnRatio;
        if (possibleObjects.isEmpty()) {
            return false;
        }
        boolean objectSpawned = false;
        int spawnattemps = 0;
        while (!objectSpawned) {
            if (spawnattemps > objectSpawnRatio) {
                return false;
            }
            ++spawnattemps;
            CustomObject selectedObject = possibleObjects.get(random.nextInt(possibleObjects.size()));
            objectSpawned = selectedObject.process(world, random, chunkCoord);
        }
        return objectSpawned;
    }

    @Override
    public CustomObject applySettings(SettingsReader settings) {
        return this;
    }

    @Override
    public boolean hasPreferenceToSpawnIn(LocalBiome biome) {
        return false;
    }

    @Override
    public boolean canSpawnAt(LocalWorld world, Rotation rotation, int x, int y, int z) {
        List<CustomObject> objects = this.getPossibleObjectsAt(world, x, z);
        if (objects.isEmpty()) {
            return false;
        }
        for (CustomObject object : objects) {
            if (object.canSpawnAt(world, rotation, x, y, z)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean canRotateRandomly() {
        return true;
    }
}

