/*
 * Decompiled with CFR 0.152.
 */
package com.khorn.terraincontrol.customobjects.bo3;

import com.khorn.terraincontrol.LocalBiome;
import com.khorn.terraincontrol.LocalWorld;
import com.khorn.terraincontrol.TerrainControl;
import com.khorn.terraincontrol.configuration.io.FileSettingsReader;
import com.khorn.terraincontrol.configuration.io.FileSettingsWriter;
import com.khorn.terraincontrol.configuration.io.SettingsReader;
import com.khorn.terraincontrol.customobjects.Branch;
import com.khorn.terraincontrol.customobjects.CustomObject;
import com.khorn.terraincontrol.customobjects.CustomObjectCoordinate;
import com.khorn.terraincontrol.customobjects.ObjectExtrusionHelper;
import com.khorn.terraincontrol.customobjects.StructurePartSpawnHeight;
import com.khorn.terraincontrol.customobjects.StructuredCustomObject;
import com.khorn.terraincontrol.customobjects.bo3.BO3Check;
import com.khorn.terraincontrol.customobjects.bo3.BO3Config;
import com.khorn.terraincontrol.customobjects.bo3.BO3Settings;
import com.khorn.terraincontrol.customobjects.bo3.BlockFunction;
import com.khorn.terraincontrol.util.BoundingBox;
import com.khorn.terraincontrol.util.ChunkCoordinate;
import com.khorn.terraincontrol.util.Rotation;
import com.khorn.terraincontrol.util.helpers.MathHelper;
import java.io.File;
import java.util.Map;
import java.util.Random;

public class BO3
implements StructuredCustomObject {
    private BO3Config settings;
    private final String name;
    private final File file;
    static int i = 0;

    public BO3(String name, File file) {
        this.name = name;
        this.file = file;
    }

    @Override
    public void onEnable(Map<String, CustomObject> otherObjectsInDirectory) {
        this.settings = new BO3Config(new FileSettingsReader(this.name, this.file), otherObjectsInDirectory);
    }

    public BO3(BO3 oldObject, SettingsReader extraSettings) {
        this.settings = new BO3Config(extraSettings, oldObject.settings.otherObjectsInDirectory);
        FileSettingsWriter.writeToFile(this.settings, this.settings.settingsMode);
        this.name = this.settings.getName();
        this.file = this.settings.getFile();
    }

    public int getOffsetAndVariance(Random random, int offset, int variance) {
        if (variance == 0) {
            return offset;
        }
        variance = variance < 0 ? -random.nextInt(MathHelper.abs(variance) + 1) : random.nextInt(variance + 1);
        return MathHelper.clamp(offset + variance, 0, 256);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public BO3Config getSettings() {
        return this.settings;
    }

    @Override
    public boolean canSpawnAsTree() {
        return this.settings.tree;
    }

    @Override
    public boolean canSpawnAsObject() {
        return true;
    }

    @Override
    public boolean canSpawnAt(LocalWorld world, Rotation rotation, int x, int y, int z) {
        BlockFunction[] blocks = this.settings.blocks[rotation.getRotationId()];
        BO3Check[] checks = this.settings.bo3Checks[rotation.getRotationId()];
        if (y < this.settings.minHeight || y > this.settings.maxHeight) {
            return false;
        }
        for (BO3Check check : checks) {
            if (!check.preventsSpawn(world, x + check.x, y + check.y, z + check.z)) continue;
            return false;
        }
        int blocksOutsideSourceBlock = 0;
        for (BlockFunction block : blocks) {
            if (!world.isLoaded(x + block.x, y + block.y, z + block.z)) {
                return false;
            }
            if (this.settings.sourceBlocks.contains(world.getMaterial(x + block.x, y + block.y, z + block.z))) continue;
            ++blocksOutsideSourceBlock;
        }
        if ((double)blocksOutsideSourceBlock / (double)blocks.length * 100.0 > (double)this.settings.maxPercentageOutsideSourceBlock) {
            return false;
        }
        return TerrainControl.fireCanCustomObjectSpawnEvent(this, world, x, y, z);
    }

    @Override
    public boolean canRotateRandomly() {
        return this.settings.rotateRandomly;
    }

    @Override
    public boolean spawnForced(LocalWorld world, Random random, Rotation rotation, int x, int y, int z) {
        BlockFunction[] blocks = this.settings.blocks[rotation.getRotationId()];
        ObjectExtrusionHelper oeh = new ObjectExtrusionHelper(this.settings.extrudeMode, this.settings.extrudeThroughBlocks);
        for (BlockFunction block : blocks) {
            if (this.settings.outsideSourceBlock == BO3Settings.OutsideSourceBlock.placeAnyway || this.settings.sourceBlocks.contains(world.getMaterial(x + block.x, y + block.y, z + block.z))) {
                block.spawn(world, random, x + block.x, y + block.y, z + block.z);
            }
            oeh.addBlock(block);
        }
        oeh.extrude(world, random, x, y, z);
        return true;
    }

    protected boolean spawn(LocalWorld world, Random random, int x, int z) {
        Rotation rotation = this.settings.rotateRandomly ? Rotation.getRandomRotation(random) : Rotation.NORTH;
        int y = 0;
        if (this.settings.spawnHeight == BO3Settings.SpawnHeightEnum.randomY) {
            y = MathHelper.getRandomNumberInRange(random, this.settings.minHeight, this.settings.maxHeight);
        }
        if (this.settings.spawnHeight == BO3Settings.SpawnHeightEnum.highestBlock) {
            y = world.getHighestBlockYAt(x, z);
        }
        if (this.settings.spawnHeight == BO3Settings.SpawnHeightEnum.highestSolidBlock) {
            y = world.getSolidHeight(x, z);
        }
        if (!this.canSpawnAt(world, rotation, x, y += this.getOffsetAndVariance(random, this.settings.spawnHeightOffset, this.settings.spawnHeightVariance), z)) {
            return false;
        }
        boolean success = this.spawnForced(world, random, rotation, x, y, z);
        return success;
    }

    @Override
    public boolean spawnAsTree(LocalWorld world, Random random, int x, int z) {
        if (this.settings.tree) {
            return this.spawn(world, random, x, z);
        }
        return false;
    }

    @Override
    public boolean process(LocalWorld world, Random random, ChunkCoordinate chunkCoord) {
        boolean atLeastOneObjectHasSpawned = false;
        int chunkMiddleX = chunkCoord.getBlockXCenter();
        int chunkMiddleZ = chunkCoord.getBlockZCenter();
        for (int i = 0; i < this.settings.frequency; ++i) {
            if (!(this.settings.rarity > random.nextDouble() * 100.0) || !this.spawn(world, random, chunkMiddleX + random.nextInt(16), chunkMiddleZ + random.nextInt(16))) continue;
            atLeastOneObjectHasSpawned = true;
        }
        return atLeastOneObjectHasSpawned;
    }

    @Override
    public CustomObject applySettings(SettingsReader extraSettings) {
        extraSettings.setFallbackReader(this.settings.getReader());
        return new BO3(this, extraSettings);
    }

    @Override
    public boolean hasPreferenceToSpawnIn(LocalBiome biome) {
        return !this.settings.excludedBiomes.contains("All") && !this.settings.excludedBiomes.contains("all") && !this.settings.excludedBiomes.contains(biome.getName());
    }

    @Override
    public boolean hasBranches() {
        return this.settings.branches[0].length != 0;
    }

    @Override
    public Branch[] getBranches(Rotation rotation) {
        return this.settings.branches[rotation.getRotationId()];
    }

    @Override
    public CustomObjectCoordinate makeCustomObjectCoordinate(Random random, int chunkX, int chunkZ) {
        if (this.settings.rarity > random.nextDouble() * 100.0) {
            Rotation rotation = this.settings.rotateRandomly ? Rotation.getRandomRotation(random) : Rotation.NORTH;
            int height = MathHelper.getRandomNumberInRange(random, this.settings.minHeight, this.settings.maxHeight);
            return new CustomObjectCoordinate(this, rotation, chunkX * 16 + 8 + random.nextInt(16), height, chunkZ * 16 + 8 + random.nextInt(16));
        }
        return null;
    }

    @Override
    public int getMaxBranchDepth() {
        return this.settings.maxBranchDepth;
    }

    @Override
    public StructurePartSpawnHeight getStructurePartSpawnHeight() {
        return this.settings.spawnHeight.toStructurePartSpawnHeight();
    }

    @Override
    public BoundingBox getBoundingBox(Rotation rotation) {
        return this.settings.boundingBoxes[rotation.getRotationId()];
    }
}

