/*
 * Decompiled with CFR 0.152.
 */
package com.khorn.terraincontrol.customobjects.bo3;

import com.khorn.terraincontrol.LocalWorld;
import com.khorn.terraincontrol.customobjects.bo3.BO3Check;
import com.khorn.terraincontrol.exception.InvalidConfigException;
import com.khorn.terraincontrol.util.MaterialSet;
import java.util.List;

public class BlockCheck
extends BO3Check {
    public MaterialSet toCheck;

    @Override
    public boolean preventsSpawn(LocalWorld world, int x, int y, int z) {
        return !this.toCheck.contains(world.getMaterial(x, y, z));
    }

    @Override
    public void load(List<String> args) throws InvalidConfigException {
        this.assureSize(4, args);
        this.x = this.readInt(args.get(0), -100, 100);
        this.y = this.readInt(args.get(1), -100, 100);
        this.z = this.readInt(args.get(2), -100, 100);
        this.toCheck = this.readMaterials(args, 3);
    }

    @Override
    public String makeString() {
        return this.makeString("BlockCheck");
    }

    protected String makeString(String name) {
        return name + '(' + this.x + ',' + this.y + ',' + this.z + this.makeMaterials(this.toCheck) + ')';
    }

    @Override
    public BO3Check rotate() {
        BlockCheck rotatedCheck = new BlockCheck();
        rotatedCheck.x = this.z;
        rotatedCheck.y = this.y;
        rotatedCheck.z = -this.x;
        rotatedCheck.toCheck = this.toCheck.rotate();
        return rotatedCheck;
    }
}

