/*
 * Decompiled with CFR 0.152.
 */
package com.khorn.terraincontrol.forge;

import com.khorn.terraincontrol.LocalMaterialData;
import com.khorn.terraincontrol.LocalWorld;
import com.khorn.terraincontrol.TerrainControl;
import com.khorn.terraincontrol.TerrainControlEngine;
import com.khorn.terraincontrol.exception.InvalidConfigException;
import com.khorn.terraincontrol.forge.ForgeMaterialData;
import com.khorn.terraincontrol.forge.ForgeWorld;
import com.khorn.terraincontrol.forge.TCWorldType;
import com.khorn.terraincontrol.logging.LogMarker;
import com.khorn.terraincontrol.util.minecraftTypes.DefaultMaterial;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Loader;
import java.io.File;
import java.lang.reflect.Field;
import net.minecraft.block.Block;

public class ForgeEngine
extends TerrainControlEngine {
    protected TCWorldType worldType;

    public ForgeEngine(TCWorldType worldType) {
        super(FMLCommonHandler.instance().getFMLLogger());
        this.worldType = worldType;
    }

    @Override
    public LocalWorld getWorld(String name) {
        ForgeWorld world = this.worldType.worldTC;
        if (world == null) {
            return null;
        }
        if (world.getName().equals(name)) {
            return world;
        }
        return null;
    }

    public LocalWorld getWorld() {
        return this.worldType.worldTC;
    }

    @Override
    public File getTCDataFolder() {
        File dataFolder;
        try {
            Field minecraftDir = Loader.class.getDeclaredField("minecraftDir");
            minecraftDir.setAccessible(true);
            dataFolder = new File((File)minecraftDir.get(null), "mods" + File.separator + "TerrainControl");
        }
        catch (Throwable e) {
            dataFolder = new File("mods" + File.separator + "TerrainControl");
            System.out.println("Could not reflect the Minecraft directory, save location may be unpredicatble.");
            TerrainControl.printStackTrace(LogMarker.FATAL, e);
        }
        return dataFolder;
    }

    @Override
    public File getGlobalObjectsDirectory() {
        return new File(this.getTCDataFolder(), "GlobalObjects");
    }

    @Override
    public LocalMaterialData readMaterial(String input) throws InvalidConfigException {
        Block block = Block.func_149684_b((String)input);
        if (block != null) {
            return ForgeMaterialData.ofMinecraftBlock(block, 0);
        }
        try {
            return this.getMaterial0(input);
        }
        catch (NumberFormatException e) {
            throw new InvalidConfigException("Unknown material: " + input);
        }
    }

    private LocalMaterialData getMaterial0(String input) throws NumberFormatException, InvalidConfigException {
        Block block;
        String blockName = input;
        int blockData = 0;
        int splitIndex = input.lastIndexOf(":");
        if (splitIndex == -1) {
            splitIndex = input.lastIndexOf(".");
        }
        if (splitIndex != -1) {
            blockName = input.substring(0, splitIndex);
            blockData = Integer.parseInt(input.substring(splitIndex + 1));
        }
        if ((block = Block.func_149684_b((String)blockName)) != null) {
            return ForgeMaterialData.ofMinecraftBlock(block, blockData);
        }
        DefaultMaterial defaultMaterial = DefaultMaterial.getMaterial(blockName);
        if (defaultMaterial != DefaultMaterial.UNKNOWN_BLOCK) {
            return ForgeMaterialData.ofDefaultMaterial(defaultMaterial, blockData);
        }
        throw new InvalidConfigException("Unknown material: " + input);
    }

    @Override
    public LocalMaterialData toLocalMaterialData(DefaultMaterial defaultMaterial, int blockData) {
        return ForgeMaterialData.ofDefaultMaterial(defaultMaterial, blockData);
    }
}

