/*
 * Decompiled with CFR 0.152.
 */
package com.khorn.terraincontrol.forge.events;

import com.khorn.terraincontrol.LocalWorld;
import com.khorn.terraincontrol.TerrainControl;
import com.khorn.terraincontrol.configuration.ConfigFile;
import com.khorn.terraincontrol.configuration.WorldSettings;
import com.khorn.terraincontrol.forge.ForgeWorld;
import com.khorn.terraincontrol.logging.LogMarker;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.FMLNetworkEvent;
import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import java.io.DataInputStream;
import java.io.InputStream;
import java.util.Arrays;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatStyle;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;

public class PacketHandler {
    @SubscribeEvent
    public void onServerPacket(FMLNetworkEvent.ServerCustomPacketEvent event) {
    }

    @SubscribeEvent
    public void onClientPacket(FMLNetworkEvent.ClientCustomPacketEvent event) {
        FMLProxyPacket receivedPacket = event.packet;
        ByteBuf stream = receivedPacket.payload();
        try {
            int serverProtocolVersion = stream.readInt();
            int clientProtocolVersion = 5;
            if (serverProtocolVersion == clientProtocolVersion) {
                ForgeWorld.restoreBiomes();
                if (stream.readableBytes() > 4) {
                    WorldClient worldMC = FMLClientHandler.instance().getClient().field_71441_e;
                    DataInputStream wrappedStream = new DataInputStream((InputStream)new ByteBufInputStream(stream));
                    String worldName = ConfigFile.readStringFromStream(wrappedStream);
                    ForgeWorld worldTC = new ForgeWorld(worldName);
                    WorldSettings config = new WorldSettings(wrappedStream, (LocalWorld)worldTC);
                    wrappedStream.close();
                    if (worldMC != null) {
                        worldTC.InitM((World)worldMC, config);
                    } else {
                        TerrainControl.log(LogMarker.INFO, "Config received but world is null, ignoring.", new Object[0]);
                        TerrainControl.log(LogMarker.INFO, "Packet contents: {}", Arrays.toString(stream.array()));
                    }
                }
                TerrainControl.log(LogMarker.INFO, "Config received from server", new Object[0]);
            } else {
                if (serverProtocolVersion > 5) {
                    this.sendMessage(EnumChatFormatting.GREEN, "The server is running a newer version of Terrain Control. Please update!");
                } else {
                    this.sendMessage(EnumChatFormatting.YELLOW, "The server is running an outdated version of Terrain Control. Cannot load custom biome colors and weather.");
                }
                TerrainControl.log(LogMarker.WARN, "Server has different protocol version. Client: {} Server: {}", 5, serverProtocolVersion);
            }
        }
        catch (Exception e) {
            TerrainControl.log(LogMarker.FATAL, "Failed to receive packet", new Object[0]);
            TerrainControl.printStackTrace(LogMarker.FATAL, e);
            TerrainControl.log(LogMarker.FATAL, "Packet contents: {}", Arrays.toString(stream.array()));
            this.sendMessage(EnumChatFormatting.RED, "Error receiving packet.");
        }
    }

    private void sendMessage(EnumChatFormatting color, String message) {
        ChatComponentText chat = new ChatComponentText("Terrain Control: " + message);
        ChatStyle chatStyle = new ChatStyle();
        chatStyle.func_150238_a(color);
        chat.func_150255_a(chatStyle);
        Minecraft.func_71410_x().field_71439_g.func_145747_a((IChatComponent)chat);
    }
}

