/*
 * Decompiled with CFR 0.152.
 */
package com.khorn.terraincontrol.forge.events;

import com.khorn.terraincontrol.LocalWorld;
import com.khorn.terraincontrol.TerrainControl;
import com.khorn.terraincontrol.configuration.ConfigProvider;
import com.khorn.terraincontrol.forge.util.WorldHelper;
import com.khorn.terraincontrol.logging.LogMarker;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.Unpooled;
import java.io.DataOutput;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.Packet;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.server.S3FPacketCustomPayload;

public class PlayerTracker {
    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        if (!(event.player instanceof EntityPlayerMP)) {
            return;
        }
        EntityPlayerMP player = (EntityPlayerMP)event.player;
        LocalWorld worldTC = WorldHelper.toLocalWorld(player.func_130014_f_());
        if (worldTC == null) {
            return;
        }
        ConfigProvider configs = worldTC.getConfigs();
        ByteBuf nettyBuffer = Unpooled.buffer();
        PacketBuffer mojangBuffer = new PacketBuffer(nettyBuffer);
        ByteBufOutputStream stream = new ByteBufOutputStream(nettyBuffer);
        try {
            stream.writeInt(5);
            configs.writeToStream((DataOutput)stream);
        }
        catch (IOException e) {
            TerrainControl.printStackTrace(LogMarker.FATAL, e);
        }
        S3FPacketCustomPayload packet = new S3FPacketCustomPayload("TerrainControl", (ByteBuf)mojangBuffer);
        player.field_71135_a.func_147359_a((Packet)packet);
    }
}

