/*
 * Decompiled with CFR 0.152.
 */
package com.khorn.terraincontrol.forge.events;

import com.khorn.terraincontrol.TerrainControl;
import com.khorn.terraincontrol.configuration.WorldConfig;
import com.khorn.terraincontrol.configuration.io.FileSettingsReader;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiCreateWorld;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiSelectWorld;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.GuiYesNo;
import net.minecraft.client.gui.GuiYesNoCallback;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ChatAllowedCharacters;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.WorldType;
import net.minecraft.world.storage.ISaveFormat;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.client.event.GuiOpenEvent;
import org.lwjgl.input.Keyboard;

public class WorldCreationMenuHandler
implements IGuiHandler {
    boolean selecting;

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void openGui(GuiOpenEvent event) {
        if (event.gui instanceof GuiCreateWorld && !this.selecting) {
            event.gui = new GuiSelectCreateWorldMode();
        }
        if (event.gui instanceof GuiSelectWorld) {
            event.gui = new MCWGuiSelectWorld((GuiScreen)new GuiMainMenu());
        }
        this.selecting = false;
    }

    public void registerKeybindings() {
    }

    public Object getServerGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return null;
    }

    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return null;
    }

    public static void deleteRecursive(File folder) {
        File[] files = folder.listFiles();
        if (files != null) {
            for (File f : files) {
                if (f.isDirectory()) {
                    WorldCreationMenuHandler.deleteRecursive(f);
                    continue;
                }
                f.delete();
            }
        }
        folder.delete();
    }

    @SideOnly(value=Side.CLIENT)
    public class MCWGuiCreateWorld
    extends GuiScreen
    implements GuiYesNoCallback {
        private GuiScreen sender;
        private GuiTextField txtWorldName;
        private GuiTextField txtSeed;
        private GuiButton btnavailableWorld1;
        private GuiButton btnavailableWorld2;
        private GuiButton btnavailableWorld3;
        private GuiButton btnavailableWorldPrev;
        private GuiButton btnavailableWorldNext;
        private GuiButton btnavailableWorldDelete1;
        private GuiButton btnavailableWorldDelete2;
        private GuiButton btnavailableWorldDelete3;
        private GuiButton btnCreateWorld;
        private String worldName;
        private boolean bBtnCreateNewWorldClicked;
        private String seed;
        private String worldName2;
        private final String[] field_146327_L = new String[]{"CON", "COM", "PRN", "AUX", "CLOCK$", "NUL", "COM1", "COM2", "COM3", "COM4", "COM5", "COM6", "COM7", "COM8", "COM9", "LPT1", "LPT2", "LPT3", "LPT4", "LPT5", "LPT6", "LPT7", "LPT8", "LPT9"};
        private final String __OBFID = "CL_00000689";
        private GuiButton btnBonusChest;
        private boolean bonusChest;
        private GuiButton btnGameMode;
        private int gameMode = 1;
        int yoffset = 10;
        HashMap<String, WorldConfig> worlds = new HashMap();
        String selectedWorldName = null;
        WorldConfig selectedWorldConfig = null;
        int pageNumber = 0;
        String worldNameHelpText;
        String worldNameHelpText2;
        String worldNameToDelete = "";

        public MCWGuiCreateWorld(GuiScreen sender) {
            this.sender = sender;
            this.seed = "";
            this.worldName2 = I18n.func_135052_a((String)"selectWorld.newWorld", (Object[])new Object[0]);
        }

        public void func_73876_c() {
            this.txtWorldName.func_146178_a();
            this.txtSeed.func_146178_a();
        }

        public void func_73866_w_() {
            Keyboard.enableRepeatEvents((boolean)true);
            this.field_146292_n.clear();
            this.txtWorldName = new GuiTextField(this.field_146289_q, this.field_146294_l / 2 - 155, this.yoffset + 57, 160, 20);
            this.txtWorldName.func_146195_b(true);
            this.txtWorldName.func_146180_a(this.worldName2);
            this.txtSeed = new GuiTextField(this.field_146289_q, this.field_146294_l / 2 - 155, this.yoffset + 115, 160, 20);
            this.txtSeed.func_146180_a(this.seed);
            int btnwidth = 136;
            this.btnavailableWorld1 = new GuiButton(3, this.field_146294_l / 2 + 15, this.yoffset + 55, btnwidth, 20, "None");
            this.btnavailableWorld2 = new GuiButton(4, this.field_146294_l / 2 + 15, this.yoffset + 55 + 24, btnwidth, 20, "None");
            this.btnavailableWorld3 = new GuiButton(5, this.field_146294_l / 2 + 15, this.yoffset + 55 + 48, btnwidth, 20, "None");
            this.btnavailableWorldPrev = new GuiButton(6, this.field_146294_l / 2 + 15, this.yoffset + 55 + 72, 78, 20, "Previous");
            this.btnavailableWorldNext = new GuiButton(7, this.field_146294_l / 2 + 15 + 82, this.yoffset + 55 + 72, 78, 20, "Next");
            this.btnavailableWorldDelete1 = new GuiButton(8, this.field_146294_l / 2 + 15 + btnwidth + 4, this.yoffset + 55, 20, 20, "X");
            this.btnavailableWorldDelete2 = new GuiButton(9, this.field_146294_l / 2 + 15 + btnwidth + 4, this.yoffset + 55 + 24, 20, 20, "X");
            this.btnavailableWorldDelete3 = new GuiButton(10, this.field_146294_l / 2 + 15 + btnwidth + 4, this.yoffset + 55 + 48, 20, 20, "X");
            this.field_146292_n.add(this.btnavailableWorld1);
            this.field_146292_n.add(this.btnavailableWorld2);
            this.field_146292_n.add(this.btnavailableWorld3);
            this.field_146292_n.add(this.btnavailableWorldPrev);
            this.field_146292_n.add(this.btnavailableWorldNext);
            this.field_146292_n.add(this.btnavailableWorldDelete1);
            this.field_146292_n.add(this.btnavailableWorldDelete2);
            this.field_146292_n.add(this.btnavailableWorldDelete3);
            this.FillAvailableWorlds();
            this.btnBonusChest = new GuiButton(11, this.field_146294_l / 2 - 155, this.yoffset + 161, 160, 20, I18n.func_135052_a((String)"selectWorld.bonusItems", (Object[])new Object[0]));
            this.field_146292_n.add(this.btnBonusChest);
            this.btnBonusChest.field_146126_j = I18n.func_135052_a((String)"selectWorld.bonusItems", (Object[])new Object[0]) + " ";
            this.btnBonusChest.field_146126_j = this.bonusChest ? I18n.func_135052_a((String)"selectWorld.bonusItems", (Object[])new Object[0]) + " " + I18n.func_135052_a((String)"options.on", (Object[])new Object[0]) : I18n.func_135052_a((String)"selectWorld.bonusItems", (Object[])new Object[0]) + " " + I18n.func_135052_a((String)"options.off", (Object[])new Object[0]);
            this.btnGameMode = new GuiButton(12, this.field_146294_l / 2 + 15, this.yoffset + 161, 160, 20, I18n.func_135052_a((String)(this.gameMode == 0 ? "Creative" : (this.gameMode == 1 ? "Survival" : (this.gameMode == 2 ? "Adventure" : "Creative"))), (Object[])new Object[0]));
            this.field_146292_n.add(this.btnGameMode);
            this.btnCreateWorld = new GuiButton(0, this.field_146294_l / 2 - 155, this.field_146295_m - 38, 160, 20, I18n.func_135052_a((String)"selectWorld.create", (Object[])new Object[0]));
            this.field_146292_n.add(this.btnCreateWorld);
            this.field_146292_n.add(new GuiButton(1, this.field_146294_l / 2 + 15, this.field_146295_m - 38, 160, 20, I18n.func_135052_a((String)"gui.cancel", (Object[])new Object[0])));
            this.updateWorldName(true);
        }

        private void FillAvailableWorlds() {
            int pages;
            ArrayList<String> worldNames = new ArrayList<String>();
            File TCWorldsDirectory = new File(TerrainControl.getEngine().getTCDataFolder().getAbsolutePath() + "/worlds");
            if (TCWorldsDirectory.exists() && TCWorldsDirectory.isDirectory()) {
                for (File worldDir : TCWorldsDirectory.listFiles()) {
                    if (!worldDir.isDirectory()) continue;
                    worldNames.add(worldDir.getName());
                    if (this.worlds.containsKey(worldDir.getName())) continue;
                    File worldConfigFile = new File(worldDir, "WorldConfig.ini");
                    WorldConfig worldConfig = new WorldConfig(new FileSettingsReader(worldDir.getName(), worldConfigFile), null, null);
                    this.worlds.put(worldDir.getName(), worldConfig);
                }
            }
            if (this.pageNumber > (pages = (int)Math.ceil((double)worldNames.size() / 3.0)) - 1) {
                this.pageNumber = pages - 1;
            }
            int i = 0;
            this.btnavailableWorld1.field_146126_j = "None";
            this.btnavailableWorld2.field_146126_j = "None";
            this.btnavailableWorld3.field_146126_j = "None";
            for (String worldName : worldNames) {
                if (++i == this.pageNumber * 3 + 1) {
                    this.btnavailableWorld1.field_146126_j = worldName;
                }
                if (i == this.pageNumber * 3 + 2) {
                    this.btnavailableWorld2.field_146126_j = worldName;
                }
                if (i != this.pageNumber * 3 + 3) continue;
                this.btnavailableWorld3.field_146126_j = worldName;
            }
            this.btnavailableWorld1.field_146124_l = !this.btnavailableWorld1.field_146126_j.equals("None");
            this.btnavailableWorld2.field_146124_l = !this.btnavailableWorld2.field_146126_j.equals("None");
            this.btnavailableWorld3.field_146124_l = !this.btnavailableWorld3.field_146126_j.equals("None");
            this.btnavailableWorldDelete1.field_146124_l = !this.btnavailableWorld1.field_146126_j.equals("None");
            this.btnavailableWorldDelete2.field_146124_l = !this.btnavailableWorld2.field_146126_j.equals("None");
            boolean bl = this.btnavailableWorldDelete3.field_146124_l = !this.btnavailableWorld3.field_146126_j.equals("None");
            if (worldNames.size() > 3) {
                this.btnavailableWorldPrev.field_146124_l = true;
                this.btnavailableWorldNext.field_146124_l = true;
            } else {
                this.btnavailableWorldPrev.field_146124_l = false;
                this.btnavailableWorldNext.field_146124_l = false;
            }
            if (this.pageNumber == 0) {
                this.btnavailableWorldPrev.field_146124_l = false;
            }
            if (this.pageNumber == pages - 1) {
                this.btnavailableWorldNext.field_146124_l = false;
            }
        }

        private void previousPage() {
            --this.pageNumber;
            if (this.pageNumber < 0) {
                this.pageNumber = 0;
            }
            this.FillAvailableWorlds();
        }

        private void nextPage() {
            ++this.pageNumber;
            this.FillAvailableWorlds();
        }

        private void updateWorldName(boolean resetTextFields) {
            this.worldName = this.txtWorldName.func_146179_b().trim();
            boolean bl = this.btnCreateWorld.field_146124_l = this.txtWorldName.func_146179_b().length() > 0;
            if (this.worldName.length() == 0) {
                this.worldNameHelpText = "World name cannot be empty";
            } else {
                for (char c0 : ChatAllowedCharacters.field_71567_b) {
                    this.worldName = this.worldName.replace(c0, '_');
                }
                this.worldName = this.getCorrectWorldName(this.field_146297_k.func_71359_d(), this.worldName);
                boolean WorldNameExists = false;
                this.worldNameHelpText = this.field_146297_k.func_71359_d().func_75803_c(this.worldName) != null ? "Existing world will be deleted!" : "New world dir will be created";
                ArrayList worldNames = new ArrayList();
                boolean usingPreset = false;
                this.selectedWorldName = null;
                this.selectedWorldConfig = null;
                File TCWorldsDirectory = new File(TerrainControl.getEngine().getTCDataFolder().getAbsolutePath() + "/worlds");
                if (TCWorldsDirectory.exists() && TCWorldsDirectory.isDirectory()) {
                    for (File worldDir : TCWorldsDirectory.listFiles()) {
                        if (!worldDir.isDirectory() || !this.worldName.equals(worldDir.getName())) continue;
                        this.selectedWorldName = worldDir.getName();
                        this.selectedWorldConfig = this.worlds.get(worldDir.getName());
                        usingPreset = true;
                        break;
                    }
                }
                if (usingPreset) {
                    this.worldNameHelpText2 = "Using existing settings";
                    if (resetTextFields) {
                        this.txtSeed.func_146180_a(this.selectedWorldConfig.worldSeed);
                        this.seed = this.selectedWorldConfig.worldSeed;
                    }
                } else {
                    this.worldNameHelpText2 = "Using default settings";
                    if (resetTextFields) {
                        this.txtSeed.func_146180_a("");
                        this.seed = "";
                    }
                }
            }
        }

        public String getCorrectWorldName(ISaveFormat anvilSaveConverter, String worldName) {
            worldName = worldName.replaceAll("[\\./\"]", "_");
            for (String s1 : this.field_146327_L) {
                if (!worldName.equalsIgnoreCase(s1)) continue;
                worldName = "_" + worldName + "_";
            }
            return worldName;
        }

        public void func_146281_b() {
            Keyboard.enableRepeatEvents((boolean)false);
        }

        protected void func_146284_a(GuiButton button) {
            if (button.field_146124_l) {
                GuiYesNo guiyesno;
                if (button.field_146127_k == 3) {
                    if (this.btnavailableWorld1.field_146126_j.length() > 0 && !this.btnavailableWorld1.field_146126_j.equalsIgnoreCase("none")) {
                        this.txtWorldName.func_146180_a(this.btnavailableWorld1.field_146126_j);
                    } else {
                        this.txtWorldName.func_146180_a("New World");
                    }
                    this.updateWorldName(true);
                }
                if (button.field_146127_k == 4) {
                    if (this.btnavailableWorld2.field_146126_j.length() > 0 && !this.btnavailableWorld2.field_146126_j.equalsIgnoreCase("none")) {
                        this.txtWorldName.func_146180_a(this.btnavailableWorld2.field_146126_j);
                    } else {
                        this.txtWorldName.func_146180_a("New World");
                    }
                    this.updateWorldName(true);
                }
                if (button.field_146127_k == 5) {
                    if (this.btnavailableWorld3.field_146126_j.length() > 0 && !this.btnavailableWorld3.field_146126_j.equalsIgnoreCase("none")) {
                        this.txtWorldName.func_146180_a(this.btnavailableWorld3.field_146126_j);
                    } else {
                        this.txtWorldName.func_146180_a("New World");
                    }
                    this.updateWorldName(true);
                }
                if (button.field_146127_k == 8 && this.btnavailableWorld1.field_146126_j.length() > 0 && !this.btnavailableWorld1.field_146126_j.equalsIgnoreCase("none")) {
                    guiyesno = this.askDeleteSettings(this, this.btnavailableWorld1.field_146126_j);
                    this.worldNameToDelete = this.btnavailableWorld1.field_146126_j.trim();
                    this.field_146297_k.func_147108_a((GuiScreen)guiyesno);
                }
                if (button.field_146127_k == 9 && this.btnavailableWorld2.field_146126_j.length() > 0 && !this.btnavailableWorld2.field_146126_j.equalsIgnoreCase("none")) {
                    guiyesno = this.askDeleteSettings(this, this.btnavailableWorld2.field_146126_j);
                    this.worldNameToDelete = this.btnavailableWorld2.field_146126_j.trim();
                    this.field_146297_k.func_147108_a((GuiScreen)guiyesno);
                }
                if (button.field_146127_k == 10 && this.btnavailableWorld3.field_146126_j.length() > 0 && !this.btnavailableWorld3.field_146126_j.equalsIgnoreCase("none")) {
                    guiyesno = this.askDeleteSettings(this, this.btnavailableWorld3.field_146126_j);
                    this.worldNameToDelete = this.btnavailableWorld3.field_146126_j.trim();
                    this.field_146297_k.func_147108_a((GuiScreen)guiyesno);
                }
                if (button.field_146127_k == 6) {
                    this.previousPage();
                }
                if (button.field_146127_k == 7) {
                    this.nextPage();
                }
                if (button.field_146127_k == 1) {
                    this.field_146297_k.func_147108_a(this.sender);
                } else if (button.field_146127_k == 0) {
                    if (this.bBtnCreateNewWorldClicked) {
                        return;
                    }
                    this.bBtnCreateNewWorldClicked = true;
                    long i = new Random().nextLong();
                    String s = this.txtSeed.func_146179_b().trim();
                    if (!MathHelper.func_76139_a((String)s)) {
                        try {
                            long j = Long.parseLong(s);
                            if (j != 0L) {
                                i = j;
                            }
                        }
                        catch (NumberFormatException numberformatexception) {
                            i = s.hashCode();
                        }
                    }
                    ISaveFormat isaveformat = this.field_146297_k.func_71359_d();
                    isaveformat.func_75800_d();
                    isaveformat.func_75802_e(this.worldName);
                    WorldType.func_77130_a((String)"TerrainControl").onGUICreateWorldPress();
                    WorldSettings.GameType gametype = this.gameMode == 0 ? WorldSettings.GameType.CREATIVE : (this.gameMode == 1 ? WorldSettings.GameType.SURVIVAL : (this.gameMode == 2 ? WorldSettings.GameType.ADVENTURE : WorldSettings.GameType.CREATIVE));
                    WorldSettings worldsettings = new WorldSettings(i, gametype, true, false, WorldType.func_77130_a((String)"TerrainControl"));
                    worldsettings.func_82750_a("TerrainControl");
                    if (this.bonusChest) {
                        worldsettings.func_77159_a();
                    }
                    worldsettings.func_77166_b();
                    File TCWorldsDirectory = new File(TerrainControl.getEngine().getTCDataFolder().getAbsolutePath() + "/worlds");
                    if (TCWorldsDirectory.exists() && TCWorldsDirectory.isDirectory()) {
                        for (File worldDir : TCWorldsDirectory.listFiles()) {
                            File pregeneratedChunksFile;
                            File chunkProviderPopulatedChunksFile;
                            File spawnedStructuresFile;
                            File nullChunksFile;
                            File structureDataFile;
                            if (!worldDir.isDirectory() || !this.worldName.equals(worldDir.getName())) continue;
                            File StructureDataDirectory = new File(worldDir.getAbsolutePath() + "/StructureData");
                            if (StructureDataDirectory.exists()) {
                                WorldCreationMenuHandler.deleteRecursive(StructureDataDirectory);
                            }
                            if ((structureDataFile = new File(worldDir.getAbsolutePath() + "/StructureData.txt")).exists()) {
                                WorldCreationMenuHandler.deleteRecursive(structureDataFile);
                            }
                            if ((nullChunksFile = new File(worldDir.getAbsolutePath() + "/NullChunks.txt")).exists()) {
                                WorldCreationMenuHandler.deleteRecursive(nullChunksFile);
                            }
                            if ((spawnedStructuresFile = new File(worldDir.getAbsolutePath() + "/SpawnedStructures.txt")).exists()) {
                                WorldCreationMenuHandler.deleteRecursive(spawnedStructuresFile);
                            }
                            if ((chunkProviderPopulatedChunksFile = new File(worldDir.getAbsolutePath() + "/ChunkProviderPopulatedChunks.txt")).exists()) {
                                WorldCreationMenuHandler.deleteRecursive(chunkProviderPopulatedChunksFile);
                            }
                            if (!(pregeneratedChunksFile = new File(worldDir.getAbsolutePath() + "/PregeneratedChunks.txt")).exists()) break;
                            WorldCreationMenuHandler.deleteRecursive(pregeneratedChunksFile);
                            break;
                        }
                    }
                    this.field_146297_k.func_71371_a(this.worldName, this.txtWorldName.func_146179_b().trim(), worldsettings);
                }
                if (button.field_146127_k == 11) {
                    this.bonusChest = !this.bonusChest;
                    this.btnBonusChest.field_146126_j = this.bonusChest ? I18n.func_135052_a((String)"selectWorld.bonusItems", (Object[])new Object[0]) + " " + I18n.func_135052_a((String)"options.on", (Object[])new Object[0]) : I18n.func_135052_a((String)"selectWorld.bonusItems", (Object[])new Object[0]) + " " + I18n.func_135052_a((String)"options.off", (Object[])new Object[0]);
                }
                if (button.field_146127_k == 12) {
                    ++this.gameMode;
                    if (this.gameMode > 2) {
                        this.gameMode = 0;
                    }
                    this.btnGameMode.field_146126_j = I18n.func_135052_a((String)(this.gameMode == 0 ? "Creative" : (this.gameMode == 1 ? "Survival" : (this.gameMode == 2 ? "Adventure" : "Creative"))), (Object[])new Object[0]);
                }
            }
        }

        public void func_73878_a(boolean ok, int worldId) {
            if (ok) {
                File TCWorldsDirectory = new File(TerrainControl.getEngine().getTCDataFolder().getAbsolutePath() + "/worlds");
                if (TCWorldsDirectory.exists() && TCWorldsDirectory.isDirectory()) {
                    for (File worldDir : TCWorldsDirectory.listFiles()) {
                        if (!worldDir.isDirectory() || !worldDir.getName().equals(this.worldNameToDelete)) continue;
                        WorldCreationMenuHandler.deleteRecursive(worldDir);
                        break;
                    }
                }
                ISaveFormat isaveformat = this.field_146297_k.func_71359_d();
                isaveformat.func_75800_d();
                isaveformat.func_75802_e(this.worldNameToDelete);
            }
            this.field_146297_k.func_147108_a((GuiScreen)new MCWGuiCreateWorld(new GuiSelectCreateWorldMode()));
        }

        public GuiYesNo askDeleteSettings(GuiYesNoCallback p_152129_0_, String worldName) {
            String s1 = "Delete the TC world settings for '" + worldName + "'?";
            String s2 = "This will also delete any world (directory) named '" + worldName + "'";
            String s3 = "Delete";
            String s4 = "Cancel";
            GuiYesNo guiyesno = new GuiYesNo(p_152129_0_, s1, s2, s3, s4, 0);
            return guiyesno;
        }

        protected void func_73869_a(char p_73869_1_, int p_73869_2_) {
            if (this.txtWorldName.func_146206_l()) {
                this.txtWorldName.func_146201_a(p_73869_1_, p_73869_2_);
                this.worldName2 = this.txtWorldName.func_146179_b();
            } else if (this.txtSeed.func_146206_l()) {
                this.txtSeed.func_146201_a(p_73869_1_, p_73869_2_);
                this.seed = this.txtSeed.func_146179_b();
            }
            if (p_73869_2_ == 28 || p_73869_2_ == 156) {
                this.func_146284_a((GuiButton)this.field_146292_n.get(0));
            }
            this.updateWorldName(false);
        }

        protected void func_73864_a(int p_73864_1_, int p_73864_2_, int p_73864_3_) {
            super.func_73864_a(p_73864_1_, p_73864_2_, p_73864_3_);
            this.txtSeed.func_146192_a(p_73864_1_, p_73864_2_, p_73864_3_);
            this.txtWorldName.func_146192_a(p_73864_1_, p_73864_2_, p_73864_3_);
        }

        public void func_73863_a(int p_73863_1_, int p_73863_2_, float p_73863_3_) {
            this.func_146276_q_();
            this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"Create a new TC world", (Object[])new Object[0]), this.field_146294_l / 2, 20, -1);
            this.func_73731_b(this.field_146289_q, I18n.func_135052_a((String)"selectWorld.enterName", (Object[])new Object[0]), this.field_146294_l / 2 - 155, this.yoffset + 42, -6250336);
            this.func_73731_b(this.field_146289_q, this.worldNameHelpText, this.field_146294_l / 2 - 155, this.yoffset + 82, -6250336);
            this.txtWorldName.func_146194_f();
            this.func_73731_b(this.field_146289_q, I18n.func_135052_a((String)"Existing world settings", (Object[])new Object[0]), this.field_146294_l / 2 + 20, this.yoffset + 42, -6250336);
            this.func_73731_b(this.field_146289_q, I18n.func_135052_a((String)"selectWorld.enterSeed", (Object[])new Object[0]), this.field_146294_l / 2 - 155, this.yoffset + 102, -6250336);
            this.func_73731_b(this.field_146289_q, I18n.func_135052_a((String)"selectWorld.seedInfo", (Object[])new Object[0]), this.field_146294_l / 2 - 155, this.yoffset + 140, -6250336);
            this.txtSeed.func_146194_f();
            super.func_73863_a(p_73863_1_, p_73863_2_, p_73863_3_);
        }

        public void func_146318_a(WorldInfo worldInfo) {
            this.worldName2 = I18n.func_135052_a((String)"selectWorld.newWorld.copyOf", (Object[])new Object[]{worldInfo.func_76065_j()});
            this.seed = worldInfo.func_76063_b() + "";
        }
    }

    @SideOnly(value=Side.CLIENT)
    public class GuiSelectCreateWorldMode
    extends GuiScreen {
        GuiButton mcw;
        GuiButton vanilla;
        GuiButton cancel;

        public void func_73863_a(int x, int y, float f) {
            this.func_146276_q_();
            super.func_73863_a(x, y, f);
        }

        public void func_73866_w_() {
            super.func_73866_w_();
            this.mcw = new GuiButton(0, this.field_146294_l / 2 - 100, this.field_146295_m / 2 - 32, "TerrainControl");
            this.field_146292_n.add(this.mcw);
            this.vanilla = new GuiButton(1, this.field_146294_l / 2 - 100, this.field_146295_m / 2 - 4, "Vanilla");
            this.field_146292_n.add(this.vanilla);
            this.cancel = new GuiButton(2, this.field_146294_l / 2 - 100, this.field_146295_m / 2 + 24, "Cancel");
            this.field_146292_n.add(this.cancel);
        }

        protected void func_146284_a(GuiButton button) {
            super.func_146284_a(button);
            if (button.field_146124_l) {
                if (button == this.cancel) {
                    this.field_146297_k.func_147108_a((GuiScreen)new GuiSelectWorld((GuiScreen)new GuiMainMenu()));
                }
                if (button == this.mcw) {
                    this.field_146297_k.func_147108_a((GuiScreen)new MCWGuiCreateWorld(this));
                    if (this.field_146297_k.field_71462_r == null) {
                        this.field_146297_k.func_71381_h();
                    }
                }
                if (button == this.vanilla) {
                    WorldCreationMenuHandler.this.selecting = true;
                    this.field_146297_k.func_147108_a((GuiScreen)new GuiCreateWorld((GuiScreen)this));
                    if (this.field_146297_k.field_71462_r == null) {
                        this.field_146297_k.func_71381_h();
                    }
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public class MCWGuiSelectWorld
    extends GuiSelectWorld {
        boolean derping;
        String worldName;

        public MCWGuiSelectWorld(GuiScreen p_i1054_1_) {
            super(p_i1054_1_);
        }

        public GuiYesNo askDeleteSettings(GuiYesNoCallback p_152129_0_, String worldName, int worldId) {
            String s1 = "Delete the TC world settings for '" + worldName + "' or keep them for re-use?";
            String s2 = "If you are using a TC biome pack then keep the settings!";
            String s3 = "Keep";
            String s4 = "Delete";
            GuiYesNo guiyesno = new GuiYesNo(p_152129_0_, s1, s2, s3, s4, worldId);
            return guiyesno;
        }

        public void func_73878_a(boolean ok, int worldId) {
            if (!this.derping) {
                if (ok) {
                    this.derping = true;
                    this.worldName = this.func_146621_a(worldId);
                    super.func_73878_a(ok, worldId);
                    boolean bExists = false;
                    File TCWorldsDirectory = new File(TerrainControl.getEngine().getTCDataFolder().getAbsolutePath() + "/worlds");
                    if (TCWorldsDirectory.exists() && TCWorldsDirectory.isDirectory()) {
                        for (File worldDir : TCWorldsDirectory.listFiles()) {
                            if (!worldDir.isDirectory() || !worldDir.getName().equals(this.worldName)) continue;
                            bExists = true;
                            break;
                        }
                    }
                    if (bExists) {
                        GuiYesNo guiyesno = this.askDeleteSettings((GuiYesNoCallback)this, this.worldName, worldId);
                        this.field_146297_k.func_147108_a((GuiScreen)guiyesno);
                    }
                } else {
                    super.func_73878_a(ok, worldId);
                }
            } else {
                File TCWorldsDirectory;
                this.derping = false;
                if (!ok && (TCWorldsDirectory = new File(TerrainControl.getEngine().getTCDataFolder().getAbsolutePath() + "/worlds")).exists() && TCWorldsDirectory.isDirectory()) {
                    for (File worldDir : TCWorldsDirectory.listFiles()) {
                        if (!worldDir.isDirectory() || !worldDir.getName().equals(this.worldName)) continue;
                        WorldCreationMenuHandler.deleteRecursive(worldDir);
                        break;
                    }
                }
                this.field_146297_k.func_147108_a((GuiScreen)new GuiSelectWorld((GuiScreen)new GuiMainMenu()));
            }
        }
    }
}

