/*
 * Decompiled with CFR 0.152.
 */
package com.khorn.terraincontrol.forge.generator;

import com.khorn.terraincontrol.BiomeIds;
import com.khorn.terraincontrol.configuration.BiomeConfig;
import com.khorn.terraincontrol.configuration.WeightedMobSpawnGroup;
import com.khorn.terraincontrol.forge.util.MobSpawnGroupHelper;
import java.util.List;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.world.ColorizerFoliage;
import net.minecraft.world.biome.BiomeGenBase;

public class BiomeGenCustom
extends BiomeGenBase {
    private int skyColor;
    private int grassColor;
    private boolean grassColorIsMultiplier;
    private int foliageColor;
    private boolean foliageColorIsMultiplier;
    private boolean grassColorSet = false;
    private boolean foliageColorSet = false;
    public final int generationId;

    public BiomeGenCustom(BiomeConfig config, BiomeIds id) {
        super(id.getSavedId(), !id.isVirtual());
        this.func_76735_a(config.getName());
        this.generationId = id.getGenerationId();
    }

    public void setEffects(BiomeConfig config) {
        this.field_76750_F = config.biomeTemperature;
        this.field_76751_G = config.biomeWetness;
        if (this.field_76751_G == 0.0f) {
            this.func_76745_m();
        }
        this.field_76759_H = config.waterColor;
        this.skyColor = config.skyColor;
        this.grassColor = config.grassColor;
        this.grassColorIsMultiplier = config.grassColorIsMultiplier;
        this.foliageColor = config.foliageColor;
        this.foliageColorIsMultiplier = config.foliageColorIsMultiplier;
        if (this.grassColor != 0xFFFFFF) {
            this.grassColorSet = true;
        }
        if (this.foliageColor != 0xFFFFFF) {
            this.foliageColorSet = true;
        }
        this.addMobs(this.field_76761_J, config.spawnMonsters);
        this.addMobs(this.field_76762_K, config.spawnCreatures);
        this.addMobs(this.field_76755_L, config.spawnWaterCreatures);
        this.addMobs(this.field_82914_M, config.spawnAmbientCreatures);
    }

    protected void addMobs(List<BiomeGenBase.SpawnListEntry> internalList, List<WeightedMobSpawnGroup> configList) {
        internalList.clear();
        internalList.addAll(MobSpawnGroupHelper.toMinecraftlist(configList));
    }

    public void copyBiome(BiomeGenBase baseBiome) {
        this.field_76753_B = baseBiome.field_76753_B;
        this.field_76752_A = baseBiome.field_76752_A;
        this.field_76790_z = baseBiome.field_76790_z;
        this.field_76748_D = baseBiome.field_76748_D;
        this.field_76749_E = baseBiome.field_76749_E;
        this.field_76750_F = baseBiome.field_76750_F;
        this.field_76760_I = baseBiome.field_76760_I;
        this.field_76759_H = baseBiome.field_76759_H;
        this.field_76761_J = baseBiome.func_76747_a(EnumCreatureType.monster);
        this.field_76762_K = baseBiome.func_76747_a(EnumCreatureType.creature);
        this.field_76755_L = baseBiome.func_76747_a(EnumCreatureType.waterCreature);
        this.field_82914_M = baseBiome.func_76747_a(EnumCreatureType.ambient);
    }

    public int func_76731_a(float v) {
        return this.skyColor;
    }

    public int getModdedBiomeGrassColor(int original) {
        if (!this.grassColorSet) {
            return original;
        }
        if (this.grassColorIsMultiplier) {
            return ((ColorizerFoliage.func_77470_a((double)Math.min(this.field_76750_F, 1.0f), (double)this.field_76751_G) & 0xFEFEFE) + this.grassColor) / 2;
        }
        return this.grassColor;
    }

    public int getModdedBiomeFoliageColor(int original) {
        if (!this.foliageColorSet) {
            return original;
        }
        if (this.foliageColorIsMultiplier) {
            return ((ColorizerFoliage.func_77470_a((double)Math.min(this.field_76750_F, 1.0f), (double)this.field_76751_G) & 0xFEFEFE) + this.foliageColor) / 2;
        }
        return this.foliageColor;
    }

    public String toString() {
        return "BiomeGenCustom of " + this.field_76791_y;
    }
}

