/*
 * Decompiled with CFR 0.152.
 */
package com.khorn.terraincontrol.forge.generator.structure;

import com.khorn.terraincontrol.LocalWorld;
import com.khorn.terraincontrol.configuration.BiomeConfig;
import com.khorn.terraincontrol.forge.util.WorldHelper;
import java.util.Random;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.ComponentScatteredFeaturePieces;
import net.minecraft.world.gen.structure.StructureStart;

public class RareBuildingStart
extends StructureStart {
    public RareBuildingStart(World world, Random random, int chunkX, int chunkZ) {
        ComponentScatteredFeaturePieces.DesertPyramid building;
        LocalWorld localWorld = WorldHelper.toLocalWorld(world);
        BiomeConfig biomeConfig = localWorld.getBiome(chunkX * 16 + 8, chunkZ * 16 + 8).getBiomeConfig();
        switch (biomeConfig.rareBuildingType) {
            case desertPyramid: {
                building = new ComponentScatteredFeaturePieces.DesertPyramid(random, chunkX * 16, chunkZ * 16);
                break;
            }
            case jungleTemple: {
                building = new ComponentScatteredFeaturePieces.JunglePyramid(random, chunkX * 16, chunkZ * 16);
                break;
            }
            case swampHut: {
                building = new ComponentScatteredFeaturePieces.SwampHut(random, chunkX * 16, chunkZ * 16);
                break;
            }
            default: {
                building = null;
            }
        }
        if (building != null) {
            this.field_75075_a.add(building);
        }
        this.func_75072_c();
    }

    public RareBuildingStart() {
    }
}

