/*
 * Decompiled with CFR 0.152.
 */
package com.khorn.terraincontrol.forge.generator.structure;

import com.khorn.terraincontrol.LocalBiome;
import com.khorn.terraincontrol.configuration.WorldSettings;
import com.khorn.terraincontrol.forge.ForgeBiome;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.structure.MapGenStronghold;
import net.minecraft.world.gen.structure.MapGenStructure;
import net.minecraft.world.gen.structure.StructureStart;
import net.minecraft.world.gen.structure.StructureStrongholdPieces;

public class StrongholdGen
extends MapGenStructure {
    private List<BiomeGenBase> allowedBiomeGenBases;
    private boolean ranBiomeCheck;
    private ChunkCoordIntPair[] structureCoords;
    private double distance;
    private int spread;

    public StrongholdGen(WorldSettings configs) {
        this.distance = configs.worldConfig.strongholdDistance;
        this.structureCoords = new ChunkCoordIntPair[configs.worldConfig.strongholdCount];
        this.spread = configs.worldConfig.strongholdSpread;
        this.allowedBiomeGenBases = new ArrayList<BiomeGenBase>();
        for (LocalBiome biome : configs.biomes) {
            if (biome == null || !biome.getBiomeConfig().strongholdsEnabled) continue;
            this.allowedBiomeGenBases.add(((ForgeBiome)biome).getHandle());
        }
    }

    protected boolean func_75047_a(int par1, int par2) {
        ChunkCoordIntPair[] structureCoordsLocal;
        if (!this.ranBiomeCheck) {
            Random random = new Random();
            random.setSeed(this.field_75039_c.func_72905_C());
            double randomNumBetween0and2PI = random.nextDouble() * Math.PI * 2.0;
            int var6 = 1;
            for (int i = 0; i < this.structureCoords.length; ++i) {
                double var8 = (1.25 * (double)var6 + random.nextDouble()) * this.distance * (double)var6;
                int var10 = (int)Math.round(Math.cos(randomNumBetween0and2PI) * var8);
                int var11 = (int)Math.round(Math.sin(randomNumBetween0and2PI) * var8);
                ArrayList var12 = new ArrayList();
                Collections.addAll(var12, this.allowedBiomeGenBases);
                ChunkPosition var13 = this.field_75039_c.func_72959_q().func_150795_a((var10 << 4) + 8, (var11 << 4) + 8, 112, var12, random);
                if (var13 != null) {
                    var10 = var13.field_151329_a >> 4;
                    var11 = var13.field_151328_c >> 4;
                }
                this.structureCoords[i] = new ChunkCoordIntPair(var10, var11);
                randomNumBetween0and2PI += Math.PI * 2 * (double)var6 / (double)this.spread;
                if (i != this.spread) continue;
                var6 += 2 + random.nextInt(5);
                this.spread += 1 + random.nextInt(2);
            }
            this.ranBiomeCheck = true;
        }
        for (ChunkCoordIntPair structureCoord : structureCoordsLocal = this.structureCoords) {
            if (par1 != structureCoord.field_77276_a || par2 != structureCoord.field_77275_b) continue;
            return true;
        }
        return false;
    }

    protected List<ChunkPosition> func_75052_o_() {
        ArrayList<ChunkPosition> chunkPositions = new ArrayList<ChunkPosition>();
        for (ChunkCoordIntPair structureCoord : this.structureCoords) {
            if (structureCoord == null) continue;
            chunkPositions.add(structureCoord.func_151349_a(64));
        }
        return chunkPositions;
    }

    protected StructureStart func_75049_b(int par1, int par2) {
        MapGenStronghold.Start start = new MapGenStronghold.Start(this.field_75039_c, this.field_75038_b, par1, par2);
        while (start.func_75073_b().isEmpty() || ((StructureStrongholdPieces.Stairs2)start.func_75073_b().get((int)0)).field_75025_b == null) {
            start = new MapGenStronghold.Start(this.field_75039_c, this.field_75038_b, par1, par2);
        }
        return start;
    }

    public String func_143025_a() {
        return "Stronghold";
    }
}

