/*
 * Decompiled with CFR 0.152.
 */
package com.khorn.terraincontrol.forge.generator.structure;

import com.khorn.terraincontrol.LocalBiome;
import com.khorn.terraincontrol.LocalWorld;
import com.khorn.terraincontrol.TerrainControl;
import com.khorn.terraincontrol.configuration.BiomeConfig;
import com.khorn.terraincontrol.forge.util.WorldHelper;
import com.khorn.terraincontrol.logging.LogMarker;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Random;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.StructureStart;
import net.minecraft.world.gen.structure.StructureVillagePieces;

public class VillageStart
extends StructureStart {
    private boolean hasMoreThanTwoComponents = false;

    public VillageStart(World world, Random random, int chunkX, int chunkZ, int size) {
        int var10;
        List villagePieces = StructureVillagePieces.func_75084_a((Random)random, (int)size);
        int startX = (chunkX << 4) + 2;
        int startZ = (chunkZ << 4) + 2;
        StructureVillagePieces.Start startPiece = new StructureVillagePieces.Start(world.func_72959_q(), 0, random, startX, startZ, villagePieces, size);
        LocalWorld worldTC = WorldHelper.toLocalWorld(world);
        LocalBiome currentBiome = worldTC.getBiome(startX, startZ);
        BiomeConfig config = currentBiome.getBiomeConfig();
        if (config != null) {
            this.changeToSandstoneVillage(startPiece, config.villageType == BiomeConfig.VillageType.sandstone);
        }
        this.field_75075_a.add(startPiece);
        startPiece.func_74861_a((StructureComponent)startPiece, (List)this.field_75075_a, random);
        List var8 = startPiece.field_74930_j;
        List var9 = startPiece.field_74932_i;
        while (!var8.isEmpty() || !var9.isEmpty()) {
            StructureComponent var11;
            if (var8.isEmpty()) {
                var10 = random.nextInt(var9.size());
                var11 = (StructureComponent)var9.remove(var10);
                var11.func_74861_a((StructureComponent)startPiece, (List)this.field_75075_a, random);
                continue;
            }
            var10 = random.nextInt(var8.size());
            var11 = (StructureComponent)var8.remove(var10);
            var11.func_74861_a((StructureComponent)startPiece, (List)this.field_75075_a, random);
        }
        this.func_75072_c();
        var10 = 0;
        for (Object component : this.field_75075_a) {
            StructureComponent var12 = (StructureComponent)component;
            if (var12 instanceof StructureVillagePieces.Road) continue;
            ++var10;
        }
        this.hasMoreThanTwoComponents = var10 > 2;
    }

    private void changeToSandstoneVillage(StructureVillagePieces.Start subject, boolean sandstoneVillage) {
        for (Field field : StructureVillagePieces.Start.class.getFields()) {
            if (!field.getType().toString().equals("boolean")) continue;
            try {
                field.setAccessible(true);
                field.setBoolean(subject, sandstoneVillage);
                break;
            }
            catch (Exception e) {
                TerrainControl.log(LogMarker.FATAL, "Cannot make village a sandstone village!", new Object[0]);
                TerrainControl.printStackTrace(LogMarker.FATAL, e);
            }
        }
    }

    public boolean func_75069_d() {
        return this.hasMoreThanTwoComponents;
    }

    public VillageStart() {
    }
}

