/*
 * Decompiled with CFR 0.152.
 */
package com.khorn.terraincontrol.forge.util;

import com.khorn.terraincontrol.TerrainControl;
import com.khorn.terraincontrol.configuration.WeightedMobSpawnGroup;
import com.khorn.terraincontrol.configuration.standard.MojangSettings;
import com.khorn.terraincontrol.logging.LogMarker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.world.biome.BiomeGenBase;

public final class MobSpawnGroupHelper {
    private static final Map<Class<? extends Entity>, String> CLASS_TO_NAME_MAP;
    private static final Map<String, Class<? extends Entity>> NAME_TO_CLASS_MAP;

    private static EnumCreatureType toEnumCreatureType(MojangSettings.EntityCategory type) {
        switch (type) {
            case MONSTER: {
                return EnumCreatureType.monster;
            }
            case CREATURE: {
                return EnumCreatureType.creature;
            }
            case AMBIENT_CREATURE: {
                return EnumCreatureType.ambient;
            }
            case WATER_CREATURE: {
                return EnumCreatureType.creature;
            }
        }
        throw new AssertionError((Object)("Unknown mob type: " + (Object)((Object)type)));
    }

    private static WeightedMobSpawnGroup fromMinecraftGroup(BiomeGenBase.SpawnListEntry biomeMeta) {
        return new WeightedMobSpawnGroup(MobSpawnGroupHelper.fromMinecraftClass(biomeMeta.field_76300_b), biomeMeta.field_76292_a, biomeMeta.field_76301_c, biomeMeta.field_76299_d);
    }

    public static List<WeightedMobSpawnGroup> getListFromMinecraftBiome(BiomeGenBase biome, MojangSettings.EntityCategory type) {
        List mobList = biome.func_76747_a(MobSpawnGroupHelper.toEnumCreatureType(type));
        return MobSpawnGroupHelper.fromMinecraftList(mobList);
    }

    static List<WeightedMobSpawnGroup> fromMinecraftList(Collection<BiomeGenBase.SpawnListEntry> biomeMetas) {
        ArrayList<WeightedMobSpawnGroup> result = new ArrayList<WeightedMobSpawnGroup>();
        for (BiomeGenBase.SpawnListEntry meta : biomeMetas) {
            result.add(MobSpawnGroupHelper.fromMinecraftGroup(meta));
        }
        return result;
    }

    public static List<BiomeGenBase.SpawnListEntry> toMinecraftlist(Collection<WeightedMobSpawnGroup> weightedMobSpawnGroups) {
        ArrayList<BiomeGenBase.SpawnListEntry> biomeList = new ArrayList<BiomeGenBase.SpawnListEntry>();
        for (WeightedMobSpawnGroup mobGroup : weightedMobSpawnGroups) {
            Class<? extends Entity> entityClass = MobSpawnGroupHelper.toMinecraftClass(mobGroup.getInternalName());
            if (entityClass != null) {
                biomeList.add(new BiomeGenBase.SpawnListEntry(entityClass, mobGroup.getWeight(), mobGroup.getMin(), mobGroup.getMax()));
                continue;
            }
            TerrainControl.log(LogMarker.WARN, "Mob type {} not found", mobGroup.getInternalName());
        }
        return biomeList;
    }

    static Class<? extends Entity> toMinecraftClass(String mobName) {
        return NAME_TO_CLASS_MAP.get(mobName);
    }

    private static String fromMinecraftClass(Class<?> entityClass) {
        return CLASS_TO_NAME_MAP.get(entityClass);
    }

    static {
        Map nameToClassMap;
        Map classToNameMap;
        CLASS_TO_NAME_MAP = classToNameMap = EntityList.field_75626_c;
        NAME_TO_CLASS_MAP = nameToClassMap = EntityList.field_75625_b;
    }
}

