/*
 * Decompiled with CFR 0.152.
 */
package com.khorn.terraincontrol.generator.biome;

import com.khorn.terraincontrol.LocalWorld;
import com.khorn.terraincontrol.generator.biome.ArraysCache;
import com.khorn.terraincontrol.generator.biome.ArraysCacheManager;
import com.khorn.terraincontrol.generator.biome.BiomeGenerator;
import com.khorn.terraincontrol.generator.biome.OutputType;
import com.khorn.terraincontrol.generator.biome.layers.Layer;

public abstract class LayeredBiomeGenerator
extends BiomeGenerator {
    private Layer unZoomedLayer;
    private Layer biomeLayer;
    private OutputType defaultOutputType = OutputType.FULL;

    public LayeredBiomeGenerator(LocalWorld world) {
        super(world);
        Layer[] layers = this.initLayers();
        if (world.getConfigs().getWorldConfig().improvedRivers) {
            this.defaultOutputType = OutputType.WITHOUT_RIVERS;
        }
        this.unZoomedLayer = layers[0];
        this.biomeLayer = layers[1];
    }

    protected abstract Layer[] initLayers();

    @Override
    public int[] getBiomesUnZoomed(int[] biomeArray, int x, int z, int x_size, int z_size, OutputType outputType) {
        if (biomeArray == null || biomeArray.length < x_size * z_size) {
            biomeArray = new int[x_size * z_size];
        }
        ArraysCache cache = ArraysCacheManager.GetCache();
        cache.outputType = outputType == OutputType.DEFAULT_FOR_WORLD ? this.defaultOutputType : outputType;
        int[] arrayOfInt = this.unZoomedLayer.getInts(cache, x, z, x_size, z_size);
        ArraysCacheManager.ReleaseCache(cache);
        System.arraycopy(arrayOfInt, 0, biomeArray, 0, x_size * z_size);
        return biomeArray;
    }

    @Override
    public float[] getRainfall(float[] paramArrayOfFloat, int x, int y, int x_size, int z_size) {
        if (paramArrayOfFloat == null || paramArrayOfFloat.length < x_size * z_size) {
            paramArrayOfFloat = new float[x_size * z_size];
        }
        ArraysCache cache = ArraysCacheManager.GetCache();
        cache.outputType = this.defaultOutputType;
        int[] arrayOfInt = this.biomeLayer.getInts(cache, x, y, x_size, z_size);
        ArraysCacheManager.ReleaseCache(cache);
        for (int i = 0; i < x_size * z_size; ++i) {
            float f1;
            paramArrayOfFloat[i] = f1 = this.world.getBiomeById((int)arrayOfInt[i]).getBiomeConfig().biomeWetness;
        }
        return paramArrayOfFloat;
    }

    @Override
    public int[] getBiomes(int[] biomeArray, int x, int z, int x_size, int z_size, OutputType outputType) {
        ArraysCache cache;
        if (biomeArray == null || biomeArray.length < x_size * z_size) {
            biomeArray = new int[x_size * z_size];
        }
        if ((cache = ArraysCacheManager.GetCache()) == null) {
            return biomeArray;
        }
        cache.outputType = outputType == OutputType.DEFAULT_FOR_WORLD ? this.defaultOutputType : outputType;
        int[] arrayOfInt = this.biomeLayer.getInts(cache, x, z, x_size, z_size);
        ArraysCacheManager.ReleaseCache(cache);
        System.arraycopy(arrayOfInt, 0, biomeArray, 0, x_size * z_size);
        return biomeArray;
    }

    @Override
    public boolean canGenerateUnZoomed() {
        return true;
    }
}

