/*
 * Decompiled with CFR 0.152.
 */
package com.khorn.terraincontrol.generator.biome.layers;

import com.khorn.terraincontrol.LocalBiome;
import com.khorn.terraincontrol.generator.biome.ArraysCache;
import com.khorn.terraincontrol.generator.biome.layers.Layer;

public class LayerBiomeBeforeGroups
extends Layer {
    private LocalBiome[] biomes;
    private LocalBiome[] ice_biomes;

    public LayerBiomeBeforeGroups(long seed, Layer childLayer, LocalBiome[] biomes, LocalBiome[] ice_biomes) {
        super(seed);
        this.child = childLayer;
        this.biomes = biomes;
        this.ice_biomes = ice_biomes;
    }

    @Override
    public int[] getInts(ArraysCache cache, int x, int z, int xSize, int zSize) {
        int[] childInts = this.child.getInts(cache, x, z, xSize, zSize);
        int[] thisInts = cache.getArray(xSize * zSize);
        for (int i = 0; i < zSize; ++i) {
            for (int j = 0; j < xSize; ++j) {
                this.initChunkSeed(j + x, i + z);
                int currentPiece = childInts[j + i * xSize];
                if ((currentPiece & 0x3FF) == 0) {
                    LocalBiome biome;
                    if (this.biomes.length > 0 && (currentPiece & 0x1000) == 0) {
                        biome = this.biomes[this.nextInt(this.biomes.length)];
                        if (biome != null) {
                            currentPiece |= biome.getIds().getGenerationId();
                        }
                    } else if (this.ice_biomes.length > 0 && (currentPiece & 0x1000) != 0 && (biome = this.ice_biomes[this.nextInt(this.ice_biomes.length)]) != null) {
                        currentPiece |= biome.getIds().getGenerationId();
                    }
                }
                thisInts[j + i * xSize] = currentPiece;
            }
        }
        return thisInts;
    }
}

