/*
 * Decompiled with CFR 0.152.
 */
package com.khorn.terraincontrol.generator.biome.layers;

import com.khorn.terraincontrol.LocalBiome;
import com.khorn.terraincontrol.LocalWorld;
import com.khorn.terraincontrol.generator.biome.ArraysCache;
import com.khorn.terraincontrol.generator.biome.layers.Layer;

public class LayerBiomeBorder
extends Layer {
    private boolean[][] bordersFrom;
    private int[] bordersTo;

    public LayerBiomeBorder(long seed, LocalWorld world) {
        super(seed);
        this.bordersFrom = new boolean[world.getMaxBiomesCount()][];
        this.bordersTo = new int[world.getMaxBiomesCount()];
    }

    public void addBiome(LocalBiome replaceTo, int replaceFrom, LocalWorld world) {
        this.bordersFrom[replaceFrom] = new boolean[world.getMaxBiomesCount()];
        for (int i = 0; i < this.bordersFrom[replaceFrom].length; ++i) {
            LocalBiome biome = world.getBiomeByIdOrNull(i);
            this.bordersFrom[replaceFrom][i] = biome == null || !replaceTo.getBiomeConfig().notBorderNear.contains(biome.getName());
        }
        this.bordersTo[replaceFrom] = replaceTo.getIds().getGenerationId();
    }

    @Override
    public int[] getInts(ArraysCache cache, int x, int z, int xSize, int zSize) {
        int[] childInts = this.child.getInts(cache, x - 1, z - 1, xSize + 2, zSize + 2);
        int[] thisInts = cache.getArray(xSize * zSize);
        for (int zi = 0; zi < zSize; ++zi) {
            for (int xi = 0; xi < xSize; ++xi) {
                this.initChunkSeed(xi + x, zi + z);
                int selection = childInts[xi + 1 + (zi + 1) * (xSize + 2)];
                int biomeId = LayerBiomeBorder.getBiomeFromLayer(selection);
                if (this.bordersFrom[biomeId] != null) {
                    int northCheck = LayerBiomeBorder.getBiomeFromLayer(childInts[xi + 1 + zi * (xSize + 2)]);
                    int southCheck = LayerBiomeBorder.getBiomeFromLayer(childInts[xi + 1 + (zi + 2) * (xSize + 2)]);
                    int eastCheck = LayerBiomeBorder.getBiomeFromLayer(childInts[xi + 2 + (zi + 1) * (xSize + 2)]);
                    int westCheck = LayerBiomeBorder.getBiomeFromLayer(childInts[xi + (zi + 1) * (xSize + 2)]);
                    boolean[] biomeFrom = this.bordersFrom[biomeId];
                    if (biomeFrom[northCheck] && biomeFrom[eastCheck] && biomeFrom[westCheck] && biomeFrom[southCheck] && (northCheck != biomeId || eastCheck != biomeId || westCheck != biomeId || southCheck != biomeId)) {
                        selection = selection & 0x301800 | 0x400 | this.bordersTo[biomeId];
                    }
                }
                thisInts[xi + zi * xSize] = selection;
            }
        }
        return thisInts;
    }
}

