/*
 * Decompiled with CFR 0.152.
 */
package com.khorn.terraincontrol.generator.resource;

import com.khorn.terraincontrol.LocalWorld;
import com.khorn.terraincontrol.configuration.BiomeConfig;
import com.khorn.terraincontrol.configuration.ConfigFunction;
import com.khorn.terraincontrol.customobjects.CustomObject;
import com.khorn.terraincontrol.exception.InvalidConfigException;
import com.khorn.terraincontrol.generator.resource.SaplingType;
import com.khorn.terraincontrol.util.Rotation;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Random;

public class SaplingGen
extends ConfigFunction<BiomeConfig> {
    public List<CustomObject> trees;
    public List<String> treeNames;
    public List<Integer> treeChances;
    public SaplingType saplingType;
    private static final Map<Rotation, int[]> TREE_OFFSET = new EnumMap<Rotation, int[]>(Rotation.class);

    @Override
    public Class<BiomeConfig> getHolderType() {
        return BiomeConfig.class;
    }

    @Override
    public void load(List<String> args) throws InvalidConfigException {
        this.assureSize(3, args);
        this.saplingType = SaplingType.get(args.get(0));
        if (this.saplingType == null) {
            throw new InvalidConfigException("Unknown sapling type " + args.get(0));
        }
        this.trees = new ArrayList<CustomObject>();
        this.treeNames = new ArrayList<String>();
        this.treeChances = new ArrayList<Integer>();
        for (int i = 1; i < args.size() - 1; i += 2) {
            CustomObject object = ((BiomeConfig)this.getHolder()).worldConfig.worldObjects.parseCustomObject(args.get(i));
            if (object == null) {
                throw new InvalidConfigException("Custom object " + args.get(i) + " not found!");
            }
            if (!object.canSpawnAsTree()) {
                throw new InvalidConfigException("Custom object " + args.get(i) + " is not a tree!");
            }
            this.trees.add(object);
            this.treeNames.add(args.get(i));
            this.treeChances.add(this.readInt(args.get(i + 1), 1, 100));
        }
    }

    @Override
    public String makeString() {
        String output = "Sapling(" + (Object)((Object)this.saplingType);
        for (int i = 0; i < this.treeNames.size(); ++i) {
            output = output + "," + this.treeNames.get(i) + "," + this.treeChances.get(i);
        }
        return output + ")";
    }

    public boolean growSapling(LocalWorld world, Random random, boolean isWideTree, int x, int y, int z) {
        for (int treeNumber = 0; treeNumber < this.trees.size(); ++treeNumber) {
            if (random.nextInt(100) >= this.treeChances.get(treeNumber)) continue;
            CustomObject tree = this.trees.get(treeNumber);
            Rotation rotation = tree.canRotateRandomly() ? Rotation.getRandomRotation(random) : Rotation.NORTH;
            int spawnX = x;
            int spawnZ = z;
            if (isWideTree) {
                int[] offset = TREE_OFFSET.get((Object)rotation);
                spawnX += offset[0];
                spawnZ += offset[1];
            }
            if (!tree.spawnForced(world, random, rotation, spawnX, y, spawnZ)) continue;
            return true;
        }
        return false;
    }

    public int hashCode() {
        int hash = 7;
        hash = 37 * hash + (this.trees != null ? this.trees.hashCode() : 0);
        hash = 37 * hash + (this.treeNames != null ? this.treeNames.hashCode() : 0);
        hash = 37 * hash + (this.treeChances != null ? this.treeChances.hashCode() : 0);
        hash = 37 * hash + (this.saplingType != null ? this.saplingType.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        SaplingGen compare = (SaplingGen)other;
        return this.saplingType == compare.saplingType && (this.treeNames == null ? this.treeNames == compare.treeNames : this.treeNames.equals(compare.treeNames)) && (this.treeNames == null ? this.treeNames == compare.treeNames : this.treeNames.equals(compare.treeNames)) && (this.treeChances == null ? this.treeChances == compare.treeChances : this.treeChances.equals(compare.treeChances));
    }

    @Override
    public boolean isAnalogousTo(ConfigFunction<BiomeConfig> other) {
        return other.getClass().equals(this.getClass()) && this.saplingType.equals((Object)((SaplingGen)other).saplingType);
    }

    static {
        TREE_OFFSET.put(Rotation.NORTH, new int[]{0, 0});
        TREE_OFFSET.put(Rotation.EAST, new int[]{1, 0});
        TREE_OFFSET.put(Rotation.SOUTH, new int[]{1, 1});
        TREE_OFFSET.put(Rotation.WEST, new int[]{0, 1});
    }
}

