/*
 * Decompiled with CFR 0.152.
 */
package com.khorn.terraincontrol.generator.resource;

import com.khorn.terraincontrol.LocalMaterialData;
import com.khorn.terraincontrol.LocalWorld;
import com.khorn.terraincontrol.TerrainControl;
import com.khorn.terraincontrol.exception.InvalidConfigException;
import com.khorn.terraincontrol.generator.resource.Resource;
import com.khorn.terraincontrol.util.minecraftTypes.DefaultMaterial;
import java.util.List;
import java.util.Random;

public class VinesGen
extends Resource {
    private int minAltitude;
    private int maxAltitude;
    public static final int[] d = new int[]{-1, -1, 2, 0, 1, 3};
    public static final int[] OPPOSITE_FACING = new int[]{1, 0, 3, 2, 5, 4};

    @Override
    public void spawn(LocalWorld world, Random rand, boolean villageInChunk, int x, int z) {
        int _x = x;
        int _z = z;
        block0: for (int y = this.minAltitude; y < this.maxAltitude; ++y) {
            if (world.isEmpty(_x, y, _z)) {
                for (int direction = 2; direction <= 5; ++direction) {
                    if (!this.canPlace(world, _x, y, _z, direction)) continue;
                    world.setBlock(_x, y, _z, TerrainControl.toLocalMaterialData(DefaultMaterial.VINE, 1 << d[OPPOSITE_FACING[direction]]));
                    continue block0;
                }
                continue;
            }
            _x = x + rand.nextInt(4) - rand.nextInt(4);
            _z = z + rand.nextInt(4) - rand.nextInt(4);
        }
    }

    public boolean canPlace(LocalWorld world, int x, int y, int z, int paramInt4) {
        LocalMaterialData sourceBlock;
        switch (paramInt4) {
            default: {
                return false;
            }
            case 1: {
                sourceBlock = world.getMaterial(x, y + 1, z);
                break;
            }
            case 2: {
                sourceBlock = world.getMaterial(x, y, z + 1);
                break;
            }
            case 3: {
                sourceBlock = world.getMaterial(x, y, z - 1);
                break;
            }
            case 5: {
                sourceBlock = world.getMaterial(x - 1, y, z);
                break;
            }
            case 4: {
                sourceBlock = world.getMaterial(x + 1, y, z);
            }
        }
        return sourceBlock.isSolid();
    }

    @Override
    public void load(List<String> args) throws InvalidConfigException {
        this.material = TerrainControl.toLocalMaterialData(DefaultMaterial.VINE, 0);
        this.assureSize(4, args);
        this.frequency = this.readInt(args.get(0), 1, 100);
        this.rarity = this.readRarity(args.get(1));
        this.minAltitude = this.readInt(args.get(2), 0, 256);
        this.maxAltitude = this.readInt(args.get(3), this.minAltitude + 1, 256);
    }

    @Override
    public String makeString() {
        return "Vines(" + this.frequency + "," + this.rarity + "," + this.minAltitude + "," + this.maxAltitude + ")";
    }

    @Override
    public boolean equals(Object other) {
        if (!super.equals(other)) {
            return false;
        }
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        VinesGen compare = (VinesGen)other;
        return this.maxAltitude == compare.maxAltitude && this.minAltitude == compare.minAltitude;
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = 17 * hash + super.hashCode();
        hash = 17 * hash + this.minAltitude;
        hash = 17 * hash + this.maxAltitude;
        return hash;
    }
}

