/*
 * Decompiled with CFR 0.152.
 */
package com.khorn.terraincontrol.generator.terrain;

import com.khorn.terraincontrol.LocalMaterialData;
import com.khorn.terraincontrol.LocalWorld;
import com.khorn.terraincontrol.TerrainControl;
import com.khorn.terraincontrol.generator.ChunkBuffer;
import com.khorn.terraincontrol.util.ChunkCoordinate;
import com.khorn.terraincontrol.util.minecraftTypes.DefaultMaterial;
import java.util.Random;

public abstract class TerrainGenBase {
    protected final LocalMaterialData air = TerrainControl.toLocalMaterialData(DefaultMaterial.AIR, 0);
    protected final LocalMaterialData lava = TerrainControl.toLocalMaterialData(DefaultMaterial.STATIONARY_LAVA, 0);
    protected final LocalMaterialData sandstone = TerrainControl.toLocalMaterialData(DefaultMaterial.SANDSTONE, 0);
    protected final LocalMaterialData redSandstone = TerrainControl.toLocalMaterialData(DefaultMaterial.HARD_CLAY, 0);
    protected int checkAreaSize = 8;
    protected Random random = new Random();
    protected LocalWorld world;
    private final long worldLong1;
    private final long worldLong2;

    public TerrainGenBase(LocalWorld world) {
        this.world = world;
        this.random.setSeed(this.world.getSeed());
        this.worldLong1 = this.random.nextLong();
        this.worldLong2 = this.random.nextLong();
    }

    public void generate(ChunkBuffer chunkBuffer) {
        int i = this.checkAreaSize;
        ChunkCoordinate chunkCoord = chunkBuffer.getChunkCoordinate();
        int chunkX = chunkCoord.getChunkX();
        int chunkZ = chunkCoord.getChunkZ();
        for (int x = chunkX - i; x <= chunkX + i; ++x) {
            for (int z = chunkZ - i; z <= chunkZ + i; ++z) {
                long l3 = (long)x * this.worldLong1;
                long l4 = (long)z * this.worldLong2;
                this.random.setSeed(l3 ^ l4 ^ this.world.getSeed());
                this.generateChunk(ChunkCoordinate.fromChunkCoords(x, z), chunkBuffer);
            }
        }
    }

    protected abstract void generateChunk(ChunkCoordinate var1, ChunkBuffer var2);
}

