/*
 * Decompiled with CFR 0.152.
 */
package com.khorn.terraincontrol.util.helpers;

import com.khorn.terraincontrol.configuration.ConfigFunction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class InheritanceHelper {
    private InheritanceHelper() {
    }

    public static final <T, C extends ConfigFunction<T>> List<C> mergeLists(Collection<? extends C> childList, Collection<? extends C> parentList) {
        ArrayList<C> returnList = new ArrayList<C>(childList);
        for (ConfigFunction parentFunction : parentList) {
            if (InheritanceHelper.hasAnalogousFunction(parentFunction, childList)) continue;
            returnList.add(parentFunction);
        }
        return returnList;
    }

    private static final <T, C extends ConfigFunction<T>> boolean hasAnalogousFunction(C function, Collection<? extends C> list) {
        for (ConfigFunction toCheck : list) {
            if (!function.isAnalogousTo(toCheck)) continue;
            return true;
        }
        return false;
    }
}

